/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl;

import com.helger.commons.state.ESuccess;
import com.helger.ubl.AbstractUBLDocumentMarshaller;
import com.helger.ubl.EUBL21DocumentType;
import com.helger.ubl.UBL21Marshaller;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_21.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_21.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.awardednotification_21.AwardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.billoflading_21.BillOfLadingType;
import oasis.names.specification.ubl.schema.xsd.callfortenders_21.CallForTendersType;
import oasis.names.specification.ubl.schema.xsd.catalogue_21.CatalogueType;
import oasis.names.specification.ubl.schema.xsd.cataloguedeletion_21.CatalogueDeletionType;
import oasis.names.specification.ubl.schema.xsd.catalogueitemspecificationupdate_21.CatalogueItemSpecificationUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguepricingupdate_21.CataloguePricingUpdateType;
import oasis.names.specification.ubl.schema.xsd.cataloguerequest_21.CatalogueRequestType;
import oasis.names.specification.ubl.schema.xsd.certificateoforigin_21.CertificateOfOriginType;
import oasis.names.specification.ubl.schema.xsd.contractawardnotice_21.ContractAwardNoticeType;
import oasis.names.specification.ubl.schema.xsd.contractnotice_21.ContractNoticeType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_21.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.despatchadvice_21.DespatchAdviceType;
import oasis.names.specification.ubl.schema.xsd.documentstatus_21.DocumentStatusType;
import oasis.names.specification.ubl.schema.xsd.documentstatusrequest_21.DocumentStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.exceptioncriteria_21.ExceptionCriteriaType;
import oasis.names.specification.ubl.schema.xsd.exceptionnotification_21.ExceptionNotificationType;
import oasis.names.specification.ubl.schema.xsd.forecast_21.ForecastType;
import oasis.names.specification.ubl.schema.xsd.forecastrevision_21.ForecastRevisionType;
import oasis.names.specification.ubl.schema.xsd.forwardinginstructions_21.ForwardingInstructionsType;
import oasis.names.specification.ubl.schema.xsd.freightinvoice_21.FreightInvoiceType;
import oasis.names.specification.ubl.schema.xsd.fulfilmentcancellation_21.FulfilmentCancellationType;
import oasis.names.specification.ubl.schema.xsd.goodsitemitinerary_21.GoodsItemItineraryType;
import oasis.names.specification.ubl.schema.xsd.guaranteecertificate_21.GuaranteeCertificateType;
import oasis.names.specification.ubl.schema.xsd.instructionforreturns_21.InstructionForReturnsType;
import oasis.names.specification.ubl.schema.xsd.inventoryreport_21.InventoryReportType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.iteminformationrequest_21.ItemInformationRequestType;
import oasis.names.specification.ubl.schema.xsd.order_21.OrderType;
import oasis.names.specification.ubl.schema.xsd.ordercancellation_21.OrderCancellationType;
import oasis.names.specification.ubl.schema.xsd.orderchange_21.OrderChangeType;
import oasis.names.specification.ubl.schema.xsd.orderresponse_21.OrderResponseType;
import oasis.names.specification.ubl.schema.xsd.orderresponsesimple_21.OrderResponseSimpleType;
import oasis.names.specification.ubl.schema.xsd.packinglist_21.PackingListType;
import oasis.names.specification.ubl.schema.xsd.priorinformationnotice_21.PriorInformationNoticeType;
import oasis.names.specification.ubl.schema.xsd.productactivity_21.ProductActivityType;
import oasis.names.specification.ubl.schema.xsd.quotation_21.QuotationType;
import oasis.names.specification.ubl.schema.xsd.receiptadvice_21.ReceiptAdviceType;
import oasis.names.specification.ubl.schema.xsd.reminder_21.ReminderType;
import oasis.names.specification.ubl.schema.xsd.remittanceadvice_21.RemittanceAdviceType;
import oasis.names.specification.ubl.schema.xsd.requestforquotation_21.RequestForQuotationType;
import oasis.names.specification.ubl.schema.xsd.retailevent_21.RetailEventType;
import oasis.names.specification.ubl.schema.xsd.selfbilledcreditnote_21.SelfBilledCreditNoteType;
import oasis.names.specification.ubl.schema.xsd.selfbilledinvoice_21.SelfBilledInvoiceType;
import oasis.names.specification.ubl.schema.xsd.statement_21.StatementType;
import oasis.names.specification.ubl.schema.xsd.stockavailabilityreport_21.StockAvailabilityReportType;
import oasis.names.specification.ubl.schema.xsd.tender_21.TenderType;
import oasis.names.specification.ubl.schema.xsd.tendererqualification_21.TendererQualificationType;
import oasis.names.specification.ubl.schema.xsd.tendererqualificationresponse_21.TendererQualificationResponseType;
import oasis.names.specification.ubl.schema.xsd.tenderreceipt_21.TenderReceiptType;
import oasis.names.specification.ubl.schema.xsd.tradeitemlocationprofile_21.TradeItemLocationProfileType;
import oasis.names.specification.ubl.schema.xsd.transportationstatus_21.TransportationStatusType;
import oasis.names.specification.ubl.schema.xsd.transportationstatusrequest_21.TransportationStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplan_21.TransportExecutionPlanType;
import oasis.names.specification.ubl.schema.xsd.transportexecutionplanrequest_21.TransportExecutionPlanRequestType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatus_21.TransportProgressStatusType;
import oasis.names.specification.ubl.schema.xsd.transportprogressstatusrequest_21.TransportProgressStatusRequestType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescription_21.TransportServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.transportservicedescriptionrequest_21.TransportServiceDescriptionRequestType;
import oasis.names.specification.ubl.schema.xsd.unawardednotification_21.UnawardedNotificationType;
import oasis.names.specification.ubl.schema.xsd.utilitystatement_21.UtilityStatementType;
import oasis.names.specification.ubl.schema.xsd.waybill_21.WaybillType;
import org.w3c.dom.Document;

@NotThreadSafe
public final class UBL21Writer
extends AbstractUBLDocumentMarshaller {
    private static final UBL21Writer s_aInstance = new UBL21Writer();

    private UBL21Writer() {
    }

    @Nullable
    public static Document writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType) {
        return UBL21Writer.writeApplicationResponse(applicationResponseType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)applicationResponseType, EUBL21DocumentType.APPLICATION_RESPONSE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nonnull File file) {
        return UBL21Writer.writeApplicationResponse(applicationResponseType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeApplicationResponse(applicationResponseType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nonnull Result result) {
        return UBL21Writer.writeApplicationResponse(applicationResponseType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeApplicationResponse(@Nonnull ApplicationResponseType applicationResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(applicationResponseType, EUBL21DocumentType.APPLICATION_RESPONSE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType) {
        return UBL21Writer.writeAttachedDocument(attachedDocumentType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)attachedDocumentType, EUBL21DocumentType.ATTACHED_DOCUMENT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nonnull File file) {
        return UBL21Writer.writeAttachedDocument(attachedDocumentType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeAttachedDocument(attachedDocumentType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nonnull Result result) {
        return UBL21Writer.writeAttachedDocument(attachedDocumentType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeAttachedDocument(@Nonnull AttachedDocumentType attachedDocumentType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(attachedDocumentType, EUBL21DocumentType.ATTACHED_DOCUMENT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType) {
        return UBL21Writer.writeAwardedNotification(awardedNotificationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)awardedNotificationType, EUBL21DocumentType.AWARDED_NOTIFICATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType, @Nonnull File file) {
        return UBL21Writer.writeAwardedNotification(awardedNotificationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeAwardedNotification(awardedNotificationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType, @Nonnull Result result) {
        return UBL21Writer.writeAwardedNotification(awardedNotificationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeAwardedNotification(@Nonnull AwardedNotificationType awardedNotificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(awardedNotificationType, EUBL21DocumentType.AWARDED_NOTIFICATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType) {
        return UBL21Writer.writeBillOfLading(billOfLadingType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)billOfLadingType, EUBL21DocumentType.BILL_OF_LADING, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nonnull File file) {
        return UBL21Writer.writeBillOfLading(billOfLadingType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeBillOfLading(billOfLadingType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nonnull Result result) {
        return UBL21Writer.writeBillOfLading(billOfLadingType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeBillOfLading(@Nonnull BillOfLadingType billOfLadingType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(billOfLadingType, EUBL21DocumentType.BILL_OF_LADING, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCallForTenders(@Nonnull CallForTendersType callForTendersType) {
        return UBL21Writer.writeCallForTenders(callForTendersType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCallForTenders(@Nonnull CallForTendersType callForTendersType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)callForTendersType, EUBL21DocumentType.CALL_FOR_TENDERS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCallForTenders(@Nonnull CallForTendersType callForTendersType, @Nonnull File file) {
        return UBL21Writer.writeCallForTenders(callForTendersType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCallForTenders(@Nonnull CallForTendersType callForTendersType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCallForTenders(callForTendersType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCallForTenders(@Nonnull CallForTendersType callForTendersType, @Nonnull Result result) {
        return UBL21Writer.writeCallForTenders(callForTendersType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCallForTenders(@Nonnull CallForTendersType callForTendersType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(callForTendersType, EUBL21DocumentType.CALL_FOR_TENDERS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogue(@Nonnull CatalogueType catalogueType) {
        return UBL21Writer.writeCatalogue(catalogueType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogue(@Nonnull CatalogueType catalogueType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)catalogueType, EUBL21DocumentType.CATALOGUE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nonnull File file) {
        return UBL21Writer.writeCatalogue(catalogueType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCatalogue(catalogueType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nonnull Result result) {
        return UBL21Writer.writeCatalogue(catalogueType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogue(@Nonnull CatalogueType catalogueType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(catalogueType, EUBL21DocumentType.CATALOGUE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType) {
        return UBL21Writer.writeCatalogueDeletion(catalogueDeletionType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)catalogueDeletionType, EUBL21DocumentType.CATALOGUE_DELETION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nonnull File file) {
        return UBL21Writer.writeCatalogueDeletion(catalogueDeletionType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCatalogueDeletion(catalogueDeletionType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nonnull Result result) {
        return UBL21Writer.writeCatalogueDeletion(catalogueDeletionType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogueDeletion(@Nonnull CatalogueDeletionType catalogueDeletionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(catalogueDeletionType, EUBL21DocumentType.CATALOGUE_DELETION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType) {
        return UBL21Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)catalogueItemSpecificationUpdateType, EUBL21DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nonnull File file) {
        return UBL21Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nonnull Result result) {
        return UBL21Writer.writeCatalogueItemSpecificationUpdate(catalogueItemSpecificationUpdateType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogueItemSpecificationUpdate(@Nonnull CatalogueItemSpecificationUpdateType catalogueItemSpecificationUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(catalogueItemSpecificationUpdateType, EUBL21DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType) {
        return UBL21Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)cataloguePricingUpdateType, EUBL21DocumentType.CATALOGUE_PRICING_UPDATE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nonnull File file) {
        return UBL21Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nonnull Result result) {
        return UBL21Writer.writeCataloguePricingUpdate(cataloguePricingUpdateType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCataloguePricingUpdate(@Nonnull CataloguePricingUpdateType cataloguePricingUpdateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(cataloguePricingUpdateType, EUBL21DocumentType.CATALOGUE_PRICING_UPDATE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType) {
        return UBL21Writer.writeCatalogueRequest(catalogueRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)catalogueRequestType, EUBL21DocumentType.CATALOGUE_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nonnull File file) {
        return UBL21Writer.writeCatalogueRequest(catalogueRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCatalogueRequest(catalogueRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nonnull Result result) {
        return UBL21Writer.writeCatalogueRequest(catalogueRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCatalogueRequest(@Nonnull CatalogueRequestType catalogueRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(catalogueRequestType, EUBL21DocumentType.CATALOGUE_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType) {
        return UBL21Writer.writeCertificateOfOrigin(certificateOfOriginType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)certificateOfOriginType, EUBL21DocumentType.CERTIFICATE_OF_ORIGIN, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nonnull File file) {
        return UBL21Writer.writeCertificateOfOrigin(certificateOfOriginType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCertificateOfOrigin(certificateOfOriginType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nonnull Result result) {
        return UBL21Writer.writeCertificateOfOrigin(certificateOfOriginType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCertificateOfOrigin(@Nonnull CertificateOfOriginType certificateOfOriginType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(certificateOfOriginType, EUBL21DocumentType.CERTIFICATE_OF_ORIGIN, validationEventHandler, result);
    }

    @Nullable
    public static Document writeContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType) {
        return UBL21Writer.writeContractAwardNotice(contractAwardNoticeType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)contractAwardNoticeType, EUBL21DocumentType.CONTRACT_AWARD_NOTICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType, @Nonnull File file) {
        return UBL21Writer.writeContractAwardNotice(contractAwardNoticeType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeContractAwardNotice(contractAwardNoticeType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType, @Nonnull Result result) {
        return UBL21Writer.writeContractAwardNotice(contractAwardNoticeType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeContractAwardNotice(@Nonnull ContractAwardNoticeType contractAwardNoticeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(contractAwardNoticeType, EUBL21DocumentType.CONTRACT_AWARD_NOTICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeContractNotice(@Nonnull ContractNoticeType contractNoticeType) {
        return UBL21Writer.writeContractNotice(contractNoticeType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeContractNotice(@Nonnull ContractNoticeType contractNoticeType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)contractNoticeType, EUBL21DocumentType.CONTRACT_NOTICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeContractNotice(@Nonnull ContractNoticeType contractNoticeType, @Nonnull File file) {
        return UBL21Writer.writeContractNotice(contractNoticeType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeContractNotice(@Nonnull ContractNoticeType contractNoticeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeContractNotice(contractNoticeType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeContractNotice(@Nonnull ContractNoticeType contractNoticeType, @Nonnull Result result) {
        return UBL21Writer.writeContractNotice(contractNoticeType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeContractNotice(@Nonnull ContractNoticeType contractNoticeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(contractNoticeType, EUBL21DocumentType.CONTRACT_NOTICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeCreditNote(@Nonnull CreditNoteType creditNoteType) {
        return UBL21Writer.writeCreditNote(creditNoteType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)creditNoteType, EUBL21DocumentType.CREDIT_NOTE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nonnull File file) {
        return UBL21Writer.writeCreditNote(creditNoteType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeCreditNote(creditNoteType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nonnull Result result) {
        return UBL21Writer.writeCreditNote(creditNoteType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeCreditNote(@Nonnull CreditNoteType creditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(creditNoteType, EUBL21DocumentType.CREDIT_NOTE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeDebitNote(@Nonnull DebitNoteType debitNoteType) {
        return UBL21Writer.writeDebitNote(debitNoteType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)debitNoteType, EUBL21DocumentType.DEBIT_NOTE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nonnull File file) {
        return UBL21Writer.writeDebitNote(debitNoteType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeDebitNote(debitNoteType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nonnull Result result) {
        return UBL21Writer.writeDebitNote(debitNoteType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeDebitNote(@Nonnull DebitNoteType debitNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(debitNoteType, EUBL21DocumentType.DEBIT_NOTE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType) {
        return UBL21Writer.writeDespatchAdvice(despatchAdviceType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)despatchAdviceType, EUBL21DocumentType.DESPATCH_ADVICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nonnull File file) {
        return UBL21Writer.writeDespatchAdvice(despatchAdviceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeDespatchAdvice(despatchAdviceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nonnull Result result) {
        return UBL21Writer.writeDespatchAdvice(despatchAdviceType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeDespatchAdvice(@Nonnull DespatchAdviceType despatchAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(despatchAdviceType, EUBL21DocumentType.DESPATCH_ADVICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeDocumentStatus(@Nonnull DocumentStatusType documentStatusType) {
        return UBL21Writer.writeDocumentStatus(documentStatusType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeDocumentStatus(@Nonnull DocumentStatusType documentStatusType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)documentStatusType, EUBL21DocumentType.DOCUMENT_STATUS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeDocumentStatus(@Nonnull DocumentStatusType documentStatusType, @Nonnull File file) {
        return UBL21Writer.writeDocumentStatus(documentStatusType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDocumentStatus(@Nonnull DocumentStatusType documentStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeDocumentStatus(documentStatusType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDocumentStatus(@Nonnull DocumentStatusType documentStatusType, @Nonnull Result result) {
        return UBL21Writer.writeDocumentStatus(documentStatusType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeDocumentStatus(@Nonnull DocumentStatusType documentStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(documentStatusType, EUBL21DocumentType.DOCUMENT_STATUS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType) {
        return UBL21Writer.writeDocumentStatusRequest(documentStatusRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)documentStatusRequestType, EUBL21DocumentType.DOCUMENT_STATUS_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType, @Nonnull File file) {
        return UBL21Writer.writeDocumentStatusRequest(documentStatusRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeDocumentStatusRequest(documentStatusRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType, @Nonnull Result result) {
        return UBL21Writer.writeDocumentStatusRequest(documentStatusRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeDocumentStatusRequest(@Nonnull DocumentStatusRequestType documentStatusRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(documentStatusRequestType, EUBL21DocumentType.DOCUMENT_STATUS_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType) {
        return UBL21Writer.writeExceptionCriteria(exceptionCriteriaType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)exceptionCriteriaType, EUBL21DocumentType.EXCEPTION_CRITERIA, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType, @Nonnull File file) {
        return UBL21Writer.writeExceptionCriteria(exceptionCriteriaType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeExceptionCriteria(exceptionCriteriaType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType, @Nonnull Result result) {
        return UBL21Writer.writeExceptionCriteria(exceptionCriteriaType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeExceptionCriteria(@Nonnull ExceptionCriteriaType exceptionCriteriaType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(exceptionCriteriaType, EUBL21DocumentType.EXCEPTION_CRITERIA, validationEventHandler, result);
    }

    @Nullable
    public static Document writeExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType) {
        return UBL21Writer.writeExceptionNotification(exceptionNotificationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)exceptionNotificationType, EUBL21DocumentType.EXCEPTION_NOTIFICATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType, @Nonnull File file) {
        return UBL21Writer.writeExceptionNotification(exceptionNotificationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeExceptionNotification(exceptionNotificationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType, @Nonnull Result result) {
        return UBL21Writer.writeExceptionNotification(exceptionNotificationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeExceptionNotification(@Nonnull ExceptionNotificationType exceptionNotificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(exceptionNotificationType, EUBL21DocumentType.EXCEPTION_NOTIFICATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeForecast(@Nonnull ForecastType forecastType) {
        return UBL21Writer.writeForecast(forecastType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeForecast(@Nonnull ForecastType forecastType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)forecastType, EUBL21DocumentType.FORECAST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeForecast(@Nonnull ForecastType forecastType, @Nonnull File file) {
        return UBL21Writer.writeForecast(forecastType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForecast(@Nonnull ForecastType forecastType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeForecast(forecastType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForecast(@Nonnull ForecastType forecastType, @Nonnull Result result) {
        return UBL21Writer.writeForecast(forecastType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeForecast(@Nonnull ForecastType forecastType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(forecastType, EUBL21DocumentType.FORECAST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType) {
        return UBL21Writer.writeForecastRevision(forecastRevisionType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)forecastRevisionType, EUBL21DocumentType.FORECAST_REVISION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType, @Nonnull File file) {
        return UBL21Writer.writeForecastRevision(forecastRevisionType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeForecastRevision(forecastRevisionType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType, @Nonnull Result result) {
        return UBL21Writer.writeForecastRevision(forecastRevisionType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeForecastRevision(@Nonnull ForecastRevisionType forecastRevisionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(forecastRevisionType, EUBL21DocumentType.FORECAST_REVISION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType) {
        return UBL21Writer.writeForwardingInstructions(forwardingInstructionsType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)forwardingInstructionsType, EUBL21DocumentType.FORWARDING_INSTRUCTIONS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nonnull File file) {
        return UBL21Writer.writeForwardingInstructions(forwardingInstructionsType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeForwardingInstructions(forwardingInstructionsType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nonnull Result result) {
        return UBL21Writer.writeForwardingInstructions(forwardingInstructionsType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeForwardingInstructions(@Nonnull ForwardingInstructionsType forwardingInstructionsType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(forwardingInstructionsType, EUBL21DocumentType.FORWARDING_INSTRUCTIONS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType) {
        return UBL21Writer.writeFreightInvoice(freightInvoiceType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)freightInvoiceType, EUBL21DocumentType.FREIGHT_INVOICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nonnull File file) {
        return UBL21Writer.writeFreightInvoice(freightInvoiceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeFreightInvoice(freightInvoiceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nonnull Result result) {
        return UBL21Writer.writeFreightInvoice(freightInvoiceType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeFreightInvoice(@Nonnull FreightInvoiceType freightInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(freightInvoiceType, EUBL21DocumentType.FREIGHT_INVOICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType) {
        return UBL21Writer.writeFulfilmentCancellation(fulfilmentCancellationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)fulfilmentCancellationType, EUBL21DocumentType.FULFILMENT_CANCELATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType, @Nonnull File file) {
        return UBL21Writer.writeFulfilmentCancellation(fulfilmentCancellationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeFulfilmentCancellation(fulfilmentCancellationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType, @Nonnull Result result) {
        return UBL21Writer.writeFulfilmentCancellation(fulfilmentCancellationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeFulfilmentCancellation(@Nonnull FulfilmentCancellationType fulfilmentCancellationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(fulfilmentCancellationType, EUBL21DocumentType.FULFILMENT_CANCELATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType) {
        return UBL21Writer.writeGoodsItemItinerary(goodsItemItineraryType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)goodsItemItineraryType, EUBL21DocumentType.GOODS_ITEM_ITINERARY, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType, @Nonnull File file) {
        return UBL21Writer.writeGoodsItemItinerary(goodsItemItineraryType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeGoodsItemItinerary(goodsItemItineraryType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType, @Nonnull Result result) {
        return UBL21Writer.writeGoodsItemItinerary(goodsItemItineraryType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeGoodsItemItinerary(@Nonnull GoodsItemItineraryType goodsItemItineraryType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(goodsItemItineraryType, EUBL21DocumentType.GOODS_ITEM_ITINERARY, validationEventHandler, result);
    }

    @Nullable
    public static Document writeGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType) {
        return UBL21Writer.writeGuaranteeCertificate(guaranteeCertificateType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)guaranteeCertificateType, EUBL21DocumentType.GUARANTEE_CERTIFICATE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType, @Nonnull File file) {
        return UBL21Writer.writeGuaranteeCertificate(guaranteeCertificateType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeGuaranteeCertificate(guaranteeCertificateType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType, @Nonnull Result result) {
        return UBL21Writer.writeGuaranteeCertificate(guaranteeCertificateType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeGuaranteeCertificate(@Nonnull GuaranteeCertificateType guaranteeCertificateType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(guaranteeCertificateType, EUBL21DocumentType.GUARANTEE_CERTIFICATE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType) {
        return UBL21Writer.writeInstructionForReturns(instructionForReturnsType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)instructionForReturnsType, EUBL21DocumentType.INSTRUCTION_FOR_RETURNS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType, @Nonnull File file) {
        return UBL21Writer.writeInstructionForReturns(instructionForReturnsType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeInstructionForReturns(instructionForReturnsType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType, @Nonnull Result result) {
        return UBL21Writer.writeInstructionForReturns(instructionForReturnsType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeInstructionForReturns(@Nonnull InstructionForReturnsType instructionForReturnsType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(instructionForReturnsType, EUBL21DocumentType.INSTRUCTION_FOR_RETURNS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeInventoryReport(@Nonnull InventoryReportType inventoryReportType) {
        return UBL21Writer.writeInventoryReport(inventoryReportType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeInventoryReport(@Nonnull InventoryReportType inventoryReportType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)inventoryReportType, EUBL21DocumentType.INVENTORY_REPORT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeInventoryReport(@Nonnull InventoryReportType inventoryReportType, @Nonnull File file) {
        return UBL21Writer.writeInventoryReport(inventoryReportType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInventoryReport(@Nonnull InventoryReportType inventoryReportType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeInventoryReport(inventoryReportType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInventoryReport(@Nonnull InventoryReportType inventoryReportType, @Nonnull Result result) {
        return UBL21Writer.writeInventoryReport(inventoryReportType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeInventoryReport(@Nonnull InventoryReportType inventoryReportType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(inventoryReportType, EUBL21DocumentType.INVENTORY_REPORT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeInvoice(@Nonnull InvoiceType invoiceType) {
        return UBL21Writer.writeInvoice(invoiceType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeInvoice(@Nonnull InvoiceType invoiceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)invoiceType, EUBL21DocumentType.INVOICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nonnull File file) {
        return UBL21Writer.writeInvoice(invoiceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeInvoice(invoiceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nonnull Result result) {
        return UBL21Writer.writeInvoice(invoiceType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeInvoice(@Nonnull InvoiceType invoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(invoiceType, EUBL21DocumentType.INVOICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType) {
        return UBL21Writer.writeItemInformationRequest(itemInformationRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)itemInformationRequestType, EUBL21DocumentType.ITEM_INFORMATION_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType, @Nonnull File file) {
        return UBL21Writer.writeItemInformationRequest(itemInformationRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeItemInformationRequest(itemInformationRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType, @Nonnull Result result) {
        return UBL21Writer.writeItemInformationRequest(itemInformationRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeItemInformationRequest(@Nonnull ItemInformationRequestType itemInformationRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(itemInformationRequestType, EUBL21DocumentType.ITEM_INFORMATION_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrder(@Nonnull OrderType orderType) {
        return UBL21Writer.writeOrder(orderType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrder(@Nonnull OrderType orderType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)orderType, EUBL21DocumentType.ORDER, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nonnull File file) {
        return UBL21Writer.writeOrder(orderType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeOrder(orderType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nonnull Result result) {
        return UBL21Writer.writeOrder(orderType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrder(@Nonnull OrderType orderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(orderType, EUBL21DocumentType.ORDER, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType) {
        return UBL21Writer.writeOrderCancellation(orderCancellationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)orderCancellationType, EUBL21DocumentType.ORDER_CANCELLATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nonnull File file) {
        return UBL21Writer.writeOrderCancellation(orderCancellationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeOrderCancellation(orderCancellationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nonnull Result result) {
        return UBL21Writer.writeOrderCancellation(orderCancellationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderCancellation(@Nonnull OrderCancellationType orderCancellationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(orderCancellationType, EUBL21DocumentType.ORDER_CANCELLATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderChange(@Nonnull OrderChangeType orderChangeType) {
        return UBL21Writer.writeOrderChange(orderChangeType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)orderChangeType, EUBL21DocumentType.ORDER_CHANGE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nonnull File file) {
        return UBL21Writer.writeOrderChange(orderChangeType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeOrderChange(orderChangeType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nonnull Result result) {
        return UBL21Writer.writeOrderChange(orderChangeType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderChange(@Nonnull OrderChangeType orderChangeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(orderChangeType, EUBL21DocumentType.ORDER_CHANGE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderResponse(@Nonnull OrderResponseType orderResponseType) {
        return UBL21Writer.writeOrderResponse(orderResponseType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)orderResponseType, EUBL21DocumentType.ORDER_RESPONSE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nonnull File file) {
        return UBL21Writer.writeOrderResponse(orderResponseType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeOrderResponse(orderResponseType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nonnull Result result) {
        return UBL21Writer.writeOrderResponse(orderResponseType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderResponse(@Nonnull OrderResponseType orderResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(orderResponseType, EUBL21DocumentType.ORDER_RESPONSE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType) {
        return UBL21Writer.writeOrderResponseSimple(orderResponseSimpleType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)orderResponseSimpleType, EUBL21DocumentType.ORDER_RESPONSE_SIMPLE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nonnull File file) {
        return UBL21Writer.writeOrderResponseSimple(orderResponseSimpleType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeOrderResponseSimple(orderResponseSimpleType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nonnull Result result) {
        return UBL21Writer.writeOrderResponseSimple(orderResponseSimpleType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeOrderResponseSimple(@Nonnull OrderResponseSimpleType orderResponseSimpleType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(orderResponseSimpleType, EUBL21DocumentType.ORDER_RESPONSE_SIMPLE, validationEventHandler, result);
    }

    @Nullable
    public static Document writePackingList(@Nonnull PackingListType packingListType) {
        return UBL21Writer.writePackingList(packingListType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writePackingList(@Nonnull PackingListType packingListType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)packingListType, EUBL21DocumentType.PACKING_LIST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nonnull File file) {
        return UBL21Writer.writePackingList(packingListType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writePackingList(packingListType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nonnull Result result) {
        return UBL21Writer.writePackingList(packingListType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writePackingList(@Nonnull PackingListType packingListType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(packingListType, EUBL21DocumentType.PACKING_LIST, validationEventHandler, result);
    }

    @Nullable
    public static Document writePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType) {
        return UBL21Writer.writePriorInformationNotice(priorInformationNoticeType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)priorInformationNoticeType, EUBL21DocumentType.PRIOR_INFORMATION_NOTICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType, @Nonnull File file) {
        return UBL21Writer.writePriorInformationNotice(priorInformationNoticeType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writePriorInformationNotice(priorInformationNoticeType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType, @Nonnull Result result) {
        return UBL21Writer.writePriorInformationNotice(priorInformationNoticeType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writePriorInformationNotice(@Nonnull PriorInformationNoticeType priorInformationNoticeType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(priorInformationNoticeType, EUBL21DocumentType.PRIOR_INFORMATION_NOTICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeProductActivity(@Nonnull ProductActivityType productActivityType) {
        return UBL21Writer.writeProductActivity(productActivityType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeProductActivity(@Nonnull ProductActivityType productActivityType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)productActivityType, EUBL21DocumentType.PRODUCT_ACTIVITY, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeProductActivity(@Nonnull ProductActivityType productActivityType, @Nonnull File file) {
        return UBL21Writer.writeProductActivity(productActivityType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeProductActivity(@Nonnull ProductActivityType productActivityType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeProductActivity(productActivityType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeProductActivity(@Nonnull ProductActivityType productActivityType, @Nonnull Result result) {
        return UBL21Writer.writeProductActivity(productActivityType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeProductActivity(@Nonnull ProductActivityType productActivityType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(productActivityType, EUBL21DocumentType.PRODUCT_ACTIVITY, validationEventHandler, result);
    }

    @Nullable
    public static Document writeQuotation(@Nonnull QuotationType quotationType) {
        return UBL21Writer.writeQuotation(quotationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeQuotation(@Nonnull QuotationType quotationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)quotationType, EUBL21DocumentType.QUOTATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nonnull File file) {
        return UBL21Writer.writeQuotation(quotationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeQuotation(quotationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nonnull Result result) {
        return UBL21Writer.writeQuotation(quotationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeQuotation(@Nonnull QuotationType quotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(quotationType, EUBL21DocumentType.QUOTATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType) {
        return UBL21Writer.writeReceiptAdvice(receiptAdviceType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)receiptAdviceType, EUBL21DocumentType.RECEIPT_ADVICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nonnull File file) {
        return UBL21Writer.writeReceiptAdvice(receiptAdviceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeReceiptAdvice(receiptAdviceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nonnull Result result) {
        return UBL21Writer.writeReceiptAdvice(receiptAdviceType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeReceiptAdvice(@Nonnull ReceiptAdviceType receiptAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(receiptAdviceType, EUBL21DocumentType.RECEIPT_ADVICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeReminder(@Nonnull ReminderType reminderType) {
        return UBL21Writer.writeReminder(reminderType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeReminder(@Nonnull ReminderType reminderType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)reminderType, EUBL21DocumentType.REMINDER, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nonnull File file) {
        return UBL21Writer.writeReminder(reminderType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeReminder(reminderType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nonnull Result result) {
        return UBL21Writer.writeReminder(reminderType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeReminder(@Nonnull ReminderType reminderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(reminderType, EUBL21DocumentType.REMINDER, validationEventHandler, result);
    }

    @Nullable
    public static Document writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType) {
        return UBL21Writer.writeRemittanceAdvice(remittanceAdviceType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)remittanceAdviceType, EUBL21DocumentType.REMITTANCE_ADVICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nonnull File file) {
        return UBL21Writer.writeRemittanceAdvice(remittanceAdviceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeRemittanceAdvice(remittanceAdviceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nonnull Result result) {
        return UBL21Writer.writeRemittanceAdvice(remittanceAdviceType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeRemittanceAdvice(@Nonnull RemittanceAdviceType remittanceAdviceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(remittanceAdviceType, EUBL21DocumentType.REMITTANCE_ADVICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType) {
        return UBL21Writer.writeRequestForQuotation(requestForQuotationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)requestForQuotationType, EUBL21DocumentType.REQUEST_FOR_QUOTATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nonnull File file) {
        return UBL21Writer.writeRequestForQuotation(requestForQuotationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeRequestForQuotation(requestForQuotationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nonnull Result result) {
        return UBL21Writer.writeRequestForQuotation(requestForQuotationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeRequestForQuotation(@Nonnull RequestForQuotationType requestForQuotationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(requestForQuotationType, EUBL21DocumentType.REQUEST_FOR_QUOTATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeRetailEvent(@Nonnull RetailEventType retailEventType) {
        return UBL21Writer.writeRetailEvent(retailEventType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeRetailEvent(@Nonnull RetailEventType retailEventType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)retailEventType, EUBL21DocumentType.RETAIL_EVENT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeRetailEvent(@Nonnull RetailEventType retailEventType, @Nonnull File file) {
        return UBL21Writer.writeRetailEvent(retailEventType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRetailEvent(@Nonnull RetailEventType retailEventType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeRetailEvent(retailEventType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeRetailEvent(@Nonnull RetailEventType retailEventType, @Nonnull Result result) {
        return UBL21Writer.writeRetailEvent(retailEventType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeRetailEvent(@Nonnull RetailEventType retailEventType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(retailEventType, EUBL21DocumentType.RETAIL_EVENT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType) {
        return UBL21Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)selfBilledCreditNoteType, EUBL21DocumentType.SELF_BILLED_CREDIT_NOTE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nonnull File file) {
        return UBL21Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nonnull Result result) {
        return UBL21Writer.writeSelfBilledCreditNote(selfBilledCreditNoteType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeSelfBilledCreditNote(@Nonnull SelfBilledCreditNoteType selfBilledCreditNoteType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(selfBilledCreditNoteType, EUBL21DocumentType.SELF_BILLED_CREDIT_NOTE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType) {
        return UBL21Writer.writeSelfBilledInvoice(selfBilledInvoiceType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)selfBilledInvoiceType, EUBL21DocumentType.SELF_BILLED_INVOICE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nonnull File file) {
        return UBL21Writer.writeSelfBilledInvoice(selfBilledInvoiceType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeSelfBilledInvoice(selfBilledInvoiceType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nonnull Result result) {
        return UBL21Writer.writeSelfBilledInvoice(selfBilledInvoiceType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeSelfBilledInvoice(@Nonnull SelfBilledInvoiceType selfBilledInvoiceType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(selfBilledInvoiceType, EUBL21DocumentType.SELF_BILLED_INVOICE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeStatement(@Nonnull StatementType statementType) {
        return UBL21Writer.writeStatement(statementType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeStatement(@Nonnull StatementType statementType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)statementType, EUBL21DocumentType.STATEMENT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nonnull File file) {
        return UBL21Writer.writeStatement(statementType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeStatement(statementType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nonnull Result result) {
        return UBL21Writer.writeStatement(statementType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeStatement(@Nonnull StatementType statementType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(statementType, EUBL21DocumentType.STATEMENT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType) {
        return UBL21Writer.writeStockAvailabilityReport(stockAvailabilityReportType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)stockAvailabilityReportType, EUBL21DocumentType.STOCK_AVAILABILITY_REPORT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType, @Nonnull File file) {
        return UBL21Writer.writeStockAvailabilityReport(stockAvailabilityReportType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeStockAvailabilityReport(stockAvailabilityReportType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType, @Nonnull Result result) {
        return UBL21Writer.writeStockAvailabilityReport(stockAvailabilityReportType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeStockAvailabilityReport(@Nonnull StockAvailabilityReportType stockAvailabilityReportType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(stockAvailabilityReportType, EUBL21DocumentType.STOCK_AVAILABILITY_REPORT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTender(@Nonnull TenderType tenderType) {
        return UBL21Writer.writeTender(tenderType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTender(@Nonnull TenderType tenderType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)tenderType, EUBL21DocumentType.TENDER, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTender(@Nonnull TenderType tenderType, @Nonnull File file) {
        return UBL21Writer.writeTender(tenderType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTender(@Nonnull TenderType tenderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTender(tenderType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTender(@Nonnull TenderType tenderType, @Nonnull Result result) {
        return UBL21Writer.writeTender(tenderType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTender(@Nonnull TenderType tenderType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(tenderType, EUBL21DocumentType.TENDER, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTendererQualification(@Nonnull TendererQualificationType tendererQualificationType) {
        return UBL21Writer.writeTendererQualification(tendererQualificationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTendererQualification(@Nonnull TendererQualificationType tendererQualificationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)tendererQualificationType, EUBL21DocumentType.TENDER_QUALIFICATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTendererQualification(@Nonnull TendererQualificationType tendererQualificationType, @Nonnull File file) {
        return UBL21Writer.writeTendererQualification(tendererQualificationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTendererQualification(@Nonnull TendererQualificationType tendererQualificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTendererQualification(tendererQualificationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTendererQualification(@Nonnull TendererQualificationType tendererQualificationType, @Nonnull Result result) {
        return UBL21Writer.writeTendererQualification(tendererQualificationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTendererQualification(@Nonnull TendererQualificationType tendererQualificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(tendererQualificationType, EUBL21DocumentType.TENDER_QUALIFICATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType) {
        return UBL21Writer.writeTendererQualificationResponse(tendererQualificationResponseType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)tendererQualificationResponseType, EUBL21DocumentType.TENDER_QUALIFICATION_RESPONSE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType, @Nonnull File file) {
        return UBL21Writer.writeTendererQualificationResponse(tendererQualificationResponseType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTendererQualificationResponse(tendererQualificationResponseType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType, @Nonnull Result result) {
        return UBL21Writer.writeTendererQualificationResponse(tendererQualificationResponseType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTendererQualificationResponse(@Nonnull TendererQualificationResponseType tendererQualificationResponseType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(tendererQualificationResponseType, EUBL21DocumentType.TENDER_QUALIFICATION_RESPONSE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType) {
        return UBL21Writer.writeTenderReceipt(tenderReceiptType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)tenderReceiptType, EUBL21DocumentType.TENDER_RECEIPT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType, @Nonnull File file) {
        return UBL21Writer.writeTenderReceipt(tenderReceiptType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTenderReceipt(tenderReceiptType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType, @Nonnull Result result) {
        return UBL21Writer.writeTenderReceipt(tenderReceiptType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTenderReceipt(@Nonnull TenderReceiptType tenderReceiptType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(tenderReceiptType, EUBL21DocumentType.TENDER_RECEIPT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType) {
        return UBL21Writer.writeTradeItemLocationProfile(tradeItemLocationProfileType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)tradeItemLocationProfileType, EUBL21DocumentType.TRADE_ITEM_LOCATION_PROFILE, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType, @Nonnull File file) {
        return UBL21Writer.writeTradeItemLocationProfile(tradeItemLocationProfileType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTradeItemLocationProfile(tradeItemLocationProfileType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType, @Nonnull Result result) {
        return UBL21Writer.writeTradeItemLocationProfile(tradeItemLocationProfileType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTradeItemLocationProfile(@Nonnull TradeItemLocationProfileType tradeItemLocationProfileType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(tradeItemLocationProfileType, EUBL21DocumentType.TRADE_ITEM_LOCATION_PROFILE, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType) {
        return UBL21Writer.writeTransportationStatus(transportationStatusType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportationStatusType, EUBL21DocumentType.TRANSPORTATION_STATUS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nonnull File file) {
        return UBL21Writer.writeTransportationStatus(transportationStatusType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportationStatus(transportationStatusType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nonnull Result result) {
        return UBL21Writer.writeTransportationStatus(transportationStatusType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportationStatus(@Nonnull TransportationStatusType transportationStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportationStatusType, EUBL21DocumentType.TRANSPORTATION_STATUS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType) {
        return UBL21Writer.writeTransportationStatusRequest(transportationStatusRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportationStatusRequestType, EUBL21DocumentType.TRANSPORTATION_STATUS_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType, @Nonnull File file) {
        return UBL21Writer.writeTransportationStatusRequest(transportationStatusRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportationStatusRequest(transportationStatusRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType, @Nonnull Result result) {
        return UBL21Writer.writeTransportationStatusRequest(transportationStatusRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportationStatusRequest(@Nonnull TransportationStatusRequestType transportationStatusRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportationStatusRequestType, EUBL21DocumentType.TRANSPORTATION_STATUS_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType) {
        return UBL21Writer.writeTransportExecutionPlan(transportExecutionPlanType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportExecutionPlanType, EUBL21DocumentType.TRANSPORT_EXECUTION_PLAN, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType, @Nonnull File file) {
        return UBL21Writer.writeTransportExecutionPlan(transportExecutionPlanType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportExecutionPlan(transportExecutionPlanType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType, @Nonnull Result result) {
        return UBL21Writer.writeTransportExecutionPlan(transportExecutionPlanType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlan(@Nonnull TransportExecutionPlanType transportExecutionPlanType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportExecutionPlanType, EUBL21DocumentType.TRANSPORT_EXECUTION_PLAN, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType) {
        return UBL21Writer.writeTransportExecutionPlanRequest(transportExecutionPlanRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportExecutionPlanRequestType, EUBL21DocumentType.TRANSPORT_EXECUTION_PLAN_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType, @Nonnull File file) {
        return UBL21Writer.writeTransportExecutionPlanRequest(transportExecutionPlanRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportExecutionPlanRequest(transportExecutionPlanRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType, @Nonnull Result result) {
        return UBL21Writer.writeTransportExecutionPlanRequest(transportExecutionPlanRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportExecutionPlanRequest(@Nonnull TransportExecutionPlanRequestType transportExecutionPlanRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportExecutionPlanRequestType, EUBL21DocumentType.TRANSPORT_EXECUTION_PLAN_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType) {
        return UBL21Writer.writeTransportProgressStatus(transportProgressStatusType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportProgressStatusType, EUBL21DocumentType.TRANSPORT_PROGRESS_STATUS, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType, @Nonnull File file) {
        return UBL21Writer.writeTransportProgressStatus(transportProgressStatusType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportProgressStatus(transportProgressStatusType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType, @Nonnull Result result) {
        return UBL21Writer.writeTransportProgressStatus(transportProgressStatusType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatus(@Nonnull TransportProgressStatusType transportProgressStatusType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportProgressStatusType, EUBL21DocumentType.TRANSPORT_PROGRESS_STATUS, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType) {
        return UBL21Writer.writeTransportProgressStatusRequest(transportProgressStatusRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportProgressStatusRequestType, EUBL21DocumentType.TRANSPORT_PROGRESS_STATUS_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType, @Nonnull File file) {
        return UBL21Writer.writeTransportProgressStatusRequest(transportProgressStatusRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportProgressStatusRequest(transportProgressStatusRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType, @Nonnull Result result) {
        return UBL21Writer.writeTransportProgressStatusRequest(transportProgressStatusRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportProgressStatusRequest(@Nonnull TransportProgressStatusRequestType transportProgressStatusRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportProgressStatusRequestType, EUBL21DocumentType.TRANSPORT_PROGRESS_STATUS_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType) {
        return UBL21Writer.writeTransportServiceDescription(transportServiceDescriptionType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportServiceDescriptionType, EUBL21DocumentType.TRANSPORT_SERVICE_DESCRIPTION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType, @Nonnull File file) {
        return UBL21Writer.writeTransportServiceDescription(transportServiceDescriptionType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportServiceDescription(transportServiceDescriptionType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType, @Nonnull Result result) {
        return UBL21Writer.writeTransportServiceDescription(transportServiceDescriptionType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescription(@Nonnull TransportServiceDescriptionType transportServiceDescriptionType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportServiceDescriptionType, EUBL21DocumentType.TRANSPORT_SERVICE_DESCRIPTION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType) {
        return UBL21Writer.writeTransportServiceDescriptionRequest(transportServiceDescriptionRequestType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)transportServiceDescriptionRequestType, EUBL21DocumentType.TRANSPORT_SERVICE_DESCRIPTION_REQUEST, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType, @Nonnull File file) {
        return UBL21Writer.writeTransportServiceDescriptionRequest(transportServiceDescriptionRequestType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeTransportServiceDescriptionRequest(transportServiceDescriptionRequestType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType, @Nonnull Result result) {
        return UBL21Writer.writeTransportServiceDescriptionRequest(transportServiceDescriptionRequestType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeTransportServiceDescriptionRequest(@Nonnull TransportServiceDescriptionRequestType transportServiceDescriptionRequestType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(transportServiceDescriptionRequestType, EUBL21DocumentType.TRANSPORT_SERVICE_DESCRIPTION_REQUEST, validationEventHandler, result);
    }

    @Nullable
    public static Document writeUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType) {
        return UBL21Writer.writeUnawardedNotification(unawardedNotificationType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)unawardedNotificationType, EUBL21DocumentType.UNAWARDED_NOTIFICATION, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType, @Nonnull File file) {
        return UBL21Writer.writeUnawardedNotification(unawardedNotificationType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeUnawardedNotification(unawardedNotificationType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType, @Nonnull Result result) {
        return UBL21Writer.writeUnawardedNotification(unawardedNotificationType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeUnawardedNotification(@Nonnull UnawardedNotificationType unawardedNotificationType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(unawardedNotificationType, EUBL21DocumentType.UNAWARDED_NOTIFICATION, validationEventHandler, result);
    }

    @Nullable
    public static Document writeUtilityStatement(@Nonnull UtilityStatementType utilityStatementType) {
        return UBL21Writer.writeUtilityStatement(utilityStatementType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeUtilityStatement(@Nonnull UtilityStatementType utilityStatementType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)utilityStatementType, EUBL21DocumentType.UTILITY_STATEMENT, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeUtilityStatement(@Nonnull UtilityStatementType utilityStatementType, @Nonnull File file) {
        return UBL21Writer.writeUtilityStatement(utilityStatementType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeUtilityStatement(@Nonnull UtilityStatementType utilityStatementType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeUtilityStatement(utilityStatementType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeUtilityStatement(@Nonnull UtilityStatementType utilityStatementType, @Nonnull Result result) {
        return UBL21Writer.writeUtilityStatement(utilityStatementType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeUtilityStatement(@Nonnull UtilityStatementType utilityStatementType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(utilityStatementType, EUBL21DocumentType.UTILITY_STATEMENT, validationEventHandler, result);
    }

    @Nullable
    public static Document writeWaybill(@Nonnull WaybillType waybillType) {
        return UBL21Writer.writeWaybill(waybillType, UBL21Writer.getGlobalValidationEventHandler());
    }

    @Nullable
    public static Document writeWaybill(@Nonnull WaybillType waybillType, @Nullable ValidationEventHandler validationEventHandler) {
        return UBL21Marshaller.writeUBLDocument((Object)waybillType, EUBL21DocumentType.WAYBILL, validationEventHandler);
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nonnull File file) {
        return UBL21Writer.writeWaybill(waybillType, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull File file) {
        return UBL21Writer.writeWaybill(waybillType, validationEventHandler, new StreamResult(file));
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nonnull Result result) {
        return UBL21Writer.writeWaybill(waybillType, UBL21Writer.getGlobalValidationEventHandler(), result);
    }

    @Nonnull
    public static ESuccess writeWaybill(@Nonnull WaybillType waybillType, @Nullable ValidationEventHandler validationEventHandler, @Nonnull Result result) {
        return UBL21Marshaller.writeUBLDocument(waybillType, EUBL21DocumentType.WAYBILL, validationEventHandler, result);
    }
}

