/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl20;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.ubl20.EUBL20DocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBL20DocumentTypes {
    private static final ICommonsMap<String, EUBL20DocumentType> s_aNamespace2DocType = new CommonsHashMap();
    private static final ICommonsMap<String, EUBL20DocumentType> s_aLocalName2DocType = new CommonsHashMap();
    private static final UBL20DocumentTypes s_aInstance;

    private UBL20DocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllNamespaces() {
        return s_aNamespace2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL20DocumentType getDocumentTypeOfNamespace(@Nullable String string) {
        return (EUBL20DocumentType)((Object)s_aNamespace2DocType.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfNamespace(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfNamespace(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getSchema();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return s_aLocalName2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL20DocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EUBL20DocumentType)((Object)s_aLocalName2DocType.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getImplementationClass();
    }

    @Nullable
    public static EUBL20DocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return (EUBL20DocumentType)((Object)ArrayHelper.findFirst((Object[])EUBL20DocumentType.values(), eUBL20DocumentType -> eUBL20DocumentType.getImplementationClass().equals(clazz)));
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EUBL20DocumentType eUBL20DocumentType = UBL20DocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eUBL20DocumentType == null ? null : eUBL20DocumentType.getSchema();
    }

    static {
        for (EUBL20DocumentType eUBL20DocumentType : EUBL20DocumentType.values()) {
            String string = eUBL20DocumentType.getNamespaceURI();
            if (s_aNamespace2DocType.containsKey((Object)string)) {
                throw new IllegalArgumentException("The namespace '" + string + "' is already mapped!");
            }
            s_aNamespace2DocType.put((Object)string, (Object)eUBL20DocumentType);
            String string2 = eUBL20DocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey((Object)string2)) {
                throw new IllegalArgumentException("The local name '" + string2 + "' is already mapped!");
            }
            s_aLocalName2DocType.put((Object)string2, (Object)eUBL20DocumentType);
        }
        s_aInstance = new UBL20DocumentTypes();
    }
}

