/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl20.helper;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.LineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.SignatureType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.NoteType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;

@Immutable
public final class UBL20CreditNoteHelper {
    private UBL20CreditNoteHelper() {
    }

    @Nonnull
    public static InvoicedQuantityType cloneToInvoicedQuantity(@Nonnull CreditedQuantityType creditedQuantityType) {
        InvoicedQuantityType invoicedQuantityType = new InvoicedQuantityType();
        creditedQuantityType.cloneTo(invoicedQuantityType);
        return invoicedQuantityType;
    }

    public static void cloneToInvoiceLine(@Nonnull CreditNoteLineType creditNoteLineType, @Nonnull InvoiceLineType invoiceLineType) {
        invoiceLineType.setAccountingCost(creditNoteLineType.getAccountingCost() == null ? null : creditNoteLineType.getAccountingCost().clone());
        invoiceLineType.setAccountingCostCode(creditNoteLineType.getAccountingCostCode() == null ? null : creditNoteLineType.getAccountingCostCode().clone());
        ArrayList<BillingReferenceType> arrayList = new ArrayList<BillingReferenceType>();
        for (BillingReferenceType iExplicitlyCloneable : creditNoteLineType.getBillingReference()) {
            arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
        }
        invoiceLineType.setBillingReference(arrayList);
        arrayList = new ArrayList();
        for (DeliveryType deliveryType : creditNoteLineType.getDelivery()) {
            arrayList.add((BillingReferenceType)((Object)(deliveryType == null ? null : deliveryType.clone())));
        }
        invoiceLineType.setDelivery(arrayList);
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : creditNoteLineType.getDespatchLineReference()) {
            arrayList.add((BillingReferenceType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        invoiceLineType.setDespatchLineReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteLineType.getDocumentReference()) {
            arrayList.add((BillingReferenceType)((Object)(documentReferenceType == null ? null : documentReferenceType.clone())));
        }
        invoiceLineType.setDocumentReference(arrayList);
        invoiceLineType.setID(creditNoteLineType.getID() == null ? null : creditNoteLineType.getID().clone());
        invoiceLineType.setInvoicedQuantity(creditNoteLineType.getCreditedQuantity() == null ? null : UBL20CreditNoteHelper.cloneToInvoicedQuantity(creditNoteLineType.getCreditedQuantity()));
        invoiceLineType.setItem(creditNoteLineType.getItem() == null ? null : creditNoteLineType.getItem().clone());
        invoiceLineType.setLineExtensionAmount(creditNoteLineType.getLineExtensionAmount() == null ? null : creditNoteLineType.getLineExtensionAmount().clone());
        invoiceLineType.setNote(creditNoteLineType.getNote() == null ? null : creditNoteLineType.getNote().clone());
        invoiceLineType.setPrice(creditNoteLineType.getPrice() == null ? null : creditNoteLineType.getPrice().clone());
        invoiceLineType.setPricingReference(creditNoteLineType.getPricingReference() == null ? null : creditNoteLineType.getPricingReference().clone());
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : creditNoteLineType.getReceiptLineReference()) {
            arrayList.add((BillingReferenceType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        invoiceLineType.setReceiptLineReference(arrayList);
        invoiceLineType.setTaxPointDate(creditNoteLineType.getTaxPointDate() == null ? null : creditNoteLineType.getTaxPointDate().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : creditNoteLineType.getTaxTotal()) {
            arrayList.add((BillingReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        invoiceLineType.setTaxTotal(arrayList);
        invoiceLineType.setUUID(creditNoteLineType.getUUID() == null ? null : creditNoteLineType.getUUID().clone());
    }

    public static void cloneCreditNoteToInvoice(@Nonnull CreditNoteType creditNoteType, @Nonnull InvoiceType invoiceType) {
        invoiceType.setAccountingCost(creditNoteType.getAccountingCost() == null ? null : creditNoteType.getAccountingCost().clone());
        invoiceType.setAccountingCostCode(creditNoteType.getAccountingCostCode() == null ? null : creditNoteType.getAccountingCostCode().clone());
        invoiceType.setAccountingCustomerParty(creditNoteType.getAccountingCustomerParty() == null ? null : creditNoteType.getAccountingCustomerParty().clone());
        invoiceType.setAccountingSupplierParty(creditNoteType.getAccountingSupplierParty() == null ? null : creditNoteType.getAccountingSupplierParty().clone());
        ArrayList<DocumentReferenceType> arrayList = new ArrayList<DocumentReferenceType>();
        for (DocumentReferenceType iExplicitlyCloneable : creditNoteType.getAdditionalDocumentReference()) {
            arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
        }
        invoiceType.setAdditionalDocumentReference(arrayList);
        arrayList = new ArrayList();
        for (AllowanceChargeType allowanceChargeType : creditNoteType.getAllowanceCharge()) {
            arrayList.add((DocumentReferenceType)((Object)(allowanceChargeType == null ? null : allowanceChargeType.clone())));
        }
        invoiceType.setAllowanceCharge(arrayList);
        arrayList = new ArrayList();
        for (BillingReferenceType billingReferenceType : creditNoteType.getBillingReference()) {
            arrayList.add((DocumentReferenceType)((Object)(billingReferenceType == null ? null : billingReferenceType.clone())));
        }
        invoiceType.setBillingReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getContractDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setContractDocumentReference(arrayList);
        invoiceType.setCopyIndicator(creditNoteType.getCopyIndicator() == null ? null : creditNoteType.getCopyIndicator().clone());
        invoiceType.setCustomizationID(creditNoteType.getCustomizationID() == null ? null : creditNoteType.getCustomizationID().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getDespatchDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setDespatchDocumentReference(arrayList);
        invoiceType.setDocumentCurrencyCode(creditNoteType.getDocumentCurrencyCode() == null ? null : creditNoteType.getDocumentCurrencyCode().clone());
        invoiceType.setID(creditNoteType.getID() == null ? null : creditNoteType.getID().clone());
        arrayList = new ArrayList();
        for (CreditNoteLineType creditNoteLineType : creditNoteType.getCreditNoteLine()) {
            if (creditNoteLineType == null) {
                arrayList.add(null);
                continue;
            }
            InvoiceLineType invoiceLineType = new InvoiceLineType();
            UBL20CreditNoteHelper.cloneToInvoiceLine(creditNoteLineType, invoiceLineType);
            arrayList.add((DocumentReferenceType)((Object)invoiceLineType));
        }
        invoiceType.setInvoiceLine(arrayList);
        arrayList = new ArrayList();
        for (PeriodType periodType : creditNoteType.getInvoicePeriod()) {
            arrayList.add((DocumentReferenceType)((Object)(periodType == null ? null : periodType.clone())));
        }
        invoiceType.setInvoicePeriod(arrayList);
        invoiceType.setIssueDate(creditNoteType.getIssueDate() == null ? null : creditNoteType.getIssueDate().clone());
        invoiceType.setIssueTime(creditNoteType.getIssueTime() == null ? null : creditNoteType.getIssueTime().clone());
        invoiceType.setLegalMonetaryTotal(creditNoteType.getLegalMonetaryTotal() == null ? null : creditNoteType.getLegalMonetaryTotal().clone());
        invoiceType.setLineCountNumeric(creditNoteType.getLineCountNumeric() == null ? null : creditNoteType.getLineCountNumeric().clone());
        arrayList = new ArrayList();
        for (NoteType noteType : creditNoteType.getNote()) {
            arrayList.add((DocumentReferenceType)((Object)(noteType == null ? null : noteType.clone())));
        }
        invoiceType.setNote(arrayList);
        invoiceType.setOrderReference(creditNoteType.getOrderReference() == null ? null : creditNoteType.getOrderReference().clone());
        invoiceType.setPayeeParty(creditNoteType.getPayeeParty() == null ? null : creditNoteType.getPayeeParty().clone());
        invoiceType.setPaymentAlternativeCurrencyCode(creditNoteType.getPaymentAlternativeCurrencyCode() == null ? null : creditNoteType.getPaymentAlternativeCurrencyCode().clone());
        invoiceType.setPaymentAlternativeExchangeRate(creditNoteType.getPaymentAlternativeExchangeRate() == null ? null : creditNoteType.getPaymentAlternativeExchangeRate().clone());
        invoiceType.setPaymentCurrencyCode(creditNoteType.getPaymentCurrencyCode() == null ? null : creditNoteType.getPaymentCurrencyCode().clone());
        invoiceType.setPaymentExchangeRate(creditNoteType.getPaymentExchangeRate() == null ? null : creditNoteType.getPaymentExchangeRate().clone());
        invoiceType.setPricingCurrencyCode(creditNoteType.getPricingCurrencyCode() == null ? null : creditNoteType.getPricingCurrencyCode().clone());
        invoiceType.setPricingExchangeRate(creditNoteType.getPricingExchangeRate() == null ? null : creditNoteType.getPricingExchangeRate().clone());
        invoiceType.setProfileID(creditNoteType.getProfileID() == null ? null : creditNoteType.getProfileID().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : creditNoteType.getReceiptDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        invoiceType.setReceiptDocumentReference(arrayList);
        arrayList = new ArrayList();
        for (SignatureType signatureType : creditNoteType.getSignature()) {
            arrayList.add((DocumentReferenceType)((Object)(signatureType == null ? null : signatureType.clone())));
        }
        invoiceType.setSignature(arrayList);
        invoiceType.setTaxCurrencyCode(creditNoteType.getTaxCurrencyCode() == null ? null : creditNoteType.getTaxCurrencyCode().clone());
        invoiceType.setTaxExchangeRate(creditNoteType.getTaxExchangeRate() == null ? null : creditNoteType.getTaxExchangeRate().clone());
        invoiceType.setTaxPointDate(creditNoteType.getTaxPointDate() == null ? null : creditNoteType.getTaxPointDate().clone());
        invoiceType.setTaxRepresentativeParty(creditNoteType.getTaxRepresentativeParty() == null ? null : creditNoteType.getTaxRepresentativeParty().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : creditNoteType.getTaxTotal()) {
            arrayList.add((DocumentReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        invoiceType.setTaxTotal(arrayList);
        invoiceType.setUBLExtensions(creditNoteType.getUBLExtensions() == null ? null : creditNoteType.getUBLExtensions().clone());
        invoiceType.setUBLVersionID(creditNoteType.getUBLVersionID() == null ? null : creditNoteType.getUBLVersionID().clone());
        invoiceType.setUUID(creditNoteType.getUUID() == null ? null : creditNoteType.getUUID().clone());
    }
}

