/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl20.helper;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.LineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.SignatureType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.NoteType;
import oasis.names.specification.ubl.schema.xsd.creditnote_2.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;

@Immutable
public final class UBL20InvoiceHelper {
    private UBL20InvoiceHelper() {
    }

    @Nonnull
    public static CreditedQuantityType cloneToCreditedQuantity(@Nonnull InvoicedQuantityType invoicedQuantityType) {
        CreditedQuantityType creditedQuantityType = new CreditedQuantityType();
        invoicedQuantityType.cloneTo(creditedQuantityType);
        return creditedQuantityType;
    }

    public static void cloneToCreditNoteLine(@Nonnull InvoiceLineType invoiceLineType, @Nonnull CreditNoteLineType creditNoteLineType) {
        creditNoteLineType.setAccountingCost(invoiceLineType.getAccountingCost() == null ? null : invoiceLineType.getAccountingCost().clone());
        creditNoteLineType.setAccountingCostCode(invoiceLineType.getAccountingCostCode() == null ? null : invoiceLineType.getAccountingCostCode().clone());
        ArrayList<BillingReferenceType> arrayList = new ArrayList<BillingReferenceType>();
        for (BillingReferenceType iExplicitlyCloneable : invoiceLineType.getBillingReference()) {
            arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
        }
        creditNoteLineType.setBillingReference(arrayList);
        arrayList = new ArrayList();
        for (DeliveryType deliveryType : invoiceLineType.getDelivery()) {
            arrayList.add((BillingReferenceType)((Object)(deliveryType == null ? null : deliveryType.clone())));
        }
        creditNoteLineType.setDelivery(arrayList);
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : invoiceLineType.getDespatchLineReference()) {
            arrayList.add((BillingReferenceType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        creditNoteLineType.setDespatchLineReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceLineType.getDocumentReference()) {
            arrayList.add((BillingReferenceType)((Object)(documentReferenceType == null ? null : documentReferenceType.clone())));
        }
        creditNoteLineType.setDocumentReference(arrayList);
        creditNoteLineType.setID(invoiceLineType.getID() == null ? null : invoiceLineType.getID().clone());
        creditNoteLineType.setCreditedQuantity(invoiceLineType.getInvoicedQuantity() == null ? null : UBL20InvoiceHelper.cloneToCreditedQuantity(invoiceLineType.getInvoicedQuantity()));
        creditNoteLineType.setItem(invoiceLineType.getItem() == null ? null : invoiceLineType.getItem().clone());
        creditNoteLineType.setLineExtensionAmount(invoiceLineType.getLineExtensionAmount() == null ? null : invoiceLineType.getLineExtensionAmount().clone());
        creditNoteLineType.setNote(invoiceLineType.getNote() == null ? null : invoiceLineType.getNote().clone());
        creditNoteLineType.setPrice(invoiceLineType.getPrice() == null ? null : invoiceLineType.getPrice().clone());
        creditNoteLineType.setPricingReference(invoiceLineType.getPricingReference() == null ? null : invoiceLineType.getPricingReference().clone());
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : invoiceLineType.getReceiptLineReference()) {
            arrayList.add((BillingReferenceType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        creditNoteLineType.setReceiptLineReference(arrayList);
        creditNoteLineType.setTaxPointDate(invoiceLineType.getTaxPointDate() == null ? null : invoiceLineType.getTaxPointDate().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : invoiceLineType.getTaxTotal()) {
            arrayList.add((BillingReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        creditNoteLineType.setTaxTotal(arrayList);
        creditNoteLineType.setUUID(invoiceLineType.getUUID() == null ? null : invoiceLineType.getUUID().clone());
    }

    public static void cloneInvoiceToCreditNote(@Nonnull InvoiceType invoiceType, @Nonnull CreditNoteType creditNoteType) {
        creditNoteType.setAccountingCost(invoiceType.getAccountingCost() == null ? null : invoiceType.getAccountingCost().clone());
        creditNoteType.setAccountingCostCode(invoiceType.getAccountingCostCode() == null ? null : invoiceType.getAccountingCostCode().clone());
        creditNoteType.setAccountingCustomerParty(invoiceType.getAccountingCustomerParty() == null ? null : invoiceType.getAccountingCustomerParty().clone());
        creditNoteType.setAccountingSupplierParty(invoiceType.getAccountingSupplierParty() == null ? null : invoiceType.getAccountingSupplierParty().clone());
        ArrayList<DocumentReferenceType> arrayList = new ArrayList<DocumentReferenceType>();
        for (DocumentReferenceType iExplicitlyCloneable : invoiceType.getAdditionalDocumentReference()) {
            arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
        }
        creditNoteType.setAdditionalDocumentReference(arrayList);
        arrayList = new ArrayList();
        for (AllowanceChargeType allowanceChargeType : invoiceType.getAllowanceCharge()) {
            arrayList.add((DocumentReferenceType)((Object)(allowanceChargeType == null ? null : allowanceChargeType.clone())));
        }
        creditNoteType.setAllowanceCharge(arrayList);
        arrayList = new ArrayList();
        for (BillingReferenceType billingReferenceType : invoiceType.getBillingReference()) {
            arrayList.add((DocumentReferenceType)((Object)(billingReferenceType == null ? null : billingReferenceType.clone())));
        }
        creditNoteType.setBillingReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getContractDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setContractDocumentReference(arrayList);
        creditNoteType.setCopyIndicator(invoiceType.getCopyIndicator() == null ? null : invoiceType.getCopyIndicator().clone());
        creditNoteType.setCustomizationID(invoiceType.getCustomizationID() == null ? null : invoiceType.getCustomizationID().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getDespatchDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setDespatchDocumentReference(arrayList);
        creditNoteType.setDocumentCurrencyCode(invoiceType.getDocumentCurrencyCode() == null ? null : invoiceType.getDocumentCurrencyCode().clone());
        creditNoteType.setID(invoiceType.getID() == null ? null : invoiceType.getID().clone());
        arrayList = new ArrayList();
        for (InvoiceLineType invoiceLineType : invoiceType.getInvoiceLine()) {
            if (invoiceLineType == null) {
                arrayList.add(null);
                continue;
            }
            CreditNoteLineType creditNoteLineType = new CreditNoteLineType();
            UBL20InvoiceHelper.cloneToCreditNoteLine(invoiceLineType, creditNoteLineType);
            arrayList.add((DocumentReferenceType)((Object)creditNoteLineType));
        }
        creditNoteType.setCreditNoteLine(arrayList);
        arrayList = new ArrayList();
        for (PeriodType periodType : invoiceType.getInvoicePeriod()) {
            arrayList.add((DocumentReferenceType)((Object)(periodType == null ? null : periodType.clone())));
        }
        creditNoteType.setInvoicePeriod(arrayList);
        creditNoteType.setIssueDate(invoiceType.getIssueDate() == null ? null : invoiceType.getIssueDate().clone());
        creditNoteType.setIssueTime(invoiceType.getIssueTime() == null ? null : invoiceType.getIssueTime().clone());
        creditNoteType.setLegalMonetaryTotal(invoiceType.getLegalMonetaryTotal() == null ? null : invoiceType.getLegalMonetaryTotal().clone());
        creditNoteType.setLineCountNumeric(invoiceType.getLineCountNumeric() == null ? null : invoiceType.getLineCountNumeric().clone());
        arrayList = new ArrayList();
        for (NoteType noteType : invoiceType.getNote()) {
            arrayList.add((DocumentReferenceType)((Object)(noteType == null ? null : noteType.clone())));
        }
        creditNoteType.setNote(arrayList);
        creditNoteType.setOrderReference(invoiceType.getOrderReference() == null ? null : invoiceType.getOrderReference().clone());
        creditNoteType.setPayeeParty(invoiceType.getPayeeParty() == null ? null : invoiceType.getPayeeParty().clone());
        creditNoteType.setPaymentAlternativeCurrencyCode(invoiceType.getPaymentAlternativeCurrencyCode() == null ? null : invoiceType.getPaymentAlternativeCurrencyCode().clone());
        creditNoteType.setPaymentAlternativeExchangeRate(invoiceType.getPaymentAlternativeExchangeRate() == null ? null : invoiceType.getPaymentAlternativeExchangeRate().clone());
        creditNoteType.setPaymentCurrencyCode(invoiceType.getPaymentCurrencyCode() == null ? null : invoiceType.getPaymentCurrencyCode().clone());
        creditNoteType.setPaymentExchangeRate(invoiceType.getPaymentExchangeRate() == null ? null : invoiceType.getPaymentExchangeRate().clone());
        creditNoteType.setPricingCurrencyCode(invoiceType.getPricingCurrencyCode() == null ? null : invoiceType.getPricingCurrencyCode().clone());
        creditNoteType.setPricingExchangeRate(invoiceType.getPricingExchangeRate() == null ? null : invoiceType.getPricingExchangeRate().clone());
        creditNoteType.setProfileID(invoiceType.getProfileID() == null ? null : invoiceType.getProfileID().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getReceiptDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setReceiptDocumentReference(arrayList);
        arrayList = new ArrayList();
        for (SignatureType signatureType : invoiceType.getSignature()) {
            arrayList.add((DocumentReferenceType)((Object)(signatureType == null ? null : signatureType.clone())));
        }
        creditNoteType.setSignature(arrayList);
        creditNoteType.setTaxCurrencyCode(invoiceType.getTaxCurrencyCode() == null ? null : invoiceType.getTaxCurrencyCode().clone());
        creditNoteType.setTaxExchangeRate(invoiceType.getTaxExchangeRate() == null ? null : invoiceType.getTaxExchangeRate().clone());
        creditNoteType.setTaxPointDate(invoiceType.getTaxPointDate() == null ? null : invoiceType.getTaxPointDate().clone());
        creditNoteType.setTaxRepresentativeParty(invoiceType.getTaxRepresentativeParty() == null ? null : invoiceType.getTaxRepresentativeParty().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : invoiceType.getTaxTotal()) {
            arrayList.add((DocumentReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        creditNoteType.setTaxTotal(arrayList);
        creditNoteType.setUBLExtensions(invoiceType.getUBLExtensions() == null ? null : invoiceType.getUBLExtensions().clone());
        creditNoteType.setUBLVersionID(invoiceType.getUBLVersionID() == null ? null : invoiceType.getUBLVersionID().clone());
        creditNoteType.setUUID(invoiceType.getUUID() == null ? null : invoiceType.getUUID().clone());
    }
}

