/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl22.helper;

import com.helger.commons.collection.impl.CommonsArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DeliveryTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.LineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.ProjectReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.SignatureType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.CreditNoteTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NoteType;
import oasis.names.specification.ubl.schema.xsd.creditnote_22.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_22.InvoiceType;

@Immutable
public final class UBL22InvoiceHelper {
    private UBL22InvoiceHelper() {
    }

    @Nonnull
    public static CreditedQuantityType cloneToCreditedQuantity(@Nonnull InvoicedQuantityType invoicedQuantityType) {
        CreditedQuantityType creditedQuantityType = new CreditedQuantityType();
        invoicedQuantityType.cloneTo(creditedQuantityType);
        return creditedQuantityType;
    }

    @Nullable
    public static CreditNoteTypeCodeType cloneToCreditNoteTypeCode(@Nullable InvoiceTypeCodeType invoiceTypeCodeType) {
        if (invoiceTypeCodeType == null) {
            return null;
        }
        CreditNoteTypeCodeType creditNoteTypeCodeType = new CreditNoteTypeCodeType();
        invoiceTypeCodeType.cloneTo(creditNoteTypeCodeType);
        return creditNoteTypeCodeType;
    }

    public static void cloneToCreditNoteLine(@Nonnull InvoiceLineType invoiceLineType, @Nonnull CreditNoteLineType creditNoteLineType) {
        creditNoteLineType.setAccountingCost(invoiceLineType.getAccountingCost() == null ? null : invoiceLineType.getAccountingCost().clone());
        creditNoteLineType.setAccountingCostCode(invoiceLineType.getAccountingCostCode() == null ? null : invoiceLineType.getAccountingCostCode().clone());
        ArrayList<AllowanceChargeType> arrayList = new ArrayList<AllowanceChargeType>();
        for (AllowanceChargeType serializable : invoiceLineType.getAllowanceCharge()) {
            arrayList.add(serializable == null ? null : serializable.clone());
        }
        creditNoteLineType.setAllowanceCharge(arrayList);
        arrayList = new ArrayList();
        for (BillingReferenceType billingReferenceType : invoiceLineType.getBillingReference()) {
            arrayList.add((AllowanceChargeType)((Object)(billingReferenceType == null ? null : billingReferenceType.clone())));
        }
        creditNoteLineType.setBillingReference(arrayList);
        arrayList = new ArrayList();
        for (DeliveryType deliveryType : invoiceLineType.getDelivery()) {
            arrayList.add((AllowanceChargeType)((Object)(deliveryType == null ? null : deliveryType.clone())));
        }
        creditNoteLineType.setDelivery(arrayList);
        creditNoteLineType.setDeliveryTerms((List<DeliveryTermsType>)(invoiceLineType.getDeliveryTerms() == null ? null : new CommonsArrayList((Object)invoiceLineType.getDeliveryTerms().clone())));
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : invoiceLineType.getDespatchLineReference()) {
            arrayList.add((AllowanceChargeType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        creditNoteLineType.setDespatchLineReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceLineType.getDocumentReference()) {
            arrayList.add((AllowanceChargeType)((Object)(documentReferenceType == null ? null : documentReferenceType.clone())));
        }
        creditNoteLineType.setDocumentReference(arrayList);
        creditNoteLineType.setFreeOfChargeIndicator(invoiceLineType.getFreeOfChargeIndicator() == null ? null : invoiceLineType.getFreeOfChargeIndicator().clone());
        creditNoteLineType.setID(invoiceLineType.getID() == null ? null : invoiceLineType.getID().clone());
        arrayList = new ArrayList();
        for (PeriodType periodType : invoiceLineType.getInvoicePeriod()) {
            arrayList.add((AllowanceChargeType)((Object)(periodType == null ? null : periodType.clone())));
        }
        creditNoteLineType.setInvoicePeriod(arrayList);
        creditNoteLineType.setCreditedQuantity(invoiceLineType.getInvoicedQuantity() == null ? null : UBL22InvoiceHelper.cloneToCreditedQuantity(invoiceLineType.getInvoicedQuantity()));
        creditNoteLineType.setItem(invoiceLineType.getItem() == null ? null : invoiceLineType.getItem().clone());
        creditNoteLineType.setItemPriceExtension(invoiceLineType.getItemPriceExtension() == null ? null : invoiceLineType.getItemPriceExtension().clone());
        creditNoteLineType.setLineExtensionAmount(invoiceLineType.getLineExtensionAmount() == null ? null : invoiceLineType.getLineExtensionAmount().clone());
        arrayList = new ArrayList();
        for (NoteType noteType : invoiceLineType.getNote()) {
            arrayList.add((AllowanceChargeType)((Object)(noteType == null ? null : noteType.clone())));
        }
        creditNoteLineType.setNote(arrayList);
        arrayList = new ArrayList();
        for (OrderLineReferenceType orderLineReferenceType : invoiceLineType.getOrderLineReference()) {
            arrayList.add((AllowanceChargeType)((Object)(orderLineReferenceType == null ? null : orderLineReferenceType.clone())));
        }
        creditNoteLineType.setOrderLineReference(arrayList);
        creditNoteLineType.setOriginatorParty(invoiceLineType.getOriginatorParty() == null ? null : invoiceLineType.getOriginatorParty().clone());
        creditNoteLineType.setPaymentPurposeCode(invoiceLineType.getPaymentPurposeCode() == null ? null : invoiceLineType.getPaymentPurposeCode().clone());
        arrayList = new ArrayList();
        for (PaymentTermsType paymentTermsType : invoiceLineType.getPaymentTerms()) {
            arrayList.add((AllowanceChargeType)((Object)(paymentTermsType == null ? null : paymentTermsType.clone())));
        }
        creditNoteLineType.setPaymentTerms(arrayList);
        creditNoteLineType.setPrice(invoiceLineType.getPrice() == null ? null : invoiceLineType.getPrice().clone());
        creditNoteLineType.setPricingReference(invoiceLineType.getPricingReference() == null ? null : invoiceLineType.getPricingReference().clone());
        arrayList = new ArrayList();
        for (LineReferenceType lineReferenceType : invoiceLineType.getReceiptLineReference()) {
            arrayList.add((AllowanceChargeType)((Object)(lineReferenceType == null ? null : lineReferenceType.clone())));
        }
        creditNoteLineType.setReceiptLineReference(arrayList);
        arrayList = new ArrayList();
        for (InvoiceLineType invoiceLineType2 : invoiceLineType.getSubInvoiceLine()) {
            if (invoiceLineType2 == null) {
                arrayList.add(null);
                continue;
            }
            CreditNoteLineType creditNoteLineType2 = new CreditNoteLineType();
            UBL22InvoiceHelper.cloneToCreditNoteLine(invoiceLineType2, creditNoteLineType2);
            arrayList.add((AllowanceChargeType)((Object)creditNoteLineType2));
        }
        creditNoteLineType.setSubCreditNoteLine(arrayList);
        creditNoteLineType.setTaxPointDate(invoiceLineType.getTaxPointDate() == null ? null : invoiceLineType.getTaxPointDate().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : invoiceLineType.getTaxTotal()) {
            arrayList.add((AllowanceChargeType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        creditNoteLineType.setTaxTotal(arrayList);
        creditNoteLineType.setUUID(invoiceLineType.getUUID() == null ? null : invoiceLineType.getUUID().clone());
    }

    public static void cloneInvoiceToCreditNote(@Nonnull InvoiceType invoiceType, @Nonnull CreditNoteType creditNoteType) {
        creditNoteType.setAccountingCost(invoiceType.getAccountingCost() == null ? null : invoiceType.getAccountingCost().clone());
        creditNoteType.setAccountingCostCode(invoiceType.getAccountingCostCode() == null ? null : invoiceType.getAccountingCostCode().clone());
        creditNoteType.setAccountingCustomerParty(invoiceType.getAccountingCustomerParty() == null ? null : invoiceType.getAccountingCustomerParty().clone());
        creditNoteType.setAccountingSupplierParty(invoiceType.getAccountingSupplierParty() == null ? null : invoiceType.getAccountingSupplierParty().clone());
        ArrayList<DocumentReferenceType> arrayList = new ArrayList<DocumentReferenceType>();
        for (DocumentReferenceType serializable : invoiceType.getAdditionalDocumentReference()) {
            arrayList.add(serializable == null ? null : serializable.clone());
        }
        creditNoteType.setAdditionalDocumentReference(arrayList);
        arrayList = new ArrayList();
        for (AllowanceChargeType allowanceChargeType : invoiceType.getAllowanceCharge()) {
            arrayList.add((DocumentReferenceType)((Object)(allowanceChargeType == null ? null : allowanceChargeType.clone())));
        }
        creditNoteType.setAllowanceCharge(arrayList);
        arrayList = new ArrayList();
        for (BillingReferenceType billingReferenceType : invoiceType.getBillingReference()) {
            arrayList.add((DocumentReferenceType)((Object)(billingReferenceType == null ? null : billingReferenceType.clone())));
        }
        creditNoteType.setBillingReference(arrayList);
        creditNoteType.setBuyerCustomerParty(invoiceType.getBuyerCustomerParty() == null ? null : invoiceType.getBuyerCustomerParty().clone());
        creditNoteType.setBuyerReference(invoiceType.getBuyerReference() == null ? null : invoiceType.getBuyerReference().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getContractDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setContractDocumentReference(arrayList);
        creditNoteType.setCopyIndicator(invoiceType.getCopyIndicator() == null ? null : invoiceType.getCopyIndicator().clone());
        creditNoteType.setCustomizationID(invoiceType.getCustomizationID() == null ? null : invoiceType.getCustomizationID().clone());
        arrayList = new ArrayList();
        for (DeliveryType deliveryType : invoiceType.getDelivery()) {
            arrayList.add((DocumentReferenceType)((Object)(deliveryType == null ? null : deliveryType.clone())));
        }
        creditNoteType.setDelivery(arrayList);
        creditNoteType.setDeliveryTerms((List<DeliveryTermsType>)(invoiceType.getDeliveryTerms() == null ? null : new CommonsArrayList((Object)invoiceType.getDeliveryTerms().clone())));
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getDespatchDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setDespatchDocumentReference(arrayList);
        creditNoteType.setDocumentCurrencyCode(invoiceType.getDocumentCurrencyCode() == null ? null : invoiceType.getDocumentCurrencyCode().clone());
        creditNoteType.setDueDate(invoiceType.getDueDate() == null ? null : invoiceType.getDueDate().clone());
        creditNoteType.setID(invoiceType.getID() == null ? null : invoiceType.getID().clone());
        arrayList = new ArrayList();
        for (InvoiceLineType invoiceLineType : invoiceType.getInvoiceLine()) {
            if (invoiceLineType == null) {
                arrayList.add(null);
                continue;
            }
            CreditNoteLineType creditNoteLineType = new CreditNoteLineType();
            UBL22InvoiceHelper.cloneToCreditNoteLine(invoiceLineType, creditNoteLineType);
            arrayList.add((DocumentReferenceType)((Object)creditNoteLineType));
        }
        creditNoteType.setCreditNoteLine(arrayList);
        arrayList = new ArrayList();
        for (PeriodType periodType : invoiceType.getInvoicePeriod()) {
            arrayList.add((DocumentReferenceType)((Object)(periodType == null ? null : periodType.clone())));
        }
        creditNoteType.setInvoicePeriod(arrayList);
        creditNoteType.setCreditNoteTypeCode(UBL22InvoiceHelper.cloneToCreditNoteTypeCode(invoiceType.getInvoiceTypeCode()));
        creditNoteType.setIssueDate(invoiceType.getIssueDate() == null ? null : invoiceType.getIssueDate().clone());
        creditNoteType.setIssueTime(invoiceType.getIssueTime() == null ? null : invoiceType.getIssueTime().clone());
        creditNoteType.setLegalMonetaryTotal(invoiceType.getLegalMonetaryTotal() == null ? null : invoiceType.getLegalMonetaryTotal().clone());
        creditNoteType.setLineCountNumeric(invoiceType.getLineCountNumeric() == null ? null : invoiceType.getLineCountNumeric().clone());
        arrayList = new ArrayList();
        for (NoteType noteType : invoiceType.getNote()) {
            arrayList.add((DocumentReferenceType)((Object)(noteType == null ? null : noteType.clone())));
        }
        creditNoteType.setNote(arrayList);
        creditNoteType.setOrderReference(invoiceType.getOrderReference() == null ? null : invoiceType.getOrderReference().clone());
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getOriginatorDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setOriginatorDocumentReference(arrayList);
        creditNoteType.setPayeeParty(invoiceType.getPayeeParty() == null ? null : invoiceType.getPayeeParty().clone());
        creditNoteType.setPaymentAlternativeCurrencyCode(invoiceType.getPaymentAlternativeCurrencyCode() == null ? null : invoiceType.getPaymentAlternativeCurrencyCode().clone());
        creditNoteType.setPaymentAlternativeExchangeRate(invoiceType.getPaymentAlternativeExchangeRate() == null ? null : invoiceType.getPaymentAlternativeExchangeRate().clone());
        creditNoteType.setPaymentCurrencyCode(invoiceType.getPaymentCurrencyCode() == null ? null : invoiceType.getPaymentCurrencyCode().clone());
        creditNoteType.setPaymentExchangeRate(invoiceType.getPaymentExchangeRate() == null ? null : invoiceType.getPaymentExchangeRate().clone());
        arrayList = new ArrayList();
        for (PaymentMeansType paymentMeansType : invoiceType.getPaymentMeans()) {
            arrayList.add((DocumentReferenceType)((Object)(paymentMeansType == null ? null : paymentMeansType.clone())));
        }
        creditNoteType.setPaymentMeans(arrayList);
        arrayList = new ArrayList();
        for (PaymentTermsType paymentTermsType : invoiceType.getPaymentTerms()) {
            arrayList.add((DocumentReferenceType)((Object)(paymentTermsType == null ? null : paymentTermsType.clone())));
        }
        creditNoteType.setPaymentTerms(arrayList);
        creditNoteType.setPricingCurrencyCode(invoiceType.getPricingCurrencyCode() == null ? null : invoiceType.getPricingCurrencyCode().clone());
        creditNoteType.setPricingExchangeRate(invoiceType.getPricingExchangeRate() == null ? null : invoiceType.getPricingExchangeRate().clone());
        creditNoteType.setProfileExecutionID(invoiceType.getProfileExecutionID() == null ? null : invoiceType.getProfileExecutionID().clone());
        creditNoteType.setProfileID(invoiceType.getProfileID() == null ? null : invoiceType.getProfileID().clone());
        arrayList = new ArrayList();
        for (ProjectReferenceType projectReferenceType : invoiceType.getProjectReference()) {
            arrayList.add((DocumentReferenceType)((Object)(projectReferenceType == null ? null : projectReferenceType.clone())));
        }
        creditNoteType.setProjectReference(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getReceiptDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setReceiptDocumentReference(arrayList);
        creditNoteType.setSellerSupplierParty(invoiceType.getSellerSupplierParty() == null ? null : invoiceType.getSellerSupplierParty().clone());
        arrayList = new ArrayList();
        for (SignatureType signatureType : invoiceType.getSignature()) {
            arrayList.add((DocumentReferenceType)((Object)(signatureType == null ? null : signatureType.clone())));
        }
        creditNoteType.setSignature(arrayList);
        arrayList = new ArrayList();
        for (DocumentReferenceType documentReferenceType : invoiceType.getStatementDocumentReference()) {
            arrayList.add(documentReferenceType == null ? null : documentReferenceType.clone());
        }
        creditNoteType.setStatementDocumentReference(arrayList);
        creditNoteType.setTaxCurrencyCode(invoiceType.getTaxCurrencyCode() == null ? null : invoiceType.getTaxCurrencyCode().clone());
        creditNoteType.setTaxExchangeRate(invoiceType.getTaxExchangeRate() == null ? null : invoiceType.getTaxExchangeRate().clone());
        creditNoteType.setTaxPointDate(invoiceType.getTaxPointDate() == null ? null : invoiceType.getTaxPointDate().clone());
        creditNoteType.setTaxRepresentativeParty(invoiceType.getTaxRepresentativeParty() == null ? null : invoiceType.getTaxRepresentativeParty().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : invoiceType.getTaxTotal()) {
            arrayList.add((DocumentReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        creditNoteType.setTaxTotal(arrayList);
        creditNoteType.setUBLExtensions(invoiceType.getUBLExtensions() == null ? null : invoiceType.getUBLExtensions().clone());
        creditNoteType.setUBLVersionID(invoiceType.getUBLVersionID() == null ? null : invoiceType.getUBLVersionID().clone());
        creditNoteType.setUUID(invoiceType.getUUID() == null ? null : invoiceType.getUUID().clone());
        arrayList = new ArrayList();
        for (TaxTotalType taxTotalType : invoiceType.getWithholdingTaxTotal()) {
            arrayList.add((DocumentReferenceType)((Object)(taxTotalType == null ? null : taxTotalType.clone())));
        }
        creditNoteType.setWithholdingTaxTotal(arrayList);
    }
}

