/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl23;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.ubl23.EUBL23DocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBL23DocumentTypes {
    private static final ICommonsMap<String, EUBL23DocumentType> s_aNamespace2DocType = new CommonsHashMap();
    private static final ICommonsMap<String, EUBL23DocumentType> s_aLocalName2DocType = new CommonsHashMap();
    private static final UBL23DocumentTypes s_aInstance;

    private UBL23DocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllNamespaces() {
        return s_aNamespace2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL23DocumentType getDocumentTypeOfNamespace(@Nullable String string) {
        return (EUBL23DocumentType)((Object)s_aNamespace2DocType.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfNamespace(@Nullable String string) {
        EUBL23DocumentType eUBL23DocumentType = UBL23DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL23DocumentType == null ? null : eUBL23DocumentType.getImplementationClass();
    }

    @Nullable
    public static EUBL23DocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return (EUBL23DocumentType)((Object)ArrayHelper.findFirst((Object[])EUBL23DocumentType.values(), eUBL23DocumentType -> eUBL23DocumentType.getImplementationClass().equals(clazz)));
    }

    @Nullable
    public static Schema getSchemaOfNamespace(@Nullable String string) {
        EUBL23DocumentType eUBL23DocumentType = UBL23DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL23DocumentType == null ? null : eUBL23DocumentType.getSchema();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return s_aLocalName2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL23DocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EUBL23DocumentType)((Object)s_aLocalName2DocType.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBL23DocumentType eUBL23DocumentType = UBL23DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL23DocumentType == null ? null : eUBL23DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBL23DocumentType eUBL23DocumentType = UBL23DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL23DocumentType == null ? null : eUBL23DocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EUBL23DocumentType eUBL23DocumentType = UBL23DocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eUBL23DocumentType == null ? null : eUBL23DocumentType.getSchema();
    }

    static {
        for (EUBL23DocumentType eUBL23DocumentType : EUBL23DocumentType.values()) {
            String string = eUBL23DocumentType.getNamespaceURI();
            if (s_aNamespace2DocType.containsKey((Object)string)) {
                throw new IllegalArgumentException("The namespace '" + string + "' is already mapped!");
            }
            s_aNamespace2DocType.put((Object)string, (Object)eUBL23DocumentType);
            String string2 = eUBL23DocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey((Object)string2)) {
                throw new IllegalArgumentException("The local name '" + string2 + "' is already mapped!");
            }
            s_aLocalName2DocType.put((Object)string2, (Object)eUBL23DocumentType);
        }
        s_aInstance = new UBL23DocumentTypes();
    }
}

