/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.state.EChange;
import com.helger.xml.ls.SimpleLSResourceResolver;
import com.helger.xml.sax.LoggingSAXErrorHandler;
import com.helger.xml.schema.SchemaCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public class XMLSchemaCache
extends SchemaCache {
    private static boolean s_bDefaultInstantiated = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, XMLSchemaCache> s_aPerClassLoaderCache = new CommonsHashMap();

    @Nonnull
    public static SchemaFactory createXSDSchemaFactory() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory;
    }

    public XMLSchemaCache() {
        this(new LoggingSAXErrorHandler(), new SimpleLSResourceResolver());
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler) {
        this(errorHandler, null);
    }

    public XMLSchemaCache(@Nullable LSResourceResolver lSResourceResolver) {
        this(null, lSResourceResolver);
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        this(XMLSchemaCache.createXSDSchemaFactory(), errorHandler, lSResourceResolver);
    }

    public XMLSchemaCache(@Nonnull SchemaFactory schemaFactory, @Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super("XSD", schemaFactory, errorHandler, lSResourceResolver);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static XMLSchemaCache getInstance() {
        XMLSchemaCache xMLSchemaCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return xMLSchemaCache;
    }

    @Nonnull
    public static XMLSchemaCache getInstanceOfClassLoader(@Nullable IHasClassLoader iHasClassLoader) {
        return XMLSchemaCache.getInstanceOfClassLoader(iHasClassLoader == null ? null : iHasClassLoader.getClassLoader());
    }

    @Nonnull
    public static XMLSchemaCache getInstanceOfClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return XMLSchemaCache.getInstance();
        }
        String string = String.valueOf(classLoader);
        XMLSchemaCache xMLSchemaCache = (XMLSchemaCache)((Object)s_aRWLock.readLocked(() -> (XMLSchemaCache)((Object)((Object)s_aPerClassLoaderCache.get((Object)string)))));
        if (xMLSchemaCache == null) {
            xMLSchemaCache = (XMLSchemaCache)((Object)s_aRWLock.writeLocked(() -> (XMLSchemaCache)((Object)((Object)s_aPerClassLoaderCache.computeIfAbsent((Object)string, string -> new XMLSchemaCache(new SimpleLSResourceResolver(classLoader)))))));
        }
        return xMLSchemaCache;
    }

    @Nonnull
    public static EChange clearPerClassLoaderCache() {
        return (EChange)s_aRWLock.writeLocked(() -> s_aPerClassLoaderCache.removeAll());
    }

    private static final class SingletonHolder {
        private static final XMLSchemaCache s_aInstance = new XMLSchemaCache();

        private SingletonHolder() {
        }
    }
}

