
package com.helger.xsds.bdxr.smp2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.bdxr.smp2.ac.ServiceReferenceType;
import com.helger.xsds.bdxr.smp2.bc.ParticipantIDType;
import com.helger.xsds.bdxr.smp2.bc.SMPVersionIDType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;
import com.helger.xsds.xmldsig.SignatureType;


/**
 * <p>Java class for ServiceGroupType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ServiceGroupType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents}SMPExtensions" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}SMPVersionID"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}ParticipantID"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents}ServiceReference" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.w3.org/2000/09/xmldsig#}Signature" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ServiceGroupType", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/ServiceGroup", propOrder = {
    "smpExtensions",
    "smpVersionID",
    "participantID",
    "serviceReference",
    "signature"
})
@CodingStyleguideUnaware
public class ServiceGroupType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SMPExtensions", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name = "SMPVersionID", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required = true)
    private SMPVersionIDType smpVersionID;
    @XmlElement(name = "ParticipantID", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required = true)
    private ParticipantIDType participantID;
    @XmlElement(name = "ServiceReference", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents")
    private List<ServiceReferenceType> serviceReference;
    @XmlElement(name = "Signature", namespace = "http://www.w3.org/2000/09/xmldsig#")
    private List<SignatureType> signature;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ServiceGroupType() {
    }

    /**
     * Gets the value of the smpExtensions property.
     * 
     * @return
     *     possible object is
     *     {@link SMPExtensionsType }
     *     
     */
    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return smpExtensions;
    }

    /**
     * Sets the value of the smpExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link SMPExtensionsType }
     *     
     */
    public void setSMPExtensions(
        @Nullable
        SMPExtensionsType value) {
        this.smpExtensions = value;
    }

    /**
     * Gets the value of the smpVersionID property.
     * 
     * @return
     *     possible object is
     *     {@link SMPVersionIDType }
     *     
     */
    @Nullable
    public SMPVersionIDType getSMPVersionID() {
        return smpVersionID;
    }

    /**
     * Sets the value of the smpVersionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link SMPVersionIDType }
     *     
     */
    public void setSMPVersionID(
        @Nullable
        SMPVersionIDType value) {
        this.smpVersionID = value;
    }

    /**
     * Gets the value of the participantID property.
     * 
     * @return
     *     possible object is
     *     {@link ParticipantIDType }
     *     
     */
    @Nullable
    public ParticipantIDType getParticipantID() {
        return participantID;
    }

    /**
     * Sets the value of the participantID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ParticipantIDType }
     *     
     */
    public void setParticipantID(
        @Nullable
        ParticipantIDType value) {
        this.participantID = value;
    }

    /**
     * Gets the value of the serviceReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serviceReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getServiceReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ServiceReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ServiceReferenceType> getServiceReference() {
        if (serviceReference == null) {
            serviceReference = new ArrayList<ServiceReferenceType>();
        }
        return this.serviceReference;
    }

    /**
     * This is an optional set of digital signatures as defined by the W3C specification.Gets the value of the signature property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the signature property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSignature().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SignatureType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SignatureType> getSignature() {
        if (signature == null) {
            signature = new ArrayList<SignatureType>();
        }
        return this.signature;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ServiceGroupType rhs = ((ServiceGroupType) o);
        if (!EqualsHelper.equals(participantID, rhs.participantID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(serviceReference, rhs.serviceReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(signature, rhs.signature)) {
            return false;
        }
        if (!EqualsHelper.equals(smpExtensions, rhs.smpExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(smpVersionID, rhs.smpVersionID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(participantID).append(serviceReference).append(signature).append(smpExtensions).append(smpVersionID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("participantID", participantID).append("serviceReference", serviceReference).append("signature", signature).append("smpExtensions", smpExtensions).append("smpVersionID", smpVersionID).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServiceReference(
        @Nullable
        final List<ServiceReferenceType> aList) {
        serviceReference = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSignature(
        @Nullable
        final List<SignatureType> aList) {
        signature = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceReferenceEntries() {
        return (!getServiceReference().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceReferenceEntries() {
        return getServiceReference().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceReferenceCount() {
        return getServiceReference().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ServiceReferenceType getServiceReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServiceReference().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServiceReference(
        @Nonnull
        final ServiceReferenceType elem) {
        getServiceReference().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSignatureEntries() {
        return (!getSignature().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSignatureEntries() {
        return getSignature().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSignatureCount() {
        return getSignature().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SignatureType getSignatureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSignature().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSignature(
        @Nonnull
        final SignatureType elem) {
        getSignature().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ServiceGroupType ret) {
        ret.participantID = ((participantID == null)?null:participantID.clone());
        if (serviceReference == null) {
            ret.serviceReference = null;
        } else {
            List<ServiceReferenceType> retServiceReference = new ArrayList<ServiceReferenceType>();
            for (ServiceReferenceType aItem: getServiceReference()) {
                retServiceReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.serviceReference = retServiceReference;
        }
        if (signature == null) {
            ret.signature = null;
        } else {
            List<SignatureType> retSignature = new ArrayList<SignatureType>();
            for (SignatureType aItem: getSignature()) {
                retSignature.add(((aItem == null)?null:aItem.clone()));
            }
            ret.signature = retSignature;
        }
        ret.smpExtensions = ((smpExtensions == null)?null:smpExtensions.clone());
        ret.smpVersionID = ((smpVersionID == null)?null:smpVersionID.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ServiceGroupType clone() {
        ServiceGroupType ret = new ServiceGroupType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SMPVersionIDType and never <code>null</code>
     */
    @Nonnull
    public SMPVersionIDType setSMPVersionID(
        @Nullable
        final String valueParam) {
        SMPVersionIDType aObj = getSMPVersionID();
        if (aObj == null) {
            aObj = new SMPVersionIDType(valueParam);
            setSMPVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ParticipantIDType and never <code>null</code>
     */
    @Nonnull
    public ParticipantIDType setParticipantID(
        @Nullable
        final String valueParam) {
        ParticipantIDType aObj = getParticipantID();
        if (aObj == null) {
            aObj = new ParticipantIDType(valueParam);
            setParticipantID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained SMPVersionIDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SMPVersionIDType object or <code>null</code>
     */
    @Nullable
    public String getSMPVersionIDValue() {
        SMPVersionIDType aObj = getSMPVersionID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ParticipantIDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ParticipantIDType object or <code>null</code>
     */
    @Nullable
    public String getParticipantIDValue() {
        ParticipantIDType aObj = getParticipantID();
        return ((aObj == null)?null:aObj.getValue());
    }

}
