
package com.helger.xsds.bdxr.smp2.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.bdxr.smp2.bc.ActivationDateType;
import com.helger.xsds.bdxr.smp2.bc.AddressURIType;
import com.helger.xsds.bdxr.smp2.bc.ContactType;
import com.helger.xsds.bdxr.smp2.bc.DescriptionType;
import com.helger.xsds.bdxr.smp2.bc.ExpirationDateType;
import com.helger.xsds.bdxr.smp2.bc.TransportProfileIDType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;


/**
 * <p>Java class for EndpointType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="EndpointType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents}SMPExtensions" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}TransportProfileID"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}Description" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}Contact" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}AddressURI" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}ActivationDate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}ExpirationDate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents}Certificate" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EndpointType", propOrder = {
    "smpExtensions",
    "transportProfileID",
    "description",
    "contact",
    "addressURI",
    "activationDate",
    "expirationDate",
    "certificate"
})
@CodingStyleguideUnaware
public class EndpointType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SMPExtensions", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name = "TransportProfileID", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required = true)
    private TransportProfileIDType transportProfileID;
    @XmlElement(name = "Description", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private DescriptionType description;
    @XmlElement(name = "Contact", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ContactType contact;
    @XmlElement(name = "AddressURI", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private AddressURIType addressURI;
    @XmlElement(name = "ActivationDate", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ActivationDateType activationDate;
    @XmlElement(name = "ExpirationDate", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ExpirationDateType expirationDate;
    @XmlElement(name = "Certificate")
    private List<CertificateType> certificate;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public EndpointType() {
    }

    /**
     * Gets the value of the smpExtensions property.
     * 
     * @return
     *     possible object is
     *     {@link SMPExtensionsType }
     *     
     */
    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return smpExtensions;
    }

    /**
     * Sets the value of the smpExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link SMPExtensionsType }
     *     
     */
    public void setSMPExtensions(
        @Nullable
        SMPExtensionsType value) {
        this.smpExtensions = value;
    }

    /**
     * Gets the value of the transportProfileID property.
     * 
     * @return
     *     possible object is
     *     {@link TransportProfileIDType }
     *     
     */
    @Nullable
    public TransportProfileIDType getTransportProfileID() {
        return transportProfileID;
    }

    /**
     * Sets the value of the transportProfileID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportProfileIDType }
     *     
     */
    public void setTransportProfileID(
        @Nullable
        TransportProfileIDType value) {
        this.transportProfileID = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link DescriptionType }
     *     
     */
    @Nullable
    public DescriptionType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link DescriptionType }
     *     
     */
    public void setDescription(
        @Nullable
        DescriptionType value) {
        this.description = value;
    }

    /**
     * Gets the value of the contact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getContact() {
        return contact;
    }

    /**
     * Sets the value of the contact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setContact(
        @Nullable
        ContactType value) {
        this.contact = value;
    }

    /**
     * Gets the value of the addressURI property.
     * 
     * @return
     *     possible object is
     *     {@link AddressURIType }
     *     
     */
    @Nullable
    public AddressURIType getAddressURI() {
        return addressURI;
    }

    /**
     * Sets the value of the addressURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressURIType }
     *     
     */
    public void setAddressURI(
        @Nullable
        AddressURIType value) {
        this.addressURI = value;
    }

    /**
     * Gets the value of the activationDate property.
     * 
     * @return
     *     possible object is
     *     {@link ActivationDateType }
     *     
     */
    @Nullable
    public ActivationDateType getActivationDate() {
        return activationDate;
    }

    /**
     * Sets the value of the activationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivationDateType }
     *     
     */
    public void setActivationDate(
        @Nullable
        ActivationDateType value) {
        this.activationDate = value;
    }

    /**
     * Gets the value of the expirationDate property.
     * 
     * @return
     *     possible object is
     *     {@link ExpirationDateType }
     *     
     */
    @Nullable
    public ExpirationDateType getExpirationDate() {
        return expirationDate;
    }

    /**
     * Sets the value of the expirationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpirationDateType }
     *     
     */
    public void setExpirationDate(
        @Nullable
        ExpirationDateType value) {
        this.expirationDate = value;
    }

    /**
     * Gets the value of the certificate property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the certificate property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCertificate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CertificateType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CertificateType> getCertificate() {
        if (certificate == null) {
            certificate = new ArrayList<CertificateType>();
        }
        return this.certificate;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final EndpointType rhs = ((EndpointType) o);
        if (!EqualsHelper.equals(activationDate, rhs.activationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(addressURI, rhs.addressURI)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(certificate, rhs.certificate)) {
            return false;
        }
        if (!EqualsHelper.equals(contact, rhs.contact)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(expirationDate, rhs.expirationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(smpExtensions, rhs.smpExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(transportProfileID, rhs.transportProfileID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(activationDate).append(addressURI).append(certificate).append(contact).append(description).append(expirationDate).append(smpExtensions).append(transportProfileID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("activationDate", activationDate).append("addressURI", addressURI).append("certificate", certificate).append("contact", contact).append("description", description).append("expirationDate", expirationDate).append("smpExtensions", smpExtensions).append("transportProfileID", transportProfileID).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCertificate(
        @Nullable
        final List<CertificateType> aList) {
        certificate = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCertificateEntries() {
        return (!getCertificate().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCertificateEntries() {
        return getCertificate().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCertificateCount() {
        return getCertificate().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CertificateType getCertificateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCertificate().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCertificate(
        @Nonnull
        final CertificateType elem) {
        getCertificate().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        EndpointType ret) {
        ret.activationDate = ((activationDate == null)?null:activationDate.clone());
        ret.addressURI = ((addressURI == null)?null:addressURI.clone());
        if (certificate == null) {
            ret.certificate = null;
        } else {
            List<CertificateType> retCertificate = new ArrayList<CertificateType>();
            for (CertificateType aItem: getCertificate()) {
                retCertificate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.certificate = retCertificate;
        }
        ret.contact = ((contact == null)?null:contact.clone());
        ret.description = ((description == null)?null:description.clone());
        ret.expirationDate = ((expirationDate == null)?null:expirationDate.clone());
        ret.smpExtensions = ((smpExtensions == null)?null:smpExtensions.clone());
        ret.transportProfileID = ((transportProfileID == null)?null:transportProfileID.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public EndpointType clone() {
        EndpointType ret = new EndpointType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActivationDateType and never <code>null</code>
     */
    @Nonnull
    public ActivationDateType setActivationDate(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        ActivationDateType aObj = getActivationDate();
        if (aObj == null) {
            aObj = new ActivationDateType(valueParam);
            setActivationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpirationDateType and never <code>null</code>
     */
    @Nonnull
    public ExpirationDateType setExpirationDate(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        ExpirationDateType aObj = getExpirationDate();
        if (aObj == null) {
            aObj = new ExpirationDateType(valueParam);
            setExpirationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportProfileIDType and never <code>null</code>
     */
    @Nonnull
    public TransportProfileIDType setTransportProfileID(
        @Nullable
        final String valueParam) {
        TransportProfileIDType aObj = getTransportProfileID();
        if (aObj == null) {
            aObj = new TransportProfileIDType(valueParam);
            setTransportProfileID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AddressURIType and never <code>null</code>
     */
    @Nonnull
    public AddressURIType setAddressURI(
        @Nullable
        final String valueParam) {
        AddressURIType aObj = getAddressURI();
        if (aObj == null) {
            aObj = new AddressURIType(valueParam);
            setAddressURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DescriptionType and never <code>null</code>
     */
    @Nonnull
    public DescriptionType setDescription(
        @Nullable
        final String valueParam) {
        DescriptionType aObj = getDescription();
        if (aObj == null) {
            aObj = new DescriptionType(valueParam);
            setDescription(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ContactType and never <code>null</code>
     */
    @Nonnull
    public ContactType setContact(
        @Nullable
        final String valueParam) {
        ContactType aObj = getContact();
        if (aObj == null) {
            aObj = new ContactType(valueParam);
            setContact(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TransportProfileIDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportProfileIDType object or <code>null</code>
     */
    @Nullable
    public String getTransportProfileIDValue() {
        TransportProfileIDType aObj = getTransportProfileID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained DescriptionType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DescriptionType object or <code>null</code>
     */
    @Nullable
    public String getDescriptionValue() {
        DescriptionType aObj = getDescription();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ContactType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ContactType object or <code>null</code>
     */
    @Nullable
    public String getContactValue() {
        ContactType aObj = getContact();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained AddressURIType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AddressURIType object or <code>null</code>
     */
    @Nullable
    public String getAddressURIValue() {
        AddressURIType aObj = getAddressURI();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ActivationDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActivationDateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getActivationDateValue() {
        ActivationDateType aObj = getActivationDate();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ExpirationDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpirationDateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getExpirationDateValue() {
        ExpirationDateType aObj = getExpirationDate();
        return ((aObj == null)?null:aObj.getValue());
    }

}
