
package com.helger.xsds.bdxr.smp2.ac;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;


/**
 * <p>Java class for ProcessMetadataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ProcessMetadataType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents}SMPExtensions" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents}Process" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents}Endpoint" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents}Redirect" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ProcessMetadataType", propOrder = {
    "smpExtensions",
    "process",
    "endpoint",
    "redirect"
})
@CodingStyleguideUnaware
public class ProcessMetadataType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SMPExtensions", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name = "Process")
    private List<ProcessType> process;
    @XmlElement(name = "Endpoint")
    private List<EndpointType> endpoint;
    @XmlElement(name = "Redirect")
    private RedirectType redirect;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ProcessMetadataType() {
    }

    /**
     * Gets the value of the smpExtensions property.
     * 
     * @return
     *     possible object is
     *     {@link SMPExtensionsType }
     *     
     */
    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return smpExtensions;
    }

    /**
     * Sets the value of the smpExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link SMPExtensionsType }
     *     
     */
    public void setSMPExtensions(
        @Nullable
        SMPExtensionsType value) {
        this.smpExtensions = value;
    }

    /**
     * Gets the value of the process property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the process property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProcess().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcessType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProcessType> getProcess() {
        if (process == null) {
            process = new ArrayList<ProcessType>();
        }
        return this.process;
    }

    /**
     * Gets the value of the endpoint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the endpoint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEndpoint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EndpointType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EndpointType> getEndpoint() {
        if (endpoint == null) {
            endpoint = new ArrayList<EndpointType>();
        }
        return this.endpoint;
    }

    /**
     * Gets the value of the redirect property.
     * 
     * @return
     *     possible object is
     *     {@link RedirectType }
     *     
     */
    @Nullable
    public RedirectType getRedirect() {
        return redirect;
    }

    /**
     * Sets the value of the redirect property.
     * 
     * @param value
     *     allowed object is
     *     {@link RedirectType }
     *     
     */
    public void setRedirect(
        @Nullable
        RedirectType value) {
        this.redirect = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ProcessMetadataType rhs = ((ProcessMetadataType) o);
        if (!EqualsHelper.equalsCollection(endpoint, rhs.endpoint)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(process, rhs.process)) {
            return false;
        }
        if (!EqualsHelper.equals(redirect, rhs.redirect)) {
            return false;
        }
        if (!EqualsHelper.equals(smpExtensions, rhs.smpExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(endpoint).append(process).append(redirect).append(smpExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("endpoint", endpoint).append("process", process).append("redirect", redirect).append("smpExtensions", smpExtensions).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcess(
        @Nullable
        final List<ProcessType> aList) {
        process = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEndpoint(
        @Nullable
        final List<EndpointType> aList) {
        endpoint = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcessEntries() {
        return (!getProcess().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcessEntries() {
        return getProcess().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcessCount() {
        return getProcess().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProcessType getProcessAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcess().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcess(
        @Nonnull
        final ProcessType elem) {
        getProcess().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEndpointEntries() {
        return (!getEndpoint().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEndpointEntries() {
        return getEndpoint().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEndpointCount() {
        return getEndpoint().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EndpointType getEndpointAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEndpoint().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEndpoint(
        @Nonnull
        final EndpointType elem) {
        getEndpoint().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ProcessMetadataType ret) {
        if (endpoint == null) {
            ret.endpoint = null;
        } else {
            List<EndpointType> retEndpoint = new ArrayList<EndpointType>();
            for (EndpointType aItem: getEndpoint()) {
                retEndpoint.add(((aItem == null)?null:aItem.clone()));
            }
            ret.endpoint = retEndpoint;
        }
        if (process == null) {
            ret.process = null;
        } else {
            List<ProcessType> retProcess = new ArrayList<ProcessType>();
            for (ProcessType aItem: getProcess()) {
                retProcess.add(((aItem == null)?null:aItem.clone()));
            }
            ret.process = retProcess;
        }
        ret.redirect = ((redirect == null)?null:redirect.clone());
        ret.smpExtensions = ((smpExtensions == null)?null:smpExtensions.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ProcessMetadataType clone() {
        ProcessMetadataType ret = new ProcessMetadataType();
        cloneTo(ret);
        return ret;
    }

}
