
package com.helger.xsds.xmldsig11;

import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * <p>Java class for ECParametersType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ECParametersType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="FieldID" type="{http://www.w3.org/2009/xmldsig11#}FieldIDType"/&gt;
 *         &lt;element name="Curve" type="{http://www.w3.org/2009/xmldsig11#}CurveType"/&gt;
 *         &lt;element name="Base" type="{http://www.w3.org/2009/xmldsig11#}ECPointType"/&gt;
 *         &lt;element name="Order" type="{http://www.w3.org/2000/09/xmldsig#}CryptoBinary"/&gt;
 *         &lt;element name="CoFactor" type="{http://www.w3.org/2001/XMLSchema}integer" minOccurs="0"/&gt;
 *         &lt;element name="ValidationData" type="{http://www.w3.org/2009/xmldsig11#}ECValidationDataType" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ECParametersType", propOrder = {
    "fieldID",
    "curve",
    "base",
    "order",
    "coFactor",
    "validationData"
})
@CodingStyleguideUnaware
public class ECParametersType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "FieldID", required = true)
    private FieldIDType fieldID;
    @XmlElement(name = "Curve", required = true)
    private CurveType curve;
    @XmlElement(name = "Base", required = true)
    private byte[] base;
    @XmlElement(name = "Order", required = true)
    private byte[] order;
    @XmlElement(name = "CoFactor")
    private BigInteger coFactor;
    @XmlElement(name = "ValidationData")
    private ECValidationDataType validationData;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ECParametersType() {
    }

    /**
     * Gets the value of the fieldID property.
     * 
     * @return
     *     possible object is
     *     {@link FieldIDType }
     *     
     */
    @Nullable
    public FieldIDType getFieldID() {
        return fieldID;
    }

    /**
     * Sets the value of the fieldID property.
     * 
     * @param value
     *     allowed object is
     *     {@link FieldIDType }
     *     
     */
    public void setFieldID(
        @Nullable
        FieldIDType value) {
        this.fieldID = value;
    }

    /**
     * Gets the value of the curve property.
     * 
     * @return
     *     possible object is
     *     {@link CurveType }
     *     
     */
    @Nullable
    public CurveType getCurve() {
        return curve;
    }

    /**
     * Sets the value of the curve property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurveType }
     *     
     */
    public void setCurve(
        @Nullable
        CurveType value) {
        this.curve = value;
    }

    /**
     * Gets the value of the base property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    @Nullable
    public byte[] getBase() {
        return base;
    }

    /**
     * Sets the value of the base property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setBase(
        @Nullable
        byte[] value) {
        this.base = value;
    }

    /**
     * Gets the value of the order property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    @Nullable
    public byte[] getOrder() {
        return order;
    }

    /**
     * Sets the value of the order property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setOrder(
        @Nullable
        byte[] value) {
        this.order = value;
    }

    /**
     * Gets the value of the coFactor property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getCoFactor() {
        return coFactor;
    }

    /**
     * Sets the value of the coFactor property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setCoFactor(
        @Nullable
        BigInteger value) {
        this.coFactor = value;
    }

    /**
     * Gets the value of the validationData property.
     * 
     * @return
     *     possible object is
     *     {@link ECValidationDataType }
     *     
     */
    @Nullable
    public ECValidationDataType getValidationData() {
        return validationData;
    }

    /**
     * Sets the value of the validationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ECValidationDataType }
     *     
     */
    public void setValidationData(
        @Nullable
        ECValidationDataType value) {
        this.validationData = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ECParametersType rhs = ((ECParametersType) o);
        if (!EqualsHelper.equals(base, rhs.base)) {
            return false;
        }
        if (!EqualsHelper.equals(coFactor, rhs.coFactor)) {
            return false;
        }
        if (!EqualsHelper.equals(curve, rhs.curve)) {
            return false;
        }
        if (!EqualsHelper.equals(fieldID, rhs.fieldID)) {
            return false;
        }
        if (!EqualsHelper.equals(order, rhs.order)) {
            return false;
        }
        if (!EqualsHelper.equals(validationData, rhs.validationData)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(base).append(coFactor).append(curve).append(fieldID).append(order).append(validationData).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("base", base).append("coFactor", coFactor).append("curve", curve).append("fieldID", fieldID).append("order", order).append("validationData", validationData).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ECParametersType ret) {
        ret.base = ArrayHelper.getCopy(base);
        ret.coFactor = coFactor;
        ret.curve = ((curve == null)?null:curve.clone());
        ret.fieldID = ((fieldID == null)?null:fieldID.clone());
        ret.order = ArrayHelper.getCopy(order);
        ret.validationData = ((validationData == null)?null:validationData.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ECParametersType clone() {
        ECParametersType ret = new ECParametersType();
        cloneTo(ret);
        return ret;
    }

}
