/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.http.HttpMimeMessageEntity;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import org.apache.http.HttpEntity;

public final class AS4ClientBuiltMessage {
    private final String m_sMessageID;
    private final HttpEntity m_aHttpEntity;
    private final HttpHeaderMap m_aCustomHeaders;

    public AS4ClientBuiltMessage(@Nonnull @Nonempty String string, @Nonnull HttpXMLEntity httpXMLEntity) {
        this.m_sMessageID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        this.m_aHttpEntity = (HttpEntity)ValueEnforcer.notNull((Object)((Object)httpXMLEntity), (String)"HttpEntity");
        this.m_aCustomHeaders = null;
    }

    public AS4ClientBuiltMessage(@Nonnull @Nonempty String string, @Nonnull HttpMimeMessageEntity httpMimeMessageEntity) throws MessagingException {
        this.m_sMessageID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        this.m_aHttpEntity = (HttpEntity)ValueEnforcer.notNull((Object)((Object)httpMimeMessageEntity), (String)"HttpEntity");
        this.m_aCustomHeaders = MessageHelperMethods.getAndRemoveAllHeaders(httpMimeMessageEntity.getMimeMessage());
    }

    @Nonnull
    @Nonempty
    public String getMessageID() {
        return this.m_sMessageID;
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpEntity getHttpEntity() {
        return this.m_aHttpEntity;
    }

    @Nullable
    @ReturnsMutableCopy
    public HttpHeaderMap getCustomHeaders() {
        return this.m_aCustomHeaders == null ? null : this.m_aCustomHeaders.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("MessageID", (Object)this.m_sMessageID).append("HttpEntity", (Object)this.m_aHttpEntity).appendIfNotNull("CustomHeaders", (Object)this.m_aCustomHeaders).getToString();
    }
}

