/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.ThreadHelper;
import com.helger.commons.functional.IConsumer;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.wrapper.Wrapper;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.util.MultiOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.mail.MessagingException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpPoster {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHttpPoster.class);
    private HttpClientFactory m_aHttpClientFactory = BasicHttpPoster.createDefaultHttpClientFactory();
    private IConsumer<? super HttpPost> m_aHttpCustomizer;
    private boolean m_bQuoteHttpHeaders = false;

    @Nonnull
    public static HttpClientFactory createDefaultHttpClientFactory() {
        return new HttpClientFactory();
    }

    @Nonnull
    public final HttpClientFactory getHttpClientFactory() {
        return this.m_aHttpClientFactory;
    }

    @Nonnull
    public final BasicHttpPoster setHttpClientFactory(@Nonnull HttpClientFactory httpClientFactory) {
        ValueEnforcer.notNull((Object)httpClientFactory, (String)"HttpClientFactory");
        this.m_aHttpClientFactory = httpClientFactory;
        return this;
    }

    @Nullable
    public final IConsumer<? super HttpPost> getHttpCustomizer() {
        return this.m_aHttpCustomizer;
    }

    @Nonnull
    public final BasicHttpPoster setHttpCustomizer(@Nullable IConsumer<? super HttpPost> iConsumer) {
        this.m_aHttpCustomizer = iConsumer;
        return this;
    }

    public final boolean isQuoteHttpHeaders() {
        return this.m_bQuoteHttpHeaders;
    }

    @Nonnull
    public final BasicHttpPoster setQuoteHttpHeaders(boolean bl) {
        this.m_bQuoteHttpHeaders = bl;
        return this;
    }

    @Nullable
    public final <T> T sendGenericMessage(@Nonnull @Nonempty String string, @Nonnull HttpEntity httpEntity, @Nullable HttpHeaderMap httpHeaderMap, @Nonnull ResponseHandler<? extends T> responseHandler) throws MessagingException, IOException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URL");
        ValueEnforcer.notNull((Object)httpEntity, (String)"HttpEntity");
        try (HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)this.m_aHttpClientFactory);){
            HttpPost httpPost = new HttpPost(string);
            if (httpHeaderMap != null) {
                httpHeaderMap.forEachSingleHeader((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1), true, this.m_bQuoteHttpHeaders);
            }
            httpPost.setEntity(httpEntity);
            if (this.m_aHttpCustomizer != null) {
                this.m_aHttpCustomizer.accept((Object)httpPost);
            }
            AS4HttpDebug.debug(() -> {
                StringBuilder stringBuilder = new StringBuilder("SEND-START to ").append(string).append("\n");
                try {
                    for (Header header : httpPost.getAllHeaders()) {
                        stringBuilder.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
                    }
                    stringBuilder.append("\r\n");
                    if (httpEntity.isRepeatable()) {
                        stringBuilder.append(EntityUtils.toString((HttpEntity)httpEntity));
                    } else {
                        stringBuilder.append("## The payload is marked as 'not repeatable' and is the therefore not printed in debugging");
                    }
                }
                catch (Exception exception) {
                    stringBuilder.append("## Exception listing payload: " + exception.getClass().getName() + " -- " + exception.getMessage()).append("\r\n");
                    stringBuilder.append("## ").append(StackTraceHelper.getStackAsString((Throwable)exception));
                }
                return stringBuilder.toString();
            });
            Object object = httpClientManager.execute((HttpUriRequest)httpPost, responseHandler);
            return (T)object;
        }
    }

    @Nonnull
    private static HttpEntity _createDumpingHttpEntity(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nonnull HttpEntity httpEntity, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n, @Nonnull Wrapper<OutputStream> wrapper) throws IOException {
        if (iAS4OutgoingDumper == null) {
            return httpEntity;
        }
        final OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(string, httpHeaderMap, n);
        if (outputStream == null) {
            return httpEntity;
        }
        wrapper.set((Object)outputStream);
        return new HttpEntityWrapper(httpEntity){

            public InputStream getContent() throws IOException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(@Nonnull @WillNotClose OutputStream outputStream2) throws IOException {
                MultiOutputStream multiOutputStream = new MultiOutputStream(outputStream2, outputStream);
                super.writeTo((OutputStream)multiOutputStream);
                multiOutputStream.flush();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public final <T> T sendGenericMessageWithRetries(@Nullable HttpHeaderMap httpHeaderMap, @Nonnull HttpEntity httpEntity, @Nonnull String string, @Nonnull String string2, int n, long l, @Nonnull ResponseHandler<? extends T> responseHandler, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) throws Exception {
        T t;
        IAS4OutgoingDumper iAS4OutgoingDumper2 = iAS4OutgoingDumper != null ? iAS4OutgoingDumper : AS4DumpManager.getOutgoingDumper();
        Wrapper wrapper = new Wrapper();
        if (n > 0) {
            if (!httpEntity.isRepeatable()) {
                throw new IllegalStateException("If retry is enabled, a repeatable entity must be provided");
            }
            int n2 = 1 + n;
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    LOGGER.info("Retry #" + n3 + "/" + n2 + " for sending message with ID '" + string + "'");
                }
                try {
                    HttpEntity httpEntity2 = BasicHttpPoster._createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string, httpHeaderMap, n3, (Wrapper<OutputStream>)wrapper);
                    T t2 = this.sendGenericMessage(string2, httpEntity2, httpHeaderMap, responseHandler);
                    return t2;
                }
                catch (IOException iOException) {
                    if (n3 == n2 - 1) {
                        throw iOException;
                    }
                    LOGGER.warn("Error sending message: " + iOException.getClass().getSimpleName() + " - " + iOException.getMessage() + " - waiting " + l + " ms, than retrying");
                    ThreadHelper.sleep((long)l);
                    ++n3;
                }
            }
            throw new IllegalStateException("Should never be reached (after maximum of " + n2 + " tries)!");
            finally {
                StreamHelper.flush((Flushable)((Flushable)wrapper.get()));
                StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
            }
        }
        HttpEntity httpEntity3 = BasicHttpPoster._createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string, httpHeaderMap, 0, (Wrapper<OutputStream>)wrapper);
        try {
            t = this.sendGenericMessage(string2, httpEntity3, httpHeaderMap, responseHandler);
        }
        catch (Throwable throwable) {
            StreamHelper.flush((Flushable)((Flushable)wrapper.get()));
            StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
            throw throwable;
        }
        StreamHelper.flush((Flushable)((Flushable)wrapper.get()));
        StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
        return t;
        finally {
            if (iAS4OutgoingDumper2 != null) {
                try {
                    iAS4OutgoingDumper2.onEndRequest(string);
                }
                catch (Exception exception) {
                    LOGGER.error("OutgoingDumper.onEndRequest failed. Dumper=" + iAS4OutgoingDumper2 + "; MessageID=" + string, (Throwable)exception);
                }
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HttpClientFactory", (Object)this.m_aHttpClientFactory).append("HttpCustomizer", this.m_aHttpCustomizer).append("QuoteHttpHeaders", this.m_bQuoteHttpHeaders).getToString();
    }
}

