/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.security.keystore.KeyStoreHelper;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.dom.engine.WSSConfig;

@Immutable
public class AS4CryptoFactoryInMemoryKeyStore
implements IAS4CryptoFactory {
    private final KeyStore m_aKeyStore;
    private final String m_sKeyAlias;
    private final String m_sKeyPassword;
    private final KeyStore m_aTrustStore;
    private Merlin m_aCrypto;
    private KeyStore.PrivateKeyEntry m_aPK;

    public AS4CryptoFactoryInMemoryKeyStore(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string, @Nonnull String string2, @Nullable KeyStore keyStore2) {
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"KeyAlias");
        ValueEnforcer.notNull((Object)string2, (String)"KeyPassword");
        this.m_aKeyStore = keyStore;
        this.m_sKeyAlias = string;
        this.m_sKeyPassword = string2;
        this.m_aTrustStore = keyStore2;
    }

    @Override
    @Nonnull
    public final Crypto getCrypto() {
        Merlin merlin = this.m_aCrypto;
        if (merlin == null) {
            merlin = this.m_aCrypto = new Merlin(this.m_aTrustStore == null, "changeit");
            merlin.setKeyStore(this.m_aKeyStore);
            merlin.setTrustStore(this.m_aTrustStore);
        }
        return merlin;
    }

    @Override
    @Nonnull
    public final KeyStore getKeyStore() {
        return this.m_aKeyStore;
    }

    @Override
    @Nullable
    public final KeyStore.PrivateKeyEntry getPrivateKeyEntry() {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.m_aPK;
        if (privateKeyEntry == null) {
            privateKeyEntry = this.m_aPK = (KeyStore.PrivateKeyEntry)KeyStoreHelper.loadPrivateKey((KeyStore)this.m_aKeyStore, (String)"in-memory KeyStore", (String)this.m_sKeyAlias, (char[])this.m_sKeyPassword.toCharArray()).getKeyEntry();
        }
        return privateKeyEntry;
    }

    @Override
    @Nonnull
    public final String getKeyAlias() {
        return this.m_sKeyAlias;
    }

    @Override
    @Nonnull
    public final String getKeyPassword() {
        return this.m_sKeyPassword;
    }

    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }

    static {
        WSSConfig.init();
    }
}

