/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.crypto.AS4CryptoProperties;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class AS4CryptoFactoryPropertiesFile
implements IAS4CryptoFactory {
    private static final Logger LOGGER;
    private static final AtomicBoolean DEFAULT_INSTANCE_INITED;
    private static AS4CryptoFactoryPropertiesFile _DEFAULT_INSTANCE;
    private final AS4CryptoProperties m_aCryptoProps;
    private Crypto m_aCrypto;
    private KeyStore m_aKeyStore;
    private KeyStore.PrivateKeyEntry m_aPK;

    @Nullable
    public static AS4CryptoFactoryPropertiesFile getDefaultInstance() {
        AS4CryptoFactoryPropertiesFile aS4CryptoFactoryPropertiesFile = _DEFAULT_INSTANCE;
        if (DEFAULT_INSTANCE_INITED.compareAndSet(false, true)) {
            try {
                aS4CryptoFactoryPropertiesFile = _DEFAULT_INSTANCE = new AS4CryptoFactoryPropertiesFile((String)null);
            }
            catch (InitializationException initializationException) {
                LOGGER.warn("Failed to init default crypto factory: " + initializationException.getMessage());
            }
        }
        return aS4CryptoFactoryPropertiesFile;
    }

    @Nonnull
    public static AS4CryptoProperties readCryptoPropertiesFromFile(@Nullable String string) {
        AS4CryptoProperties aS4CryptoProperties;
        if (StringHelper.hasNoText((String)string)) {
            aS4CryptoProperties = new AS4CryptoProperties((IReadableResource)new ClassPathResource("private-crypto.properties"));
            if (!aS4CryptoProperties.isRead()) {
                aS4CryptoProperties = new AS4CryptoProperties((IReadableResource)new ClassPathResource("crypto.properties"));
            }
        } else {
            aS4CryptoProperties = new AS4CryptoProperties((IReadableResource)new ClassPathResource(string));
        }
        return aS4CryptoProperties;
    }

    public AS4CryptoFactoryPropertiesFile(@Nullable String string) {
        this(AS4CryptoFactoryPropertiesFile.readCryptoPropertiesFromFile(string));
        if (!this.m_aCryptoProps.isRead()) {
            throw new InitializationException("Failed to locate crypto properties in '" + string + "'");
        }
    }

    public AS4CryptoFactoryPropertiesFile(@Nonnull AS4CryptoProperties aS4CryptoProperties) {
        ValueEnforcer.notNull((Object)aS4CryptoProperties, (String)"CryptoProps");
        this.m_aCryptoProps = aS4CryptoProperties.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4CryptoProperties cryptoProperties() {
        return this.m_aCryptoProps;
    }

    @Nonnull
    public static Crypto createCrypto(@Nonnull AS4CryptoProperties aS4CryptoProperties) {
        ValueEnforcer.notNull((Object)aS4CryptoProperties, (String)"CryptoProps");
        try {
            return CryptoFactory.getInstance((Properties)aS4CryptoProperties.getAsProperties());
        }
        catch (WSSecurityException wSSecurityException) {
            throw new InitializationException("Failed to init crypto properties!", (Throwable)wSSecurityException);
        }
    }

    @Override
    @Nonnull
    public final Crypto getCrypto() {
        Crypto crypto = this.m_aCrypto;
        if (crypto == null) {
            crypto = this.m_aCrypto = AS4CryptoFactoryPropertiesFile.createCrypto(this.m_aCryptoProps);
        }
        return crypto;
    }

    @Override
    @Nullable
    public final KeyStore getKeyStore() {
        KeyStore keyStore = this.m_aKeyStore;
        if (keyStore == null) {
            keyStore = this.m_aKeyStore = KeyStoreHelper.loadKeyStore((IKeyStoreType)this.m_aCryptoProps.getKeyStoreType(), (String)this.m_aCryptoProps.getKeyStorePath(), (String)this.m_aCryptoProps.getKeyStorePassword()).getKeyStore();
        }
        return keyStore;
    }

    @Override
    @Nullable
    public final KeyStore.PrivateKeyEntry getPrivateKeyEntry() {
        KeyStore keyStore;
        KeyStore.PrivateKeyEntry privateKeyEntry = this.m_aPK;
        if (privateKeyEntry == null && (keyStore = this.getKeyStore()) != null) {
            String string = this.m_aCryptoProps.getKeyPassword();
            privateKeyEntry = this.m_aPK = (KeyStore.PrivateKeyEntry)KeyStoreHelper.loadPrivateKey((KeyStore)keyStore, (String)this.m_aCryptoProps.getKeyStorePath(), (String)this.m_aCryptoProps.getKeyAlias(), (char[])(string == null ? ArrayHelper.EMPTY_CHAR_ARRAY : string.toCharArray())).getKeyEntry();
        }
        return privateKeyEntry;
    }

    @Override
    @Nullable
    public final String getKeyAlias() {
        return this.m_aCryptoProps.getKeyAlias();
    }

    @Override
    @Nullable
    public final String getKeyPassword() {
        return this.m_aCryptoProps.getKeyPassword();
    }

    @Nullable
    public final X509Certificate getCertificate() {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry();
        return privateKeyEntry == null ? null : (X509Certificate)privateKeyEntry.getCertificate();
    }

    static {
        WSSConfig.init();
        LOGGER = LoggerFactory.getLogger(AS4CryptoFactoryPropertiesFile.class);
        DEFAULT_INSTANCE_INITED = new AtomicBoolean(false);
        _DEFAULT_INSTANCE = null;
    }
}

