/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.string.StringHelper;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.dom.WsuIdAllocator;
import org.apache.wss4j.dom.engine.WSSConfig;

public interface IAS4CryptoFactory {
    @Nonnull
    public Crypto getCrypto();

    @Nullable
    public KeyStore getKeyStore();

    @Nullable
    public KeyStore.PrivateKeyEntry getPrivateKeyEntry();

    @Nullable
    public String getKeyAlias();

    @Nullable
    public String getKeyPassword();

    @Nonnull
    default public WSSConfig createWSSConfig() {
        WSSConfig wSSConfig = WSSConfig.getNewInstance();
        wSSConfig.setIdAllocator(new WsuIdAllocator(){

            public String createId(@Nullable String string, Object object) {
                return this.createSecureId(string, object);
            }

            public String createSecureId(String string, Object object) {
                return StringHelper.getConcatenatedOnDemand((String)string, (String)"-", (String)MessageHelperMethods.createRandomWSUID());
            }
        });
        return wSSConfig;
    }
}

