/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.duplicate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.duplicate.IAS4DuplicateItem;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4DuplicateItem
implements IAS4DuplicateItem {
    private final LocalDateTime m_aDT;
    private final String m_sMessageID;
    private final String m_sProfileID;
    private final String m_sPModeID;

    public AS4DuplicateItem(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3) {
        this(PDTFactory.getCurrentLocalDateTime(), string, string2, string3);
    }

    AS4DuplicateItem(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3) {
        this.m_aDT = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"DT");
        this.m_sMessageID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        this.m_sProfileID = string2;
        this.m_sPModeID = string3;
    }

    @Override
    @Nonnull
    public final LocalDateTime getDateTime() {
        return this.m_aDT;
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.getMessageID();
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getMessageID() {
        return this.m_sMessageID;
    }

    @Override
    @Nullable
    public final String getProfileID() {
        return this.m_sProfileID;
    }

    @Override
    @Nullable
    public final String getPModeID() {
        return this.m_sPModeID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AS4DuplicateItem aS4DuplicateItem = (AS4DuplicateItem)object;
        return this.m_sMessageID.equals(aS4DuplicateItem.m_sMessageID) && EqualsHelper.equals((Object)this.m_sProfileID, (Object)aS4DuplicateItem.m_sProfileID) && EqualsHelper.equals((Object)this.m_sPModeID, (Object)aS4DuplicateItem.m_sPModeID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sMessageID).append((Object)this.m_sProfileID).append((Object)this.m_sPModeID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("DT", (Object)this.m_aDT).append("MessageID", (Object)this.m_sMessageID).appendIfNotNull("ProfileID", (Object)this.m_sProfileID).appendIfNotNull("PModeID", (Object)this.m_sPModeID).getToString();
    }
}

