/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.error;

import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.phase4.ebms3header.Ebms3Description;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.error.EEbmsErrorCategory;
import com.helger.phase4.error.EEbmsErrorSeverity;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IEbmsError
extends Serializable {
    @Nonnull
    public String getErrorCode();

    @Nonnull
    public EEbmsErrorSeverity getSeverity();

    @Nonnull
    public String getShortDescription();

    @Nonnull
    public IHasDisplayText getErrorDetail();

    @Nonnull
    public EEbmsErrorCategory getCategory();

    @Nonnull
    default public IError getAsError(@Nonnull Locale locale) {
        return ((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(this.getSeverity().getErrorLevel())).setErrorID(this.getErrorCode())).setErrorText("[" + this.getCategory().getDisplayName() + "] " + StringHelper.getNotNull((String)this.getErrorDetail().getDisplayText(locale), (String)this.getShortDescription()))).build();
    }

    @Nonnull
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string) {
        return this.getAsEbms3Error(locale, string, null);
    }

    @Nonnull
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string, @Nullable String string2) {
        return this.getAsEbms3Error(locale, string, (String)null, string2);
    }

    @Nonnull
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        return this.getAsEbms3Error(locale, string, string2, string3 == null ? null : MessageHelperMethods.createEbms3Description(locale, string3));
    }

    @Nonnull
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string, @Nullable String string2, @Nullable Ebms3Description ebms3Description) {
        Ebms3Error ebms3Error = new Ebms3Error();
        ebms3Error.setDescription(ebms3Description != null ? ebms3Description : MessageHelperMethods.createEbms3Description(locale, this.getShortDescription()));
        ebms3Error.setErrorDetail(this.getErrorDetail().getDisplayText(locale));
        ebms3Error.setErrorCode(this.getErrorCode());
        ebms3Error.setSeverity(this.getSeverity().getSeverity());
        ebms3Error.setShortDescription(this.getShortDescription());
        ebms3Error.setCategory(this.getCategory().getDisplayName());
        ebms3Error.setRefToMessageInError(string);
        ebms3Error.setOrigin(string2);
        return ebms3Error;
    }
}

