/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.mgr;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.phase4.mgr.IManagerFactory;
import com.helger.phase4.mgr.ManagerFactoryInMemory;
import com.helger.phase4.mgr.ManagerFactoryPersistingFileSystem;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.profile.AS4ProfileManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaAS4Manager
extends AbstractGlobalSingleton {
    public static final String SYSTEM_PROPERTY_PHASE4_MANAGER_INMEMORY = "phase4.manager.inmemory";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaAS4Manager.class);
    private IMPCManager m_aMPCMgr;
    private IPModeManager m_aPModeMgr;
    private IAS4DuplicateManager m_aIncomingDuplicateMgr;
    private AS4ProfileManager m_aProfileMgr;

    @Deprecated
    @UsedViaReflection
    public MetaAS4Manager() {
    }

    private void _initCallbacks() {
    }

    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            IManagerFactory iManagerFactory;
            String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_PHASE4_MANAGER_INMEMORY);
            boolean bl = StringParser.parseBool((String)string, (boolean)false);
            if (bl) {
                LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " is initialized with in-memory data structures");
                iManagerFactory = new ManagerFactoryInMemory();
            } else {
                LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " is using file system persistence");
                iManagerFactory = new ManagerFactoryPersistingFileSystem();
            }
            this.m_aMPCMgr = iManagerFactory.createMPCManager();
            this.m_aPModeMgr = iManagerFactory.createPModeManager();
            this.m_aIncomingDuplicateMgr = iManagerFactory.createDuplicateManager();
            this.m_aProfileMgr = new AS4ProfileManager();
            this._initCallbacks();
            this.m_aPModeMgr.validateAllPModes();
            LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " was initialized");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName((Object)((Object)this)), (Throwable)exception);
        }
    }

    protected void onBeforeDestroy(@Nonnull IScope iScope) throws Exception {
    }

    @Nonnull
    public static MetaAS4Manager getInstance() {
        return (MetaAS4Manager)MetaAS4Manager.getGlobalSingleton(MetaAS4Manager.class);
    }

    @Nonnull
    public static IMPCManager getMPCMgr() {
        return MetaAS4Manager.getInstance().m_aMPCMgr;
    }

    @Nonnull
    public static IPModeManager getPModeMgr() {
        return MetaAS4Manager.getInstance().m_aPModeMgr;
    }

    @Nonnull
    public static IAS4DuplicateManager getIncomingDuplicateMgr() {
        return MetaAS4Manager.getInstance().m_aIncomingDuplicateMgr;
    }

    @Nonnull
    public static AS4ProfileManager getProfileMgr() {
        return MetaAS4Manager.getInstance().m_aProfileMgr;
    }
}

