/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPModeManager {
    public void createPMode(@Nonnull PMode var1);

    @Nonnull
    public EChange updatePMode(@Nonnull IPMode var1);

    @Nonnull
    default public void createOrUpdatePMode(@Nonnull PMode pMode) {
        IPMode iPMode = this.findFirst((Predicate<? super IPMode>)IPModeManager.getPModeFilter(pMode.getID(), pMode.getInitiatorID(), pMode.getResponderID()));
        if (iPMode == null) {
            this.createPMode(pMode);
        } else {
            this.updatePMode(pMode);
        }
    }

    @Nonnull
    public EChange markPModeDeleted(@Nullable String var1);

    @Nonnull
    public EChange deletePMode(@Nullable String var1);

    @Nullable
    public IPMode findFirst(@Nonnull Predicate<? super IPMode> var1);

    @Nullable
    default public IPMode getPModeOfServiceAndAction(@Nullable String string, @Nullable String string2) {
        return this.findFirst(iPMode -> {
            PModeLegBusinessInformation pModeLegBusinessInformation;
            PModeLeg pModeLeg = iPMode.getLeg1();
            if (pModeLeg != null && (pModeLegBusinessInformation = pModeLeg.getBusinessInfo()) != null) {
                return EqualsHelper.equals((Object)pModeLegBusinessInformation.getService(), (Object)string) && EqualsHelper.equals((Object)pModeLegBusinessInformation.getAction(), (Object)string2);
            }
            return false;
        });
    }

    @Nonnull
    public static IPredicate<IPMode> getPModeFilter(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return (IPredicate & Serializable)iPMode -> ((String)iPMode.getID()).equals(string) && iPMode.hasInitiatorID(string2) && iPMode.hasResponderID(string3);
    }

    @Nullable
    public IPMode getPModeOfID(@Nullable String var1);

    @Nonnull
    public ICommonsList<IPMode> getAll();

    @Nonnull
    public ICommonsSet<String> getAllIDs();

    default public void validatePMode(@Nullable IPMode iPMode) throws PModeValidationException {
        PModeParty pModeParty;
        ValueEnforcer.notNull((Object)iPMode, (String)"PMode");
        if (StringHelper.hasNoText((String)((String)iPMode.getID()))) {
            throw new PModeValidationException("No PMode ID present");
        }
        PModeParty pModeParty2 = iPMode.getInitiator();
        if (pModeParty2 != null) {
            if (StringHelper.hasNoText((String)pModeParty2.getIDValue())) {
                throw new PModeValidationException("No PMode Initiator ID present");
            }
            if (StringHelper.hasNoText((String)pModeParty2.getRole())) {
                throw new PModeValidationException("No PMode Initiator Role present");
            }
        }
        if ((pModeParty = iPMode.getResponder()) != null) {
            if (StringHelper.hasNoText((String)pModeParty.getIDValue())) {
                throw new PModeValidationException("No PMode Responder ID present");
            }
            if (StringHelper.hasNoText((String)pModeParty.getRole())) {
                throw new PModeValidationException("No PMode Responder Role present");
            }
        }
        if (pModeParty == null && pModeParty2 == null) {
            throw new PModeValidationException("PMode is missing Initiator and/or Responder");
        }
    }

    default public void validateAllPModes() throws PModeValidationException {
        for (IPMode iPMode : this.getAll()) {
            this.validatePMode(iPMode);
        }
    }
}

