/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.tenancy.IBusinessObject;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PModeMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<PMode> {
    private static final String ELEMENT_INITIATOR = "Initiator";
    private static final String ELEMENT_RESPONDER = "Responder";
    private static final IMicroQName ATTR_AGREEMENT = new MicroQName("Agreement");
    private static final IMicroQName ATTR_MEP = new MicroQName("MEP");
    private static final IMicroQName ATTR_MEP_BINDING = new MicroQName("MEPBinding");
    private static final String ELEMENT_LEG1 = "Leg1";
    private static final String ELEMENT_LEG2 = "Leg2";
    private static final String ELEMENT_PAYLOADSERVICE = "PayloadServices";
    private static final String ELEMENT_RECEPETIONAWARENESS = "RecepetionAwareness";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PMode pMode, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        PModeMicroTypeConverter.setObjectFields((IBusinessObject)pMode, (IMicroElement)microElement);
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pMode.getInitiator(), (String)string, (String)ELEMENT_INITIATOR));
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pMode.getResponder(), (String)string, (String)ELEMENT_RESPONDER));
        microElement.setAttribute(ATTR_AGREEMENT, pMode.getAgreement());
        microElement.setAttribute(ATTR_MEP, pMode.getMEPID());
        microElement.setAttribute(ATTR_MEP_BINDING, pMode.getMEPBindingID());
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pMode.getLeg1(), (String)string, (String)ELEMENT_LEG1));
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pMode.getLeg2(), (String)string, (String)ELEMENT_LEG2));
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pMode.getPayloadService(), (String)string, (String)ELEMENT_PAYLOADSERVICE));
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pMode.getReceptionAwareness(), (String)string, (String)ELEMENT_RECEPETIONAWARENESS));
        return microElement;
    }

    @Nonnull
    public PMode convertToNative(@Nonnull IMicroElement iMicroElement) {
        PModeParty pModeParty = (PModeParty)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_INITIATOR), PModeParty.class);
        PModeParty pModeParty2 = (PModeParty)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_RESPONDER), PModeParty.class);
        String string = iMicroElement.getAttributeValue(ATTR_AGREEMENT);
        String string2 = iMicroElement.getAttributeValue(ATTR_MEP);
        EMEP eMEP = EMEP.getFromIDOrNull(string2);
        if (eMEP == null) {
            throw new IllegalStateException("Failed to resolve MEP '" + string2 + "'");
        }
        String string3 = iMicroElement.getAttributeValue(ATTR_MEP_BINDING);
        EMEPBinding eMEPBinding = EMEPBinding.getFromIDOrNull(string3);
        if (eMEPBinding == null) {
            throw new IllegalStateException("Failed to resolve MEPBinding '" + string3 + "'");
        }
        PModeLeg pModeLeg = (PModeLeg)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_LEG1), PModeLeg.class);
        PModeLeg pModeLeg2 = (PModeLeg)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_LEG2), PModeLeg.class);
        PModePayloadService pModePayloadService = (PModePayloadService)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_PAYLOADSERVICE), PModePayloadService.class);
        PModeReceptionAwareness pModeReceptionAwareness = (PModeReceptionAwareness)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_RECEPETIONAWARENESS), PModeReceptionAwareness.class);
        PMode pMode = new PMode(PModeMicroTypeConverter.getStubObject((IMicroElement)iMicroElement), pModeParty, pModeParty2, string, eMEP, eMEPBinding, pModeLeg, pModeLeg2, pModePayloadService, pModeReceptionAwareness);
        return pMode;
    }
}

