/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class PModeAddressList
implements Serializable,
ICloneable<PModeAddressList> {
    public static final char ADDRESS_SEPARATOR = ',';
    private final ICommonsList<String> m_aAddresses = new CommonsArrayList();

    public PModeAddressList() {
    }

    public PModeAddressList(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addAddress(string);
            }
        }
    }

    public PModeAddressList(@Nullable Collection<String> collection) {
        if (collection != null) {
            this.m_aAddresses.addAll(collection);
        }
    }

    public final void addAddress(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Address");
        this.m_aAddresses.add((Object)string);
    }

    @Nonnull
    public EChange removeAddress(@Nullable String string) {
        return this.m_aAddresses.removeObject((Object)string);
    }

    @Nonnull
    public EChange removeAllAddresses() {
        return this.m_aAddresses.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllAddresses() {
        return (ICommonsList)this.m_aAddresses.getClone();
    }

    @Nonnegative
    public int getAddressCount() {
        return this.m_aAddresses.size();
    }

    public boolean isEmpty() {
        return this.m_aAddresses.isEmpty();
    }

    @Nonnull
    public String getAsString() {
        return StringHelper.getImploded((char)',', this.m_aAddresses);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PModeAddressList getClone() {
        return new PModeAddressList((Collection<String>)this.m_aAddresses);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeAddressList pModeAddressList = (PModeAddressList)object;
        return this.m_aAddresses.equals(pModeAddressList.m_aAddresses);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aAddresses).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Addresses", this.m_aAddresses).getToString();
    }

    @Nonnull
    public static PModeAddressList createFromString(@Nullable String string) {
        ICommonsList iCommonsList = StringHelper.getExploded((char)',', (String)string);
        return new PModeAddressList((Collection<String>)iCommonsList);
    }
}

