/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.name.IHasName;
import com.helger.commons.state.EMandatory;
import com.helger.commons.state.IMandatoryIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class PModePayloadProfile
implements IHasName,
IMandatoryIndicator,
Serializable {
    public static final boolean DEFAULT_MANDATORY = false;
    private final String m_sName;
    private final IMimeType m_aMimeType;
    private final String m_sXSDFilename;
    private final Integer m_aMaxSizeKB;
    private final EMandatory m_eMandatory;

    public PModePayloadProfile(@Nonnull @Nonempty String string, @Nonnull IMimeType iMimeType, @Nullable String string2, @Nullable Integer n, @Nonnull EMandatory eMandatory) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        this.m_aMimeType = (IMimeType)ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        this.m_sXSDFilename = string2;
        this.m_aMaxSizeKB = n;
        this.m_eMandatory = (EMandatory)ValueEnforcer.notNull((Object)eMandatory, (String)"Mandatory");
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nullable
    public String getXSDFilename() {
        return this.m_sXSDFilename;
    }

    public boolean hasXSDFilename() {
        return StringHelper.hasText((String)this.m_sXSDFilename);
    }

    @Nullable
    public Integer getMaxSizeKB() {
        return this.m_aMaxSizeKB;
    }

    public boolean hasMaxSizeKB() {
        return this.m_aMaxSizeKB != null;
    }

    public boolean isMandatory() {
        return this.m_eMandatory.isMandatory();
    }

    public boolean isOptional() {
        return this.m_eMandatory.isOptional();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModePayloadProfile pModePayloadProfile = (PModePayloadProfile)object;
        return this.m_sName.equals(pModePayloadProfile.m_sName) && this.m_aMimeType.equals(pModePayloadProfile.m_aMimeType) && EqualsHelper.equals((Object)this.m_sXSDFilename, (Object)pModePayloadProfile.m_sXSDFilename) && EqualsHelper.equals((Object)this.m_aMaxSizeKB, (Object)pModePayloadProfile.m_aMaxSizeKB) && this.m_eMandatory.equals((Object)pModePayloadProfile.m_eMandatory);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_aMimeType).append((Object)this.m_sXSDFilename).append((Object)this.m_aMaxSizeKB).append((Enum)this.m_eMandatory).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Name", (Object)this.m_sName).append("MimeType", (Object)this.m_aMimeType).append("XSDFilename", (Object)this.m_sXSDFilename).append("MaxSizeKB", (Object)this.m_aMaxSizeKB).append("Mandatory", (Enum)this.m_eMandatory).getToString();
    }
}

