/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.state.EMandatory;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PModePayloadProfileMicroTypeConverter
extends AbstractPModeMicroTypeConverter<PModePayloadProfile> {
    private static final IMicroQName ATTR_NAME = new MicroQName("Name");
    private static final IMicroQName ATTR_MIME_TYPE = new MicroQName("MimeType");
    private static final IMicroQName ATTR_XSD_FILENAME = new MicroQName("XSDFilename");
    private static final IMicroQName ATTR_MAX_SIZE_KB = new MicroQName("MaxSizeKB");
    private static final IMicroQName ATTR_MANDATORY = new MicroQName("Mandatory");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PModePayloadProfile pModePayloadProfile, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_NAME, pModePayloadProfile.getName());
        microElement.setAttribute(ATTR_MIME_TYPE, pModePayloadProfile.getMimeType().getAsString());
        microElement.setAttribute(ATTR_XSD_FILENAME, pModePayloadProfile.getXSDFilename());
        if (pModePayloadProfile.hasMaxSizeKB()) {
            microElement.setAttribute(ATTR_MAX_SIZE_KB, pModePayloadProfile.getMaxSizeKB().intValue());
        }
        microElement.setAttribute(ATTR_MANDATORY, pModePayloadProfile.isMandatory());
        return microElement;
    }

    @Nonnull
    public PModePayloadProfile convertToNative(IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_NAME);
        MimeType mimeType = MimeTypeParser.parseMimeType((String)iMicroElement.getAttributeValue(ATTR_MIME_TYPE));
        String string2 = iMicroElement.getAttributeValue(ATTR_XSD_FILENAME);
        Integer n = (Integer)iMicroElement.getAttributeValueWithConversion(ATTR_MAX_SIZE_KB, Integer.class);
        EMandatory eMandatory = EMandatory.valueOf((boolean)iMicroElement.getAttributeValueAsBool(ATTR_MANDATORY, false));
        return new PModePayloadProfile(string, (IMimeType)mimeType, string2, n, eMandatory);
    }
}

