/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfileRegistrar;
import com.helger.phase4.profile.IAS4ProfileRegistrarSPI;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AS4ProfileManager
implements IAS4ProfileRegistrar,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ProfileManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IAS4Profile> m_aMap = new CommonsHashMap();
    @GuardedBy(value="m_aRWLock")
    private IAS4Profile m_aDefaultProfile;

    private void _registerAll() {
        this.m_aRWLock.writeLocked(() -> this.m_aMap.clear());
        for (IAS4ProfileRegistrarSPI iAS4ProfileRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IAS4ProfileRegistrarSPI.class)) {
            iAS4ProfileRegistrarSPI.registerAS4Profile(this);
        }
        if (LOGGER.isInfoEnabled()) {
            int n = this.getProfileCount();
            LOGGER.info(n == 1 ? "1 AS4 profile is registered " : n + " AS4 profiles are registered");
        }
    }

    public AS4ProfileManager() {
        this._registerAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAS4Profile> getAllProfiles() {
        return (ICommonsList)this.m_aRWLock.readLocked(() -> this.m_aMap.copyOfValues());
    }

    @Nonnegative
    public final int getProfileCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aMap.size());
    }

    @Nullable
    public IAS4Profile getProfileOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IAS4Profile)this.m_aRWLock.readLocked(() -> (IAS4Profile)this.m_aMap.get((Object)string));
    }

    @Override
    public void registerProfile(@Nonnull IAS4Profile iAS4Profile) {
        ValueEnforcer.notNull((Object)iAS4Profile, (String)"AS4Profile");
        String string = (String)iAS4Profile.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)string)) {
                throw new IllegalStateException("An AS4 profile with ID '" + string + "' is already registered!");
            }
            this.m_aMap.put((Object)string, (Object)iAS4Profile);
            if (this.m_aMap.size() == 1) {
                this.m_aDefaultProfile = iAS4Profile;
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered" + (iAS4Profile.isDeprecated() ? " deprecated" : "") + " AS4 profile '" + string + "'");
        }
    }

    public boolean hasDefaultProfile() {
        return this.m_aRWLock.readLocked(() -> this.m_aDefaultProfile != null);
    }

    @Nullable
    public IAS4Profile getDefaultProfileOrNull() {
        return (IAS4Profile)this.m_aRWLock.readLocked(() -> {
            int n;
            IAS4Profile iAS4Profile = this.m_aDefaultProfile;
            if (iAS4Profile == null && (n = this.m_aMap.size()) == 1) {
                iAS4Profile = (IAS4Profile)this.m_aMap.getFirstValue();
            }
            return iAS4Profile;
        });
    }

    @Nonnull
    public IAS4Profile getDefaultProfile() {
        return (IAS4Profile)this.m_aRWLock.readLocked(() -> {
            IAS4Profile iAS4Profile = this.m_aDefaultProfile;
            if (iAS4Profile == null) {
                int n = this.m_aMap.size();
                if (n == 1) {
                    iAS4Profile = (IAS4Profile)this.m_aMap.getFirstValue();
                } else {
                    if (n == 0) {
                        throw new IllegalStateException("No AS4 profile is present, so no default profile can be determined!");
                    }
                    throw new IllegalStateException(n + " AS4 profiles are present, but none is declared default!");
                }
            }
            return iAS4Profile;
        });
    }

    @Nullable
    public IAS4Profile setDefaultProfileID(@Nullable String string) {
        IAS4Profile iAS4Profile = this.getProfileOfID(string);
        this.setDefaultProfile(iAS4Profile);
        return iAS4Profile;
    }

    @Override
    public void setDefaultProfile(@Nullable IAS4Profile iAS4Profile) {
        EChange eChange = (EChange)this.m_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals((Object)iAS4Profile, (Object)this.m_aDefaultProfile)) {
                return EChange.UNCHANGED;
            }
            this.m_aDefaultProfile = iAS4Profile;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            if (iAS4Profile == null) {
                LOGGER.info("Removed the default AS4 profile");
            } else {
                LOGGER.info("Set the default AS4 profile to '" + (String)iAS4Profile.getID() + "'" + (iAS4Profile.isDeprecated() ? " which is deprecated" : ""));
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).append("DefaultProfile", (Object)this.m_aDefaultProfile).getToString();
    }
}

