/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.util;

import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.phase4.marshaller.Ebms3NamespaceHandler;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.EXMLSerializeXMLDeclaration;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class AS4XMLHelper {
    public static final XMLWriterSettings XWS = XMLWriterSettings.createForCanonicalization();

    private AS4XMLHelper() {
    }

    @Nonnull
    private static String _serializePh(@Nonnull Node node) {
        return XMLWriter.getNodeAsString((Node)node, (IXMLWriterSettings)XWS);
    }

    @Nonnull
    private static String _serializeRT(@Nonnull Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
            transformer.transform(new DOMSource(node), new StreamResult((Writer)nonBlockingStringWriter));
            return nonBlockingStringWriter.getAsString();
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException("Failed to serialize XML", transformerException);
        }
    }

    @Nonnull
    public static String serializeXML(@Nonnull Node node) {
        return AS4XMLHelper._serializeRT(node);
    }

    static {
        XWS.setNamespaceContext((INamespaceContext)new Ebms3NamespaceHandler());
        XWS.setIndent(EXMLSerializeIndent.NONE);
        XWS.setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.EMIT_NO_STANDALONE);
    }
}

