/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.wss;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EWSSVersion {
    WSS_10("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse", "1.0"),
    WSS_11("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse", "1.1"),
    WSS_111("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse", "1.1.1");

    private final String m_sNamespaceURI;
    private final String m_sNamespacePrefix;
    private final String m_sVersion;

    private EWSSVersion(@Nonnull @Nonempty String string2, String string3, String string4) {
        this.m_sNamespaceURI = string2;
        this.m_sNamespacePrefix = string3;
        this.m_sVersion = string4;
    }

    @Nonnull
    @Nonempty
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Nonnull
    @Nonempty
    public String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonnull
    @Nonempty
    public String getVersion() {
        return this.m_sVersion;
    }

    @Nullable
    public static EWSSVersion getFromVersionOrNull(@Nullable String string) {
        return EWSSVersion.getFromVersionOrDefault(string, null);
    }

    @Nullable
    public static EWSSVersion getFromVersionOrDefault(@Nullable String string, @Nullable EWSSVersion eWSSVersion2) {
        if (StringHelper.hasNoText((String)string)) {
            return eWSSVersion2;
        }
        return (EWSSVersion)EnumHelper.findFirst(EWSSVersion.class, eWSSVersion -> eWSSVersion.getVersion().equals(string), (Enum)eWSSVersion2);
    }
}

