/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.server.servlet;

import com.helger.commons.debug.GlobalDebug;
import com.helger.httpclient.HttpDebugger;
import com.helger.phase4.crypto.AS4CryptoFactory;
import com.helger.phase4.model.pmode.resolve.DefaultPModeResolver;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4ServerInitializer;
import com.helger.phase4.servlet.mgr.AS4ServerConfiguration;
import com.helger.photon.core.servlet.WebAppListener;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.UserManager;
import com.helger.xservlet.requesttrack.RequestTracker;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class AS4WebAppListener
extends WebAppListener {
    public AS4WebAppListener() {
        this.setHandleStatisticsOnEnd(false);
    }

    @Nullable
    protected String getInitParameterDebug(@Nonnull ServletContext servletContext) {
        return Boolean.toString(AS4ServerConfiguration.isGlobalDebug());
    }

    @Nullable
    protected String getInitParameterProduction(@Nonnull ServletContext servletContext) {
        return Boolean.toString(AS4ServerConfiguration.isGlobalProduction());
    }

    @Nullable
    protected String getInitParameterNoStartupInfo(@Nonnull ServletContext servletContext) {
        return Boolean.toString(AS4ServerConfiguration.isNoStartupInfo());
    }

    protected String getDataPath(@Nonnull ServletContext servletContext) {
        return AS4ServerConfiguration.getDataPath();
    }

    protected boolean shouldCheckFileAccess(@Nonnull ServletContext servletContext) {
        return false;
    }

    protected void initGlobalSettings() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        if (GlobalDebug.isDebugMode()) {
            RequestTracker.getInstance().getRequestTrackingMgr().setLongRunningCheckEnabled(false);
        }
        HttpDebugger.setEnabled((boolean)false);
    }

    protected void initSecurity() {
        UserManager userManager = PhotonSecurityManager.getUserMgr();
        if (!userManager.containsWithID("admin")) {
            userManager.createPredefinedUser("admin", "Admin", "admin@helger.com", "password", "Admin", "istrator", null, Locale.US, null, false);
        }
    }

    protected void initManagers() {
        IPModeResolver iPModeResolver = DefaultPModeResolver.DEFAULT_PMODE_RESOLVER;
        AS4CryptoFactory aS4CryptoFactory = AS4CryptoFactory.DEFAULT_INSTANCE;
        AS4ServerInitializer.initAS4Server((IPModeResolver)iPModeResolver, (AS4CryptoFactory)aS4CryptoFactory);
    }
}

