/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.util.AS4ResourceHelper;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSS4JAttachmentCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSS4JAttachmentCallbackHandler.class);
    private final ICommonsOrderedMap<String, WSS4JAttachment> m_aAttachmentMap = new CommonsLinkedHashMap();
    private final AS4ResourceHelper m_aResHelper;

    public WSS4JAttachmentCallbackHandler(@Nullable Iterable<? extends WSS4JAttachment> iterable, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        if (iterable != null) {
            for (WSS4JAttachment wSS4JAttachment : iterable) {
                this.m_aAttachmentMap.put((Object)wSS4JAttachment.getId(), (Object)wSS4JAttachment);
            }
        }
        this.m_aResHelper = aS4ResourceHelper;
    }

    @Nonnull
    public final AS4ResourceHelper getResourceHelper() {
        return this.m_aResHelper;
    }

    @Nonnull
    @ReturnsMutableCopy
    private ICommonsList<Attachment> _getAttachmentsToAdd(@Nullable String string) {
        WSS4JAttachment wSS4JAttachment = (WSS4JAttachment)this.m_aAttachmentMap.get((Object)string);
        if (wSS4JAttachment != null) {
            return new CommonsArrayList((Object)wSS4JAttachment);
        }
        if ("Attachments".equals(string)) {
            return new CommonsArrayList(this.m_aAttachmentMap.values());
        }
        throw new IllegalStateException("Failed to resolve attachment with ID '" + string + "'");
    }

    @Override
    public void handle(@Nonnull Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            ICommonsList<Attachment> iCommonsList;
            String string;
            AttachmentRequestCallback attachmentRequestCallback;
            if (callback instanceof AttachmentRequestCallback) {
                attachmentRequestCallback = (AttachmentRequestCallback)callback;
                string = attachmentRequestCallback.getAttachmentId();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Requesting attachment ID '" + string + "'");
                }
                if ((iCommonsList = this._getAttachmentsToAdd(string)).isEmpty()) {
                    throw new IllegalStateException("No attachments present for ID '" + string + "'");
                }
                attachmentRequestCallback.setAttachments(iCommonsList);
                continue;
            }
            if (callback instanceof AttachmentResultCallback) {
                WSS4JAttachment wSS4JAttachment;
                attachmentRequestCallback = (AttachmentResultCallback)callback;
                string = attachmentRequestCallback.getAttachment();
                iCommonsList = attachmentRequestCallback.getAttachmentId();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resulting attachment ID '" + iCommonsList + "'");
                }
                if ((wSS4JAttachment = (WSS4JAttachment)this.m_aAttachmentMap.get(iCommonsList)) == null) {
                    throw new IllegalStateException("Failed to resolve source attachment with ID '" + iCommonsList + "'");
                }
                WSS4JAttachment wSS4JAttachment2 = new WSS4JAttachment(this.m_aResHelper, string.getMimeType());
                wSS4JAttachment2.setId((String)iCommonsList);
                wSS4JAttachment2.addHeaders(string.getHeaders());
                wSS4JAttachment2.setCharset(wSS4JAttachment.getCharsetOrDefault(null));
                wSS4JAttachment2.setSourceStreamProvider((IHasInputStream)HasInputStream.once(() -> ((Attachment)string).getSourceStream()));
                if (this.m_aAttachmentMap.containsKey(iCommonsList)) {
                    LOGGER.warn("Internal issue: overwriting the attachment with ID '" + iCommonsList + "'!");
                }
                this.m_aAttachmentMap.put(iCommonsList, (Object)wSS4JAttachment2);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback of class " + callback.getClass().getName());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WSS4JAttachment> getAllResponseAttachments() {
        return this.m_aAttachmentMap.copyOfValues();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, WSS4JAttachment> responseAttachments() {
        return this.m_aAttachmentMap;
    }
}

