/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AbstractAS4ClientSignalMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.error.IEbmsError;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.domain.AS4ErrorMessage;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.w3c.dom.Document;

public class AS4ClientErrorMessage
extends AbstractAS4ClientSignalMessage<AS4ClientErrorMessage> {
    private final ICommonsList<Ebms3Error> m_aErrorMessages = new CommonsArrayList();

    public AS4ClientErrorMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        super(EAS4MessageType.ERROR_MESSAGE, aS4ResourceHelper);
    }

    public final void addErrorMessage(@Nonnull IEbmsError iEbmsError, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)iEbmsError, (String)"Error");
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        this.m_aErrorMessages.add((Object)iEbmsError.getAsEbms3Error(locale, this.getRefToMessageID()));
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<Ebms3Error> errorMessages() {
        return this.m_aErrorMessages;
    }

    private void _checkMandatoryAttributes() {
        if (this.getSoapVersion() == null) {
            throw new IllegalStateException("A SOAP version must be set.");
        }
        if (this.m_aErrorMessages.isEmpty()) {
            throw new IllegalStateException("No Errors specified!");
        }
        if (this.m_aErrorMessages.containsAny(Objects::isNull)) {
            throw new IllegalStateException("Errors may not contain null elements.");
        }
        if (!this.hasRefToMessageID()) {
            throw new IllegalStateException("No reference to a message set.");
        }
    }

    @Override
    public AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) throws IOException {
        this._checkMandatoryAttributes();
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, this.getRefToMessageID(), this.getSendingDateTimeOrNow());
        AS4ErrorMessage aS4ErrorMessage = AS4ErrorMessage.create(this.getSoapVersion(), ebms3MessageInfo, this.m_aErrorMessages);
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onAS4Message(aS4ErrorMessage);
        }
        Document document = aS4ErrorMessage.getAsSoapDocument();
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onSoapDocument(document);
        }
        return new AS4ClientBuiltMessage(string, new HttpXMLEntity(document, this.getSoapVersion().getMimeType()));
    }
}

