/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.commons.wrapper.Wrapper;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.http.BasicHttpPoster;
import com.helger.phase4.http.HttpRetrySettings;
import com.helger.phase4.http.IHttpPoster;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.mail.MessagingException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.wss4j.common.ext.WSSecurityException;

public abstract class AbstractAS4Client<IMPLTYPE extends AbstractAS4Client<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    private final EAS4MessageType m_eMessageType;
    private final AS4ResourceHelper m_aResHelper;
    private IAS4CryptoFactory m_aCryptoFactory;
    private final AS4SigningParams m_aSigningParams = new AS4SigningParams();
    private final AS4CryptParams m_aCryptParams = new AS4CryptParams();
    private IHttpPoster m_aHttpPoster = new BasicHttpPoster();
    private Supplier<String> m_aMessageIDFactory = AbstractAS4Client.createDefaultMessageIDFactory();
    private String m_sRefToMessageID;
    private OffsetDateTime m_aSendingDateTime;
    private ESoapVersion m_eSoapVersion = ESoapVersion.AS4_DEFAULT;
    private final HttpRetrySettings m_aHttpRetrySettings = new HttpRetrySettings();

    @Nonnull
    public static Supplier<String> createDefaultMessageIDFactory() {
        return MessageHelperMethods::createRandomMessageID;
    }

    protected AbstractAS4Client(@Nonnull EAS4MessageType eAS4MessageType, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull((Object)((Object)eAS4MessageType), (String)"MessageType");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        this.m_eMessageType = eAS4MessageType;
        this.m_aResHelper = aS4ResourceHelper;
    }

    @Nonnull
    public final EAS4MessageType getMessageType() {
        return this.m_eMessageType;
    }

    @Nonnull
    public final AS4ResourceHelper getAS4ResourceHelper() {
        return this.m_aResHelper;
    }

    @Nullable
    public final IAS4CryptoFactory getAS4CryptoFactory() {
        return this.m_aCryptoFactory;
    }

    @Nonnull
    public final IMPLTYPE setAS4CryptoFactory(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.m_aCryptoFactory = iAS4CryptoFactory;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4SigningParams signingParams() {
        return this.m_aSigningParams;
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4CryptParams cryptParams() {
        return this.m_aCryptParams;
    }

    @Nonnull
    public final IHttpPoster getHttpPoster() {
        return this.m_aHttpPoster;
    }

    @Nonnull
    public final IMPLTYPE setHttpPoster(@Nonnull IHttpPoster iHttpPoster) {
        ValueEnforcer.notNull((Object)iHttpPoster, (String)"HttpPoster");
        this.m_aHttpPoster = iHttpPoster;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    public final Supplier<String> getMessageIDFactory() {
        return this.m_aMessageIDFactory;
    }

    @Nonnull
    public final IMPLTYPE setMessageID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        return this.setMessageIDFactory(() -> string);
    }

    @Nonnull
    public final IMPLTYPE setMessageIDFactory(@Nonnull Supplier<String> supplier) {
        ValueEnforcer.notNull(supplier, (String)"MessageIDFactory");
        this.m_aMessageIDFactory = supplier;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    @Nonempty
    public final String createMessageID() {
        String string = this.m_aMessageIDFactory.get();
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("The contained MessageID factory created an empty MessageID!");
        }
        return string;
    }

    @Nullable
    public final String getRefToMessageID() {
        return this.m_sRefToMessageID;
    }

    public final boolean hasRefToMessageID() {
        return StringHelper.hasText((String)this.m_sRefToMessageID);
    }

    @Nonnull
    public final IMPLTYPE setRefToMessageID(@Nullable String string) {
        this.m_sRefToMessageID = string;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nullable
    public final OffsetDateTime getSendingDateTime() {
        return this.m_aSendingDateTime;
    }

    @Nonnull
    public final OffsetDateTime getSendingDateTimeOrNow() {
        return this.m_aSendingDateTime != null ? this.m_aSendingDateTime : MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
    }

    @Nonnull
    public final IMPLTYPE setSendingDateTimeOrNow(@Nullable OffsetDateTime offsetDateTime) {
        this.m_aSendingDateTime = offsetDateTime;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    public final ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Nonnull
    public final IMPLTYPE setSoapVersion(@Nonnull ESoapVersion eSoapVersion) {
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        this.m_eSoapVersion = eSoapVersion;
        return (IMPLTYPE)((AbstractAS4Client)this.thisAsT());
    }

    @Nonnull
    public final HttpRetrySettings httpRetrySettings() {
        return this.m_aHttpRetrySettings;
    }

    @Nonnull
    protected IAS4CryptoFactory internalCreateCryptoFactory() {
        if (this.m_aCryptoFactory == null) {
            throw new IllegalStateException("No CryptoFactory is configured.");
        }
        return this.m_aCryptoFactory;
    }

    public final void setValuesFromPMode(@Nullable IPMode iPMode, @Nullable PModeLeg pModeLeg) {
        if (iPMode != null) {
            PModeReceptionAwareness pModeReceptionAwareness = iPMode.getReceptionAwareness();
            if (pModeReceptionAwareness != null && pModeReceptionAwareness.isRetryDefined()) {
                this.m_aHttpRetrySettings.setMaxRetries(pModeReceptionAwareness.getMaxRetries());
                this.m_aHttpRetrySettings.setDurationBeforeRetry(Duration.ofMillis(pModeReceptionAwareness.getRetryIntervalMS()));
            } else {
                this.m_aHttpRetrySettings.setMaxRetries(0);
            }
        }
        if (pModeLeg != null) {
            this.signingParams().setFromPMode(pModeLeg.getSecurity());
            this.cryptParams().setFromPMode(pModeLeg.getSecurity());
        }
    }

    @Nonnull
    public abstract AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String var1, @Nullable IAS4ClientBuildMessageCallback var2) throws IOException, WSSecurityException, MessagingException;

    @Nonnull
    public final <T> AS4ClientSentMessage<T> sendMessageWithRetries(@Nonnull String string, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4RetryCallback iAS4RetryCallback) throws IOException, WSSecurityException, MessagingException {
        String string2 = this.createMessageID();
        AS4ClientBuiltMessage aS4ClientBuiltMessage = this.buildMessage(string2, iAS4ClientBuildMessageCallback);
        HttpEntity httpEntity = aS4ClientBuiltMessage.getHttpEntity();
        HttpHeaderMap httpHeaderMap = aS4ClientBuiltMessage.getCustomHeaders();
        if (this.m_aHttpRetrySettings.isRetryEnabled() || iAS4OutgoingDumper != null || AS4DumpManager.getOutgoingDumper() != null) {
            httpEntity = this.m_aResHelper.createRepeatableHttpEntity(httpEntity);
        }
        Wrapper wrapper = new Wrapper();
        HttpHeaderMap httpHeaderMap2 = new HttpHeaderMap();
        HttpClientResponseHandler httpClientResponseHandler2 = classicHttpResponse -> {
            wrapper.set((Object)new StatusLine((HttpResponse)classicHttpResponse));
            Header[] headerArray = classicHttpResponse.getHeaders();
            if (headerArray != null) {
                for (Header header : headerArray) {
                    httpHeaderMap2.addHeader(header.getName(), header.getValue());
                }
            }
            return httpClientResponseHandler.handleResponse(classicHttpResponse);
        };
        Object t = this.m_aHttpPoster.sendGenericMessageWithRetries(string, httpHeaderMap, httpEntity, string2, this.m_aHttpRetrySettings, httpClientResponseHandler2, iAS4OutgoingDumper, iAS4RetryCallback);
        return new AS4ClientSentMessage(aS4ClientBuiltMessage, (StatusLine)wrapper.get(), httpHeaderMap2, t);
    }
}

