/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmC14N;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.crypto.ECryptoKeyIdentifierType;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AS4SigningParams
implements Serializable,
ICloneable<AS4SigningParams> {
    public static final ECryptoKeyIdentifierType DEFAULT_KEY_IDENTIFIER_TYPE = ECryptoKeyIdentifierType.BST_DIRECT_REFERENCE;
    private ECryptoKeyIdentifierType m_eKeyIdentifierType = DEFAULT_KEY_IDENTIFIER_TYPE;
    private ECryptoAlgorithmSign m_eAlgorithmSign;
    private ECryptoAlgorithmSignDigest m_eAlgorithmSignDigest;
    private ECryptoAlgorithmC14N m_eAlgorithmC14N = ECryptoAlgorithmC14N.C14N_ALGORITHM_DEFAULT;

    public boolean isSigningEnabled() {
        return this.m_eAlgorithmSign != null && this.m_eAlgorithmSignDigest != null;
    }

    @Nonnull
    public final ECryptoKeyIdentifierType getKeyIdentifierType() {
        return this.m_eKeyIdentifierType;
    }

    @Nonnull
    public final AS4SigningParams setKeyIdentifierType(@Nonnull ECryptoKeyIdentifierType eCryptoKeyIdentifierType) {
        ValueEnforcer.notNull((Object)((Object)eCryptoKeyIdentifierType), (String)"KeyIdentifierType");
        this.m_eKeyIdentifierType = eCryptoKeyIdentifierType;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmSign getAlgorithmSign() {
        return this.m_eAlgorithmSign;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmSign(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        this.m_eAlgorithmSign = eCryptoAlgorithmSign;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmSignDigest getAlgorithmSignDigest() {
        return this.m_eAlgorithmSignDigest;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmSignDigest(@Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest) {
        this.m_eAlgorithmSignDigest = eCryptoAlgorithmSignDigest;
        return this;
    }

    @Nonnull
    public final ECryptoAlgorithmC14N getAlgorithmC14N() {
        return this.m_eAlgorithmC14N;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmC14N(@Nonnull ECryptoAlgorithmC14N eCryptoAlgorithmC14N) {
        ValueEnforcer.notNull((Object)((Object)eCryptoAlgorithmC14N), (String)"AlgorithmC14N");
        this.m_eAlgorithmC14N = eCryptoAlgorithmC14N;
        return this;
    }

    @Nonnull
    public final AS4SigningParams setFromPMode(@Nullable PModeLegSecurity pModeLegSecurity) {
        if (pModeLegSecurity == null) {
            this.setAlgorithmSign(null);
            this.setAlgorithmSignDigest(null);
        } else {
            this.setAlgorithmSign(pModeLegSecurity.getX509SignatureAlgorithm());
            this.setAlgorithmSignDigest(pModeLegSecurity.getX509SignatureHashFunction());
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public AS4SigningParams getClone() {
        return new AS4SigningParams().setKeyIdentifierType(this.m_eKeyIdentifierType).setAlgorithmSign(this.m_eAlgorithmSign).setAlgorithmSignDigest(this.m_eAlgorithmSignDigest).setAlgorithmC14N(this.m_eAlgorithmC14N);
    }

    public String toString() {
        return new ToStringGenerator(null).append("KeyIdentifierType", (Enum)this.m_eKeyIdentifierType).append("AlgorithmSign", (Enum)this.m_eAlgorithmSign).append("AlgorithmSignDigest", (Enum)this.m_eAlgorithmSignDigest).append("AlgorithmC14N", (Enum)this.m_eAlgorithmC14N).getToString();
    }

    @Nonnull
    @ReturnsMutableObject
    public static AS4SigningParams createDefault() {
        return new AS4SigningParams().setAlgorithmSign(ECryptoAlgorithmSign.SIGN_ALGORITHM_DEFAULT).setAlgorithmSignDigest(ECryptoAlgorithmSignDigest.SIGN_DIGEST_ALGORITHM_DEFAULT).setAlgorithmC14N(ECryptoAlgorithmC14N.C14N_ALGORITHM_DEFAULT);
    }
}

