/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.resolve.DefaultPModeResolver;
import com.helger.phase4.servlet.AS4IncomingMessageMetadata;
import com.helger.phase4.servlet.AS4RequestHandler;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.IAS4ResponseAbstraction;
import com.helger.phase4.servlet.spi.AS4MessageProcessorResult;
import com.helger.phase4.servlet.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.servlet.spi.IAS4ServletMessageProcessorSPI;
import com.helger.phase4.util.Phase4Exception;
import com.helger.servlet.mock.MockServletContext;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.mgr.WebScoped;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public final class AS4DumpReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4DumpReader.class);

    private AS4DumpReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptAS4In(@Nonnull byte[] byArray, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nullable Consumer<HttpHeaderMap> consumer, final @Nonnull IDecryptedPayloadConsumer iDecryptedPayloadConsumer) throws WSSecurityException, Phase4Exception, IOException, MessagingException {
        Object object;
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by == 10) {
                if (bl) {
                    n2 = i;
                    break;
                }
                bl = true;
                object = new String(byArray, n, i - n, StandardCharsets.ISO_8859_1);
                String[] stringArray = StringHelper.getExplodedArray((char)':', (String)object, (int)2);
                httpHeaderMap.addHeader(stringArray[0].trim(), stringArray[1].trim());
                n = i + 1;
                continue;
            }
            if (by == 13) continue;
            bl = false;
        }
        if (consumer != null) {
            consumer.accept(httpHeaderMap);
        }
        LOGGER.info("Now at byte " + n2 + " having " + httpHeaderMap.getCount() + " HTTP headers");
        WebScopeManager.onGlobalBegin((ServletContext)MockServletContext.create());
        try (WebScoped webScoped = new WebScoped();
             AS4RequestHandler aS4RequestHandler = new AS4RequestHandler(iAS4CryptoFactory, DefaultPModeResolver.DEFAULT_PMODE_RESOLVER, IAS4IncomingAttachmentFactory.DEFAULT_INSTANCE, AS4IncomingMessageMetadata.createForRequest());){
            object = new IAS4ServletMessageProcessorSPI(){

                @Override
                public AS4MessageProcessorResult processAS4UserMessage(IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, HttpHeaderMap httpHeaderMap, Ebms3UserMessage ebms3UserMessage, IPMode iPMode, Node node, ICommonsList<WSS4JAttachment> iCommonsList, IAS4MessageState iAS4MessageState, ICommonsList<Ebms3Error> iCommonsList2) {
                    try {
                        int n = 0;
                        for (WSS4JAttachment wSS4JAttachment : iCommonsList) {
                            byte[] byArray = StreamHelper.getAllBytes((IHasInputStream)wSS4JAttachment.getInputStreamProvider());
                            iDecryptedPayloadConsumer.accept(n, byArray);
                            LOGGER.info("Handled decrypted payload #" + n + " with " + byArray.length + " bytes");
                            ++n;
                        }
                        return AS4MessageProcessorResult.createSuccess();
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }

                @Override
                public AS4SignalMessageProcessorResult processAS4SignalMessage(IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, HttpHeaderMap httpHeaderMap, Ebms3SignalMessage ebms3SignalMessage, IPMode iPMode, IAS4MessageState iAS4MessageState, ICommonsList<Ebms3Error> iCommonsList) {
                    LOGGER.error("Unexpected signal msg. Can only handle user messages.");
                    return AS4SignalMessageProcessorResult.createSuccess();
                }
            };
            aS4RequestHandler.setProcessorSupplier(() -> AS4DumpReader.lambda$decryptAS4In$0((IAS4ServletMessageProcessorSPI)object));
            aS4RequestHandler.handleRequest((InputStream)new NonBlockingByteArrayInputStream(byArray, n2, byArray.length - n2), httpHeaderMap, new IAS4ResponseAbstraction(){

                @Override
                public void setStatus(int n) {
                }

                @Override
                public void setMimeType(IMimeType iMimeType) {
                }

                @Override
                public void setContent(HttpHeaderMap httpHeaderMap, IHasInputStream iHasInputStream) {
                }

                @Override
                public void setContent(byte[] byArray, Charset charset) {
                }
            });
        }
        finally {
            WebScopeManager.onGlobalEnd();
        }
    }

    private static /* synthetic */ ICommonsList lambda$decryptAS4In$0(IAS4ServletMessageProcessorSPI iAS4ServletMessageProcessorSPI) {
        return new CommonsArrayList((Object)iAS4ServletMessageProcessorSPI);
    }

    @FunctionalInterface
    public static interface IDecryptedPayloadConsumer {
        public void accept(@Nonnegative int var1, @Nonnull byte[] var2);
    }
}

