/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.duplicate;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.dao.DAOException;
import com.helger.phase4.duplicate.AS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AS4DuplicateManager
extends AbstractPhotonMapBasedWALDAO<IAS4DuplicateItem, AS4DuplicateItem>
implements IAS4DuplicateManager {
    public AS4DuplicateManager(@Nullable String string) throws DAOException {
        super(AS4DuplicateItem.class, string);
    }

    @Override
    @Nonnull
    public EContinue registerAndCheck(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        if (StringHelper.hasNoText((String)string)) {
            return EContinue.CONTINUE;
        }
        AS4DuplicateItem aS4DuplicateItem = new AS4DuplicateItem(string, string2, string3);
        try {
            this.m_aRWLock.writeLocked(() -> this.internalCreateItem(aS4DuplicateItem));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange clearCache() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.internalRemoveAllItemsNoCallback());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> evictAllItemsBefore(@Nonnull OffsetDateTime offsetDateTime) {
        ICommonsList iCommonsList = this.getAllMapped(iAS4DuplicateItem -> iAS4DuplicateItem.getDateTime().isBefore(offsetDateTime), IAS4DuplicateItem::getMessageID);
        if (iCommonsList.isNotEmpty()) {
            this.m_aRWLock.writeLocked(() -> {
                for (String string : iCommonsList) {
                    this.internalDeleteItem(string);
                }
            });
        }
        return iCommonsList;
    }

    @Override
    @Nullable
    public IAS4DuplicateItem getItemOfMessageID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IAS4DuplicateItem)this.findFirst(iAS4DuplicateItem -> iAS4DuplicateItem.getMessageID().equals(string));
    }
}

