/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.ThreadHelper;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.wrapper.Wrapper;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.http.HttpRetrySettings;
import com.helger.phase4.http.IHttpPoster;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.util.MultiOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpPoster
implements IHttpPoster {
    public static final boolean DEFAULT_QUOTE_HTTP_HEADERS = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHttpPoster.class);
    private HttpClientFactory m_aHttpClientFactory = BasicHttpPoster.createDefaultHttpClientFactory();
    private Consumer<? super HttpPost> m_aHttpCustomizer;
    private boolean m_bQuoteHttpHeaders = false;

    @Nonnull
    public static HttpClientFactory createDefaultHttpClientFactory() {
        return new HttpClientFactory();
    }

    @Override
    @Nonnull
    public final HttpClientFactory getHttpClientFactory() {
        return this.m_aHttpClientFactory;
    }

    @Override
    @Nonnull
    public final BasicHttpPoster setHttpClientFactory(@Nonnull HttpClientFactory httpClientFactory) {
        ValueEnforcer.notNull((Object)httpClientFactory, (String)"HttpClientFactory");
        this.m_aHttpClientFactory = httpClientFactory;
        return this;
    }

    @Override
    @Nullable
    public final Consumer<? super HttpPost> getHttpCustomizer() {
        return this.m_aHttpCustomizer;
    }

    @Override
    @Nonnull
    public final BasicHttpPoster setHttpCustomizer(@Nullable Consumer<? super HttpPost> consumer) {
        this.m_aHttpCustomizer = consumer;
        return this;
    }

    @Override
    public final boolean isQuoteHttpHeaders() {
        return this.m_bQuoteHttpHeaders;
    }

    @Override
    @Nonnull
    public final BasicHttpPoster setQuoteHttpHeaders(boolean bl) {
        this.m_bQuoteHttpHeaders = bl;
        return this;
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    public <T> T sendGenericMessage(@Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnull HttpEntity httpEntity, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URL");
        ValueEnforcer.notNull((Object)httpEntity, (String)"HttpEntity");
        StopWatch stopWatch = StopWatch.createdStarted();
        LOGGER.info("Starting to transmit AS4 Message to '" + string + "'");
        IOException iOException = null;
        HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)this.m_aHttpClientFactory);
        HttpPost httpPost = new HttpPost(string);
        if (httpHeaderMap != null) {
            httpHeaderMap.forEachSingleHeader((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1), true, this.m_bQuoteHttpHeaders);
        }
        httpPost.setEntity(httpEntity);
        if (this.m_aHttpCustomizer != null) {
            this.m_aHttpCustomizer.accept((HttpPost)httpPost);
        }
        AS4HttpDebug.debug(() -> {
            StringBuilder stringBuilder = new StringBuilder("SEND-START to ").append(string).append("\n");
            try {
                for (Header header : httpPost.getHeaders()) {
                    stringBuilder.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
                }
                stringBuilder.append("\r\n");
                if (httpEntity.isRepeatable()) {
                    stringBuilder.append(EntityUtils.toString((HttpEntity)httpEntity));
                } else {
                    stringBuilder.append("## The payload is marked as 'not repeatable' and is the therefore not printed in debugging");
                }
            }
            catch (Exception exception) {
                stringBuilder.append("## Exception listing payload: " + exception.getClass().getName() + " -- " + exception.getMessage()).append("\r\n");
                stringBuilder.append("## ").append(StackTraceHelper.getStackAsString((Throwable)exception));
            }
            return stringBuilder.toString();
        });
        Object object = httpClientManager.execute((HttpUriRequest)httpPost, httpClientResponseHandler);
        httpClientManager.close();
        stopWatch.stop();
        LOGGER.info((iOException != null ? "Failed" : "Finished") + " transmitting AS4 Message to '" + string + "' after " + stopWatch.getMillis() + " ms");
        return (T)object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            httpClientManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                        throw iOException2;
                    }
                }
                catch (Throwable throwable3) {
                    stopWatch.stop();
                    LOGGER.info((iOException != null ? "Failed" : "Finished") + " transmitting AS4 Message to '" + string + "' after " + stopWatch.getMillis() + " ms");
                    throw throwable3;
                }
            }
        }
    }

    @Nonnull
    protected static HttpEntity createDumpingHttpEntity(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nonnull HttpEntity httpEntity, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n, @Nonnull Wrapper<OutputStream> wrapper) throws IOException {
        if (iAS4OutgoingDumper == null) {
            return httpEntity;
        }
        final OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(EAS4MessageMode.REQUEST, null, null, string, httpHeaderMap, n);
        if (outputStream == null) {
            return httpEntity;
        }
        if (!httpEntity.isRepeatable()) {
            throw new IllegalStateException("If dumping of outgoing messages is enabled, a repeatable entity must be provided");
        }
        wrapper.set((Object)outputStream);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating dumping entity for the current request");
        }
        return new HttpEntityWrapper(httpEntity){

            public void writeTo(@Nonnull @WillNotClose OutputStream outputStream2) throws IOException {
                MultiOutputStream multiOutputStream = new MultiOutputStream(outputStream2, outputStream);
                super.writeTo((OutputStream)multiOutputStream);
                multiOutputStream.flush();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public <T> T sendGenericMessageWithRetries(@Nonnull String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnull HttpEntity httpEntity, @Nonnull String string2, @Nonnull HttpRetrySettings httpRetrySettings, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4RetryCallback iAS4RetryCallback) throws IOException {
        T t;
        IAS4OutgoingDumper iAS4OutgoingDumper2 = iAS4OutgoingDumper != null ? iAS4OutgoingDumper : AS4DumpManager.getOutgoingDumper();
        Wrapper wrapper = new Wrapper();
        if (httpRetrySettings.isRetryEnabled()) {
            if (!httpEntity.isRepeatable()) {
                throw new IllegalStateException("If retry is enabled, a repeatable entity must be provided");
            }
            int n = httpRetrySettings.getMaxRetries();
            int n2 = 1 + n;
            Duration duration = httpRetrySettings.getDurationBeforeRetry();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    LOGGER.info("Retry #" + n3 + "/" + n + " for sending message with ID '" + string2 + "'");
                }
                try {
                    HttpEntity httpEntity2 = BasicHttpPoster.createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string2, httpHeaderMap, n3, (Wrapper<OutputStream>)wrapper);
                    T t2 = this.sendGenericMessage(string, httpHeaderMap, httpEntity2, httpClientResponseHandler);
                    return t2;
                }
                catch (IOException iOException) {
                    if (n3 == n2 - 1) {
                        throw iOException;
                    }
                    if (n3 > 1) {
                        duration = HttpRetrySettings.getIncreased(duration, httpRetrySettings.getRetryIncreaseFactor());
                    }
                    if (iAS4RetryCallback != null && iAS4RetryCallback.onBeforeRetry(string2, string, n3, n2, duration.toMillis(), iOException).isBreak()) {
                        LOGGER.warn("Error sending message '" + string2 + "' to '" + string + ": " + iOException.getClass().getSimpleName() + " - " + iOException.getMessage() + " - retrying was explicitly stopped by the RetryCallback");
                        throw iOException;
                    }
                    LOGGER.warn("Error sending message '" + string2 + "' to '" + string + "': " + iOException.getClass().getSimpleName() + " - " + iOException.getMessage() + " - waiting " + duration.toMillis() + " ms, than retrying");
                    ThreadHelper.sleep((long)duration.toMillis());
                    ++n3;
                }
            }
            throw new IllegalStateException("Should never be reached (after maximum of " + n2 + " tries)!");
            finally {
                StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
            }
        }
        HttpEntity httpEntity3 = BasicHttpPoster.createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string2, httpHeaderMap, 0, (Wrapper<OutputStream>)wrapper);
        try {
            t = this.sendGenericMessage(string, httpHeaderMap, httpEntity3, httpClientResponseHandler);
        }
        catch (Throwable throwable) {
            StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
            throw throwable;
        }
        StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
        return t;
        finally {
            if (iAS4OutgoingDumper2 != null && wrapper.isSet()) {
                try {
                    iAS4OutgoingDumper2.onEndRequest(EAS4MessageMode.REQUEST, null, null, string2);
                }
                catch (Exception exception) {
                    LOGGER.error("OutgoingDumper.onEndRequest failed. Dumper=" + iAS4OutgoingDumper2 + "; MessageID=" + string2, (Throwable)exception);
                }
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HttpClientFactory", (Object)this.m_aHttpClientFactory).append("HttpCustomizer", this.m_aHttpCustomizer).append("QuoteHttpHeaders", this.m_bQuoteHttpHeaders).getToString();
    }
}

