/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IAddableByTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.Cookie;

@Immutable
public final class AS4MessagingHelper {
    private AS4MessagingHelper() {
    }

    @Nonnull
    @Nonempty
    public static IJsonObject getIncomingMetadataAsJson(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("IncomingUniqueID", (Object)iAS4IncomingMessageMetadata.getIncomingUniqueID());
        jsonObject.add("IncomingDT", (Object)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)iAS4IncomingMessageMetadata.getIncomingDT()));
        jsonObject.add("Mode", (Object)iAS4IncomingMessageMetadata.getMode().getID());
        if (iAS4IncomingMessageMetadata.hasRemoteAddr()) {
            jsonObject.add("RemoteAddr", (Object)iAS4IncomingMessageMetadata.getRemoteAddr());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteHost()) {
            jsonObject.add("RemoteHost", (Object)iAS4IncomingMessageMetadata.getRemoteHost());
        }
        if (iAS4IncomingMessageMetadata.hasRemotePort()) {
            jsonObject.add("RemotePort", iAS4IncomingMessageMetadata.getRemotePort());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteUser()) {
            jsonObject.add("RemoteUser", (Object)iAS4IncomingMessageMetadata.getRemoteUser());
        }
        JsonArray jsonArray = new JsonArray();
        for (Cookie cookie : iAS4IncomingMessageMetadata.cookies()) {
            JsonObject jsonObject2 = new JsonObject();
            if (StringHelper.hasText((String)cookie.getDomain())) {
                jsonObject2.add("Domain", (Object)cookie.getDomain());
            }
            if (StringHelper.hasText((String)cookie.getPath())) {
                jsonObject2.add("Path", (Object)cookie.getPath());
            }
            jsonObject2.add("Secure", cookie.getSecure());
            jsonObject2.add("HttpOnly", cookie.isHttpOnly());
            jsonObject2.add("Name", (Object)cookie.getName());
            jsonObject2.add("Value", (Object)cookie.getValue());
            jsonObject2.add("Version", cookie.getVersion());
            jsonObject2.add("MaxAge", cookie.getMaxAge());
            if (StringHelper.hasText((String)cookie.getComment())) {
                jsonObject2.add("Comment", (Object)cookie.getComment());
            }
            jsonArray.add((IAddableByTrait)jsonObject2);
        }
        if (jsonArray.isNotEmpty()) {
            jsonObject.addJson("Cookies", (IJson)jsonArray);
        }
        return jsonObject;
    }
}

