/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.messaging.domain.AbstractAS4Message;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.soap.ESoapVersion;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4PullRequestMessage
extends AbstractAS4Message<AS4PullRequestMessage> {
    private final Ebms3SignalMessage m_aSignalMessage;

    public AS4PullRequestMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3SignalMessage ebms3SignalMessage) {
        super(eSoapVersion, EAS4MessageType.PULL_REQUEST);
        ValueEnforcer.notNull((Object)ebms3SignalMessage, (String)"SignalMessage");
        this.m_aMessaging.addSignalMessage(ebms3SignalMessage);
        this.m_aSignalMessage = ebms3SignalMessage;
    }

    @Nonnull
    public final Ebms3SignalMessage getEbms3SignalMessage() {
        return this.m_aSignalMessage;
    }

    @Nonnull
    public static AS4PullRequestMessage create(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3MessageInfo ebms3MessageInfo, @Nullable String string, @Nullable List<Object> list) {
        Ebms3SignalMessage ebms3SignalMessage = new Ebms3SignalMessage();
        ebms3SignalMessage.setMessageInfo(ebms3MessageInfo);
        if (StringHelper.hasText((String)string)) {
            Ebms3PullRequest ebms3PullRequest = new Ebms3PullRequest();
            ebms3PullRequest.setMpc(string);
            ebms3SignalMessage.setPullRequest(ebms3PullRequest);
        }
        ebms3SignalMessage.setAny(list);
        return new AS4PullRequestMessage(eSoapVersion, ebms3SignalMessage);
    }
}

