/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.marshaller.Ebms3WriterBuilder;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.IAS4Message;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.soap11.Soap11Body;
import com.helger.phase4.soap11.Soap11Envelope;
import com.helger.phase4.soap11.Soap11Header;
import com.helger.phase4.soap12.Soap12Body;
import com.helger.phase4.soap12.Soap12Envelope;
import com.helger.phase4.soap12.Soap12Header;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractAS4Message<IMPLTYPE extends AbstractAS4Message<IMPLTYPE>>
implements IAS4Message,
IGenericImplTrait<IMPLTYPE> {
    private final ESoapVersion m_eSoapVersion;
    private final EAS4MessageType m_eMsgType;
    private final String m_sMessagingID;
    protected final Ebms3Messaging m_aMessaging = new Ebms3Messaging();

    public AbstractAS4Message(@Nonnull ESoapVersion eSoapVersion, @Nonnull EAS4MessageType eAS4MessageType) {
        this.m_eSoapVersion = (ESoapVersion)((Object)ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion"));
        this.m_eMsgType = (EAS4MessageType)((Object)ValueEnforcer.notNull((Object)((Object)eAS4MessageType), (String)"MessageType"));
        this.m_sMessagingID = MessageHelperMethods.createRandomMessagingID();
        this.m_aMessaging.getOtherAttributes().put(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"), this.m_sMessagingID);
    }

    @Override
    @Nonnull
    public final ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Override
    @Nonnull
    public final EAS4MessageType getMessageType() {
        return this.m_eMsgType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getMessagingID() {
        return this.m_sMessagingID;
    }

    @Nonnull
    public final IMPLTYPE setMustUnderstand(boolean bl) {
        switch (this.m_eSoapVersion) {
            case SOAP_11: {
                this.m_aMessaging.setS11MustUnderstand(bl);
                break;
            }
            case SOAP_12: {
                this.m_aMessaging.setS12MustUnderstand(bl);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SOAP version " + (Object)((Object)this.m_eSoapVersion));
            }
        }
        return (IMPLTYPE)((AbstractAS4Message)this.thisAsT());
    }

    @Override
    @Nonnull
    public final Document getAsSoapDocument(@Nullable Node node) {
        Document document = Ebms3WriterBuilder.ebms3Messaging().getAsDocument(this.m_aMessaging);
        if (document == null) {
            throw new IllegalStateException("Failed to write EBMS3 Messaging to XML");
        }
        Node node2 = node instanceof Document ? ((Document)node).getDocumentElement() : node;
        switch (this.m_eSoapVersion) {
            case SOAP_11: {
                Soap11Envelope soap11Envelope = new Soap11Envelope();
                soap11Envelope.setHeader(new Soap11Header());
                soap11Envelope.setBody(new Soap11Body());
                soap11Envelope.getHeader().addAny(document.getDocumentElement());
                if (node2 != null) {
                    soap11Envelope.getBody().addAny(node2);
                }
                return Ebms3WriterBuilder.soap11().getAsDocument(soap11Envelope);
            }
            case SOAP_12: {
                Soap12Envelope soap12Envelope = new Soap12Envelope();
                soap12Envelope.setHeader(new Soap12Header());
                soap12Envelope.setBody(new Soap12Body());
                soap12Envelope.getHeader().addAny(document.getDocumentElement());
                if (node2 != null) {
                    soap12Envelope.getBody().addAny(node2);
                }
                return Ebms3WriterBuilder.soap12().getAsDocument(soap12Envelope);
            }
        }
        throw new IllegalStateException("Unsupported SOAP version " + (Object)((Object)this.m_eSoapVersion));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SOAPVersion", (Enum)this.m_eSoapVersion).append("MsgType", (Enum)this.m_eMsgType).append("MessagingID", (Object)this.m_sMessagingID).getToString();
    }
}

