/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.mgr;

import com.helger.dao.DAOException;
import com.helger.phase4.duplicate.AS4DuplicateManager;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.phase4.mgr.IAS4TimestampManager;
import com.helger.phase4.mgr.IManagerFactory;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.mpc.MPCManager;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.PModeManager;
import com.helger.phase4.profile.AS4ProfileManager;
import com.helger.phase4.profile.IAS4ProfileManager;
import com.helger.phase4.util.Phase4Exception;
import javax.annotation.Nonnull;

public class ManagerFactoryPersistingFileSystem
implements IManagerFactory {
    private static final String MPC_XML = "as4-mpc.xml";
    private static final String PMODE_XML = "as4-pmode.xml";
    private static final String INCOMING_DUPLICATE_XML = "as4-duplicate-incoming.xml";

    @Override
    @Nonnull
    public IMPCManager createMPCManager() throws Phase4Exception {
        try {
            return new MPCManager(MPC_XML);
        }
        catch (DAOException dAOException) {
            throw new Phase4Exception("Error creating MPCManager", dAOException);
        }
    }

    @Override
    @Nonnull
    public IPModeManager createPModeManager() throws Phase4Exception {
        try {
            return new PModeManager(PMODE_XML);
        }
        catch (DAOException dAOException) {
            throw new Phase4Exception("Error creating PModeManager", dAOException);
        }
    }

    @Override
    @Nonnull
    public IAS4DuplicateManager createDuplicateManager() throws Phase4Exception {
        try {
            return new AS4DuplicateManager(INCOMING_DUPLICATE_XML);
        }
        catch (DAOException dAOException) {
            throw new Phase4Exception("Error creating AS4DuplicateManager", dAOException);
        }
    }

    @Override
    @Nonnull
    public IAS4ProfileManager createProfileManager() {
        return new AS4ProfileManager();
    }

    @Override
    @Nonnull
    public IAS4TimestampManager createTimestampManager() {
        return IAS4TimestampManager.createDefaultInstance();
    }
}

