/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.traits.IAddableByTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModePartyJsonConverter;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModePayloadServiceJsonConverter;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.PModeReceptionAwarenessJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegJsonConverter;
import com.helger.photon.security.object.StubObject;
import com.helger.tenancy.IBusinessObject;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeJsonConverter {
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATIONLDT = "creationldt";
    private static final String ATTR_CREATIONUSERID = "creationuserid";
    private static final String ATTR_LASTMODLDT = "lastmodldt";
    private static final String ATTR_LASTMODUSERID = "lastmoduserid";
    private static final String ATTR_DELETIONLDT = "deletionldt";
    private static final String ATTR_DELETIONUSERID = "deletionuserid";
    private static final String ELEMENT_CUSTOM = "custom";
    private static final String VALUE = "value";
    private static final String ELEMENT_INITIATOR = "Initiator";
    private static final String ELEMENT_RESPONDER = "Responder";
    private static final String ATTR_AGREEMENT = "Agreement";
    private static final String ATTR_MEP = "MEP";
    private static final String ATTR_MEP_BINDING = "MEPBinding";
    private static final String ELEMENT_LEG1 = "Leg1";
    private static final String ELEMENT_LEG2 = "Leg2";
    private static final String ELEMENT_PAYLOADSERVICE = "PayloadServices";
    private static final String ELEMENT_RECEPETIONAWARENESS = "RecepetionAwareness";

    private PModeJsonConverter() {
    }

    public static void setObjectFields(@Nonnull IBusinessObject iBusinessObject, @Nonnull IJsonObject iJsonObject) {
        iJsonObject.add(ATTR_ID, iBusinessObject.getID());
        if (iBusinessObject.hasCreationDateTime()) {
            iJsonObject.add(ATTR_CREATIONLDT, (Object)PDTWebDateHelper.getAsStringXSD((LocalDateTime)iBusinessObject.getCreationDateTime()));
        }
        if (iBusinessObject.hasCreationUserID()) {
            iJsonObject.add(ATTR_CREATIONUSERID, (Object)iBusinessObject.getCreationUserID());
        }
        if (iBusinessObject.hasLastModificationDateTime()) {
            iJsonObject.add(ATTR_LASTMODLDT, (Object)PDTWebDateHelper.getAsStringXSD((LocalDateTime)iBusinessObject.getLastModificationDateTime()));
        }
        if (iBusinessObject.hasLastModificationUserID()) {
            iJsonObject.add(ATTR_LASTMODUSERID, (Object)iBusinessObject.getLastModificationUserID());
        }
        if (iBusinessObject.hasDeletionDateTime()) {
            iJsonObject.add(ATTR_DELETIONLDT, (Object)PDTWebDateHelper.getAsStringXSD((LocalDateTime)iBusinessObject.getDeletionDateTime()));
        }
        if (iBusinessObject.hasDeletionUserID()) {
            iJsonObject.add(ATTR_DELETIONUSERID, (Object)iBusinessObject.getDeletionUserID());
        }
        if (iBusinessObject.attrs().isNotEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (Map.Entry entry : CollectionHelper.getSortedByKey((Map)iBusinessObject.attrs()).entrySet()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add(ATTR_ID, entry.getKey());
                if (entry.getValue() != null) {
                    jsonObject.add(VALUE, entry.getValue());
                }
                jsonArray.add((IAddableByTrait)jsonObject);
            }
            iJsonObject.addJson(ELEMENT_CUSTOM, (IJson)jsonArray);
        }
    }

    @Nonnull
    public static StubObject getStubObject(@Nonnull IJsonObject iJsonObject) {
        String string = iJsonObject.getAsString((Object)ATTR_ID);
        LocalDateTime localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD((String)iJsonObject.getAsString((Object)ATTR_CREATIONLDT));
        String string2 = iJsonObject.getAsString((Object)ATTR_CREATIONUSERID);
        LocalDateTime localDateTime2 = PDTWebDateHelper.getLocalDateTimeFromXSD((String)iJsonObject.getAsString((Object)ATTR_LASTMODLDT));
        String string3 = iJsonObject.getAsString((Object)ATTR_LASTMODUSERID);
        LocalDateTime localDateTime3 = PDTWebDateHelper.getLocalDateTimeFromXSD((String)iJsonObject.getAsString((Object)ATTR_DELETIONLDT));
        String string4 = iJsonObject.getAsString((Object)ATTR_DELETIONUSERID);
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        IJsonArray iJsonArray = iJsonObject.getAsArray(ELEMENT_CUSTOM);
        if (iJsonArray != null) {
            for (IJsonObject iJsonObject2 : iJsonArray.iteratorObjects()) {
                commonsLinkedHashMap.put((Object)iJsonObject2.getAsString((Object)ATTR_ID), (Object)iJsonObject2.getAsString((Object)VALUE));
            }
        }
        return new StubObject(string, localDateTime, string2, localDateTime2, string3, localDateTime3, string4, (Map)commonsLinkedHashMap);
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull IPMode iPMode) {
        JsonObject jsonObject = new JsonObject();
        PModeJsonConverter.setObjectFields(iPMode, (IJsonObject)jsonObject);
        if (iPMode.hasInitiator()) {
            jsonObject.addJson(ELEMENT_INITIATOR, (IJson)PModePartyJsonConverter.convertToJson(iPMode.getInitiator()));
        }
        if (iPMode.hasResponder()) {
            jsonObject.addJson(ELEMENT_RESPONDER, (IJson)PModePartyJsonConverter.convertToJson(iPMode.getResponder()));
        }
        if (iPMode.hasAgreement()) {
            jsonObject.add(ATTR_AGREEMENT, (Object)iPMode.getAgreement());
        }
        jsonObject.add(ATTR_MEP, (Object)iPMode.getMEPID());
        jsonObject.add(ATTR_MEP_BINDING, (Object)iPMode.getMEPBindingID());
        if (iPMode.hasLeg1()) {
            jsonObject.addJson(ELEMENT_LEG1, (IJson)PModeLegJsonConverter.convertToJson(iPMode.getLeg1()));
        }
        if (iPMode.hasLeg2()) {
            jsonObject.addJson(ELEMENT_LEG2, (IJson)PModeLegJsonConverter.convertToJson(iPMode.getLeg2()));
        }
        if (iPMode.hasPayloadService()) {
            jsonObject.addJson(ELEMENT_PAYLOADSERVICE, (IJson)PModePayloadServiceJsonConverter.convertToJson(iPMode.getPayloadService()));
        }
        if (iPMode.hasReceptionAwareness()) {
            jsonObject.addJson(ELEMENT_RECEPETIONAWARENESS, (IJson)PModeReceptionAwarenessJsonConverter.convertToJson(iPMode.getReceptionAwareness()));
        }
        return jsonObject;
    }

    @Nonnull
    public static PMode convertToNative(@Nonnull IJsonObject iJsonObject) {
        IJsonObject iJsonObject2 = iJsonObject.getAsObject(ELEMENT_INITIATOR);
        PModeParty pModeParty = iJsonObject2 == null ? null : PModePartyJsonConverter.convertToNative(iJsonObject2);
        IJsonObject iJsonObject3 = iJsonObject.getAsObject(ELEMENT_RESPONDER);
        PModeParty pModeParty2 = iJsonObject3 == null ? null : PModePartyJsonConverter.convertToNative(iJsonObject3);
        String string = iJsonObject.getAsString((Object)ATTR_AGREEMENT);
        String string2 = iJsonObject.getAsString((Object)ATTR_MEP);
        EMEP eMEP = EMEP.getFromIDOrNull(string2);
        if (eMEP == null) {
            throw new IllegalStateException("Failed to resolve MEP '" + string2 + "'");
        }
        String string3 = iJsonObject.getAsString((Object)ATTR_MEP_BINDING);
        EMEPBinding eMEPBinding = EMEPBinding.getFromIDOrNull(string3);
        if (eMEPBinding == null) {
            throw new IllegalStateException("Failed to resolve MEPBinding '" + string3 + "'");
        }
        IJsonObject iJsonObject4 = iJsonObject.getAsObject(ELEMENT_LEG1);
        PModeLeg pModeLeg = iJsonObject4 == null ? null : PModeLegJsonConverter.convertToNative(iJsonObject4);
        IJsonObject iJsonObject5 = iJsonObject.getAsObject(ELEMENT_LEG2);
        PModeLeg pModeLeg2 = iJsonObject5 == null ? null : PModeLegJsonConverter.convertToNative(iJsonObject5);
        IJsonObject iJsonObject6 = iJsonObject.getAsObject(ELEMENT_PAYLOADSERVICE);
        PModePayloadService pModePayloadService = iJsonObject6 == null ? null : PModePayloadServiceJsonConverter.convertToNative(iJsonObject6);
        IJsonObject iJsonObject7 = iJsonObject.getAsObject(ELEMENT_RECEPETIONAWARENESS);
        PModeReceptionAwareness pModeReceptionAwareness = iJsonObject7 == null ? null : PModeReceptionAwarenessJsonConverter.convertToNative(iJsonObject7);
        return new PMode(PModeJsonConverter.getStubObject(iJsonObject), pModeParty, pModeParty2, string, eMEP, eMEPBinding, pModeLeg, pModeLeg2, pModePayloadService, pModeReceptionAwareness);
    }
}

