/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeParty
implements IHasID<String>,
Serializable {
    private String m_sIDType;
    private String m_sIDValue;
    private String m_sRole;
    private String m_sUserName;
    private String m_sPassword;

    public PModeParty(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4, @Nullable String string5) {
        this.setIDType(string);
        this.setIDValue(string2);
        this.setRole(string3);
        this.setUserName(string4);
        this.setPassword(string5);
    }

    @Nullable
    public final String getIDType() {
        return this.m_sIDType;
    }

    public final boolean hasIDType() {
        return StringHelper.hasText((String)this.m_sIDType);
    }

    @Nonnull
    public final EChange setIDType(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sIDType)) {
            return EChange.UNCHANGED;
        }
        this.m_sIDType = string;
        return EChange.CHANGED;
    }

    @Nonnull
    @Nonempty
    public final String getIDValue() {
        return this.m_sIDValue;
    }

    @Nonnull
    public final EChange setIDValue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"IDValue");
        if (string.equals(this.m_sIDValue)) {
            return EChange.UNCHANGED;
        }
        this.m_sIDValue = string;
        return EChange.CHANGED;
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        if (StringHelper.hasText((String)this.m_sIDType)) {
            return this.m_sIDType + ':' + this.m_sIDValue;
        }
        return this.m_sIDValue;
    }

    @Nonnull
    @Nonempty
    public final String getRole() {
        return this.m_sRole;
    }

    @Nonnull
    public final EChange setRole(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Role");
        if (string.equals(this.m_sRole)) {
            return EChange.UNCHANGED;
        }
        this.m_sRole = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getUserName() {
        return this.m_sUserName;
    }

    public final boolean hasUserName() {
        return StringHelper.hasText((String)this.m_sUserName);
    }

    @Nonnull
    public final EChange setUserName(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sUserName)) {
            return EChange.UNCHANGED;
        }
        this.m_sUserName = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getPassword() {
        return this.m_sPassword;
    }

    public final boolean hasPassword() {
        return StringHelper.hasText((String)this.m_sPassword);
    }

    @Nonnull
    public final EChange setPassword(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sPassword)) {
            return EChange.UNCHANGED;
        }
        this.m_sPassword = string;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeParty pModeParty = (PModeParty)object;
        return EqualsHelper.equals((Object)this.m_sIDType, (Object)pModeParty.m_sIDType) && this.m_sIDValue.equals(pModeParty.m_sIDValue) && this.m_sRole.equals(pModeParty.m_sRole) && EqualsHelper.equals((Object)this.m_sUserName, (Object)pModeParty.m_sUserName) && EqualsHelper.equals((Object)this.m_sPassword, (Object)pModeParty.m_sPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sIDType).append((Object)this.m_sIDValue).append((Object)this.m_sRole).append((Object)this.m_sUserName).append((Object)this.m_sPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("IDType", (Object)this.m_sIDType).append("IDValue", (Object)this.m_sIDValue).append("Role", (Object)this.m_sRole).append("UserName", (Object)this.m_sUserName).appendPassword("Password").getToString();
    }

    @Nonnull
    public static PModeParty createSimple(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return new PModeParty(null, string, string2, null, null);
    }
}

