/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.state.ETriState;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PModeReceptionAwarenessJsonConverter {
    private static final String RECEPTION_AWARENESS = "ReceptionAwareness";
    private static final String RETRY = "Retry";
    private static final String MAX_RETRIES = "MaxRetries";
    private static final String RETRY_INTERVAL_MS = "RetryIntervalMS";
    private static final String DUPLICATE_DETECTION = "DuplicateDetection";

    private PModeReceptionAwarenessJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeReceptionAwareness pModeReceptionAwareness) {
        JsonObject jsonObject = new JsonObject();
        if (pModeReceptionAwareness.isReceptionAwarenessDefined()) {
            jsonObject.add(RECEPTION_AWARENESS, pModeReceptionAwareness.isReceptionAwareness());
        }
        if (pModeReceptionAwareness.isRetryDefined()) {
            jsonObject.add(RETRY, pModeReceptionAwareness.isRetry());
        }
        jsonObject.add(MAX_RETRIES, pModeReceptionAwareness.getMaxRetries());
        jsonObject.add(RETRY_INTERVAL_MS, pModeReceptionAwareness.getRetryIntervalMS());
        if (pModeReceptionAwareness.isDuplicateDetectionDefined()) {
            jsonObject.add(DUPLICATE_DETECTION, pModeReceptionAwareness.isDuplicateDetection());
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeReceptionAwareness convertToNative(IJsonObject iJsonObject) {
        ETriState eTriState = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)RECEPTION_AWARENESS), true);
        ETriState eTriState2 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)RETRY), true);
        int n = iJsonObject.getAsInt((Object)MAX_RETRIES, 1);
        long l = iJsonObject.getAsLong((Object)RETRY_INTERVAL_MS, 10000L);
        ETriState eTriState3 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)DUPLICATE_DETECTION), true);
        return new PModeReceptionAwareness(eTriState, eTriState2, n, l, eTriState3);
    }
}

