/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import com.helger.phase4.model.pmode.leg.PModeProperty;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeLegBusinessInformation
implements Serializable {
    private String m_sServiceValue;
    private String m_sServiceType;
    private String m_sAction;
    private final ICommonsOrderedMap<String, PModeProperty> m_aProperties = new CommonsLinkedHashMap();
    private final ICommonsOrderedMap<String, PModePayloadProfile> m_aPayloadProfiles = new CommonsLinkedHashMap();
    private Long m_aPayloadProfileMaxKB;
    private String m_sMPCID;

    public PModeLegBusinessInformation() {
    }

    public PModeLegBusinessInformation(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable ICommonsOrderedMap<String, PModeProperty> iCommonsOrderedMap, @Nullable ICommonsOrderedMap<String, PModePayloadProfile> iCommonsOrderedMap2, @Nullable Long l, @Nullable String string4) {
        this.setService(string);
        this.setServiceType(string2);
        this.setAction(string3);
        if (iCommonsOrderedMap != null) {
            this.properties().putAll(iCommonsOrderedMap);
        }
        if (iCommonsOrderedMap2 != null) {
            this.payloadProfiles().putAll(iCommonsOrderedMap2);
        }
        this.setPayloadProfileMaxKB(l);
        this.setMPCID(string4);
    }

    @Nullable
    public final String getService() {
        return this.m_sServiceValue;
    }

    public final boolean hasService() {
        return StringHelper.hasText((String)this.m_sServiceValue);
    }

    @Nonnull
    public final EChange setService(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sServiceValue)) {
            return EChange.UNCHANGED;
        }
        this.m_sServiceValue = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getServiceType() {
        return this.m_sServiceType;
    }

    public final boolean hasServiceType() {
        return StringHelper.hasText((String)this.m_sServiceType);
    }

    @Nonnull
    public final EChange setServiceType(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sServiceType)) {
            return EChange.UNCHANGED;
        }
        this.m_sServiceType = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getAction() {
        return this.m_sAction;
    }

    public final boolean hasAction() {
        return StringHelper.hasText((String)this.m_sAction);
    }

    @Nonnull
    public final EChange setAction(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sAction)) {
            return EChange.UNCHANGED;
        }
        this.m_sAction = string;
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<String, PModeProperty> properties() {
        return this.m_aProperties;
    }

    public final void addProperty(@Nonnull PModeProperty pModeProperty) {
        ValueEnforcer.notNull((Object)pModeProperty, (String)"Property");
        String string = pModeProperty.getName();
        if (this.m_aProperties.containsKey((Object)string)) {
            throw new IllegalArgumentException("A property with the name '" + string + "' is already registered!");
        }
        this.m_aProperties.put((Object)string, (Object)pModeProperty);
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<String, PModePayloadProfile> payloadProfiles() {
        return this.m_aPayloadProfiles;
    }

    public final void addPayloadProfile(@Nonnull PModePayloadProfile pModePayloadProfile) {
        ValueEnforcer.notNull((Object)pModePayloadProfile, (String)"PayloadProfile");
        String string = pModePayloadProfile.getName();
        if (this.m_aPayloadProfiles.containsKey((Object)string)) {
            throw new IllegalArgumentException("A payload profile with the name '" + string + "' is already registered!");
        }
        this.m_aPayloadProfiles.put((Object)string, (Object)pModePayloadProfile);
    }

    @Nullable
    public final Long getPayloadProfileMaxKB() {
        return this.m_aPayloadProfileMaxKB;
    }

    public final boolean hasPayloadProfileMaxKB() {
        return this.m_aPayloadProfileMaxKB != null;
    }

    @Nonnull
    public final EChange setPayloadProfileMaxKB(@Nullable Long l) {
        if (EqualsHelper.equals((Object)l, (Object)this.m_aPayloadProfileMaxKB)) {
            return EChange.UNCHANGED;
        }
        this.m_aPayloadProfileMaxKB = l;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setPayloadProfileMaxKB(long l) {
        return this.setPayloadProfileMaxKB((Long)l);
    }

    @Nullable
    public final String getMPCID() {
        return this.m_sMPCID;
    }

    public final boolean hasMPCID() {
        return StringHelper.hasText((String)this.m_sMPCID);
    }

    @Nonnull
    public final EChange setMPCID(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sMPCID)) {
            return EChange.UNCHANGED;
        }
        this.m_sMPCID = string;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeLegBusinessInformation pModeLegBusinessInformation = (PModeLegBusinessInformation)object;
        return EqualsHelper.equals((Object)this.m_sServiceValue, (Object)pModeLegBusinessInformation.m_sServiceValue) && EqualsHelper.equals((Object)this.m_sServiceType, (Object)pModeLegBusinessInformation.m_sServiceType) && EqualsHelper.equals((Object)this.m_sAction, (Object)pModeLegBusinessInformation.m_sAction) && this.m_aProperties.equals(pModeLegBusinessInformation.m_aProperties) && this.m_aPayloadProfiles.equals(pModeLegBusinessInformation.m_aPayloadProfiles) && EqualsHelper.equals((Object)this.m_aPayloadProfileMaxKB, (Object)pModeLegBusinessInformation.m_aPayloadProfileMaxKB) && EqualsHelper.equals((Object)this.m_sMPCID, (Object)pModeLegBusinessInformation.m_sMPCID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sServiceValue).append((Object)this.m_sServiceType).append((Object)this.m_sAction).append(this.m_aProperties).append(this.m_aPayloadProfiles).append((Object)this.m_aPayloadProfileMaxKB).append((Object)this.m_sMPCID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Service", (Object)this.m_sServiceValue).appendIfNotNull("ServiceType", (Object)this.m_sServiceType).appendIfNotNull("Action", (Object)this.m_sAction).appendIf("Properties", this.m_aProperties, ICommonsMap::isNotEmpty).appendIf("PayloadProfiles", this.m_aPayloadProfiles, ICommonsMap::isNotEmpty).appendIfNotNull("PayloadProfileMaxMB", (Object)this.m_aPayloadProfileMaxKB).appendIfNotNull("MPCID", (Object)this.m_sMPCID).getToString();
    }

    @Nonnull
    public static PModeLegBusinessInformation create(@Nullable String string, @Nullable String string2, @Nullable Long l, @Nullable String string3) {
        return new PModeLegBusinessInformation(string, null, string2, null, null, l, string3);
    }
}

