/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import com.helger.phase4.model.pmode.leg.PModePayloadProfileJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeProperty;
import com.helger.phase4.model.pmode.leg.PModePropertyJsonConverter;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeLegBusinessInformationJsonConverter {
    private static final String SERVICE = "Service";
    private static final String SERVICE_TYPE = "ServiceType";
    private static final String ACTION = "Action";
    private static final String PROPERTIES = "Properties";
    private static final String PAYLOAD_PROFILE = "PayloadProfile";
    private static final String PAYLOAD_PROFILE_MAX_KB = "PayloadProfileMaxKB";
    private static final String MPCID = "MPCID";

    private PModeLegBusinessInformationJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLegBusinessInformation pModeLegBusinessInformation) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLegBusinessInformation.hasService()) {
            jsonObject.add(SERVICE, (Object)pModeLegBusinessInformation.getService());
        }
        if (pModeLegBusinessInformation.hasServiceType()) {
            jsonObject.add(SERVICE_TYPE, (Object)pModeLegBusinessInformation.getServiceType());
        }
        if (pModeLegBusinessInformation.hasAction()) {
            jsonObject.add(ACTION, (Object)pModeLegBusinessInformation.getAction());
        }
        if (pModeLegBusinessInformation.properties().isNotEmpty()) {
            jsonObject.addJson(PROPERTIES, (IJson)new JsonArray().addAllMapped((Iterable)pModeLegBusinessInformation.properties().values(), PModePropertyJsonConverter::convertToJson));
        }
        if (pModeLegBusinessInformation.payloadProfiles().isNotEmpty()) {
            jsonObject.addJson(PAYLOAD_PROFILE, (IJson)new JsonArray().addAllMapped((Iterable)pModeLegBusinessInformation.payloadProfiles().values(), PModePayloadProfileJsonConverter::convertToJson));
        }
        if (pModeLegBusinessInformation.hasPayloadProfileMaxKB()) {
            jsonObject.add(PAYLOAD_PROFILE_MAX_KB, pModeLegBusinessInformation.getPayloadProfileMaxKB().longValue());
        }
        if (pModeLegBusinessInformation.hasMPCID()) {
            jsonObject.add(MPCID, (Object)pModeLegBusinessInformation.getMPCID());
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeLegBusinessInformation convertToNative(@Nonnull IJsonObject iJsonObject) {
        String string5;
        Object object;
        IJsonArray iJsonArray3;
        String string2 = iJsonObject.getAsString((Object)SERVICE);
        String string3 = iJsonObject.getAsString((Object)SERVICE_TYPE);
        String string4 = iJsonObject.getAsString((Object)ACTION);
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        IJsonArray iJsonArray2 = iJsonObject.getAsArray(PROPERTIES);
        if (iJsonArray2 != null) {
            for (IJsonArray iJsonArray3 : iJsonArray2.iteratorObjects()) {
                object = PModePropertyJsonConverter.convertToNative((IJsonObject)iJsonArray3);
                commonsLinkedHashMap.put((Object)((PModeProperty)object).getName(), object);
            }
        }
        Iterator iterator = new CommonsLinkedHashMap();
        iJsonArray3 = iJsonObject.getAsArray(PAYLOAD_PROFILE);
        if (iJsonArray3 != null) {
            for (String string5 : iJsonArray3.iteratorObjects()) {
                PModePayloadProfile pModePayloadProfile = PModePayloadProfileJsonConverter.convertToNative((IJsonObject)string5);
                iterator.put(pModePayloadProfile.getName(), pModePayloadProfile);
            }
        }
        object = iJsonObject.getAsLongObj((Object)PAYLOAD_PROFILE_MAX_KB);
        string5 = iJsonObject.getAsString((Object)MPCID);
        return new PModeLegBusinessInformation(string2, string3, string4, (ICommonsOrderedMap<String, PModeProperty>)commonsLinkedHashMap, (ICommonsOrderedMap<String, PModePayloadProfile>)iterator, (Long)object, string5);
    }
}

