/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.state.ETriState;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.PModeAddressList;
import com.helger.phase4.model.pmode.leg.PModeAddressListJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeLegErrorHandlingJsonConverter {
    private static final String REPORT_SENDER_ERRORS_TO = "ReportSenderErrorsTo";
    private static final String REPORT_RECEIVER_ERRORS_TO = "ReportReceiverErrorsTo";
    private static final String REPORT_AS_RESPONSE = "ReportAsResponse";
    private static final String REPORT_PROCESS_ERROR_NOTFIY_CONSUMER = "ReportProcessErrorNotifyConsumer";
    private static final String REPORT_PROCESS_ERROR_NOTFIY_PRODUCER = "ReportProcessErrorNotifyProducer";
    private static final String REPORT_DELIVERY_FAILURE_NOTFIY_PRODUCER = "ReportDeliveryFailuresNotifyProducer";

    private PModeLegErrorHandlingJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLegErrorHandling pModeLegErrorHandling) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLegErrorHandling.hasReportSenderErrorsTo()) {
            jsonObject.addJson(REPORT_SENDER_ERRORS_TO, (IJson)PModeAddressListJsonConverter.convertToJson(pModeLegErrorHandling.getReportSenderErrorsTo()));
        }
        if (pModeLegErrorHandling.hasReportReceiverErrorsTo()) {
            jsonObject.addJson(REPORT_RECEIVER_ERRORS_TO, (IJson)PModeAddressListJsonConverter.convertToJson(pModeLegErrorHandling.getReportReceiverErrorsTo()));
        }
        if (pModeLegErrorHandling.isReportAsResponseDefined()) {
            jsonObject.add(REPORT_AS_RESPONSE, pModeLegErrorHandling.isReportAsResponse());
        }
        if (pModeLegErrorHandling.isReportProcessErrorNotifyConsumerDefined()) {
            jsonObject.add(REPORT_PROCESS_ERROR_NOTFIY_CONSUMER, pModeLegErrorHandling.isReportProcessErrorNotifyConsumer());
        }
        if (pModeLegErrorHandling.isReportProcessErrorNotifyProducerDefined()) {
            jsonObject.add(REPORT_PROCESS_ERROR_NOTFIY_PRODUCER, pModeLegErrorHandling.isReportProcessErrorNotifyProducer());
        }
        if (pModeLegErrorHandling.isReportDeliveryFailuresNotifyProducerDefined()) {
            jsonObject.add(REPORT_DELIVERY_FAILURE_NOTFIY_PRODUCER, pModeLegErrorHandling.isReportDeliveryFailuresNotifyProducer());
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeLegErrorHandling convertToNative(@Nonnull IJsonObject iJsonObject) {
        IJsonArray iJsonArray = iJsonObject.getAsArray(REPORT_SENDER_ERRORS_TO);
        PModeAddressList pModeAddressList = iJsonArray == null ? null : PModeAddressListJsonConverter.convertToNative(iJsonArray);
        IJsonArray iJsonArray2 = iJsonObject.getAsArray(REPORT_RECEIVER_ERRORS_TO);
        PModeAddressList pModeAddressList2 = iJsonArray2 == null ? null : PModeAddressListJsonConverter.convertToNative(iJsonArray2);
        ETriState eTriState = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)REPORT_AS_RESPONSE), false);
        ETriState eTriState2 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)REPORT_PROCESS_ERROR_NOTFIY_CONSUMER), false);
        ETriState eTriState3 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)REPORT_PROCESS_ERROR_NOTFIY_PRODUCER), false);
        ETriState eTriState4 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)REPORT_DELIVERY_FAILURE_NOTFIY_PRODUCER), false);
        return new PModeLegErrorHandling(pModeAddressList, pModeAddressList2, eTriState, eTriState2, eTriState3, eTriState4);
    }
}

