/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformationJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandlingJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.model.pmode.leg.PModeLegProtocolJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegReliability;
import com.helger.phase4.model.pmode.leg.PModeLegReliabilityJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.model.pmode.leg.PModeLegSecurityJsonConverter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeLegJsonConverter {
    private static final String PROTOCOL = "Protocol";
    private static final String BUSINESS_INFORMATION = "BusinessInfo";
    private static final String ERROR_HANDLING = "ErrorHandling";
    private static final String RELIABILITY = "Reliability";
    private static final String SECURITY = "Security";

    private PModeLegJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLeg pModeLeg) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLeg.hasProtocol()) {
            jsonObject.addJson(PROTOCOL, (IJson)PModeLegProtocolJsonConverter.convertToJson(pModeLeg.getProtocol()));
        }
        if (pModeLeg.hasBusinessInfo()) {
            jsonObject.addJson(BUSINESS_INFORMATION, (IJson)PModeLegBusinessInformationJsonConverter.convertToJson(pModeLeg.getBusinessInfo()));
        }
        if (pModeLeg.hasErrorHandling()) {
            jsonObject.addJson(ERROR_HANDLING, (IJson)PModeLegErrorHandlingJsonConverter.convertToJson(pModeLeg.getErrorHandling()));
        }
        if (pModeLeg.hasReliability()) {
            jsonObject.addJson(RELIABILITY, (IJson)PModeLegReliabilityJsonConverter.convertToJson(pModeLeg.getReliability()));
        }
        if (pModeLeg.hasSecurity()) {
            jsonObject.addJson(SECURITY, (IJson)PModeLegSecurityJsonConverter.convertToJson(pModeLeg.getSecurity()));
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeLeg convertToNative(@Nonnull IJsonObject iJsonObject) {
        IJsonObject iJsonObject2 = iJsonObject.getAsObject(PROTOCOL);
        PModeLegProtocol pModeLegProtocol = iJsonObject2 == null ? null : PModeLegProtocolJsonConverter.convertToNative(iJsonObject2);
        IJsonObject iJsonObject3 = iJsonObject.getAsObject(BUSINESS_INFORMATION);
        PModeLegBusinessInformation pModeLegBusinessInformation = iJsonObject3 == null ? null : PModeLegBusinessInformationJsonConverter.convertToNative(iJsonObject3);
        IJsonObject iJsonObject4 = iJsonObject.getAsObject(ERROR_HANDLING);
        PModeLegErrorHandling pModeLegErrorHandling = iJsonObject4 == null ? null : PModeLegErrorHandlingJsonConverter.convertToNative(iJsonObject4);
        IJsonObject iJsonObject5 = iJsonObject.getAsObject(RELIABILITY);
        PModeLegReliability pModeLegReliability = iJsonObject5 == null ? null : PModeLegReliabilityJsonConverter.convertToNative(iJsonObject5);
        IJsonObject iJsonObject6 = iJsonObject.getAsObject(SECURITY);
        PModeLegSecurity pModeLegSecurity = iJsonObject6 == null ? null : PModeLegSecurityJsonConverter.convertToNative(iJsonObject6);
        return new PModeLeg(pModeLegProtocol, pModeLegBusinessInformation, pModeLegErrorHandling, pModeLegReliability, pModeLegSecurity);
    }
}

