/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.soap.ESoapVersion;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeLegProtocolJsonConverter {
    private static final String ADDRESS = "Address";
    private static final String SOAP_VERSION = "SoapVersion";

    private PModeLegProtocolJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLegProtocol pModeLegProtocol) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLegProtocol.hasAddress()) {
            jsonObject.add(ADDRESS, (Object)pModeLegProtocol.getAddress());
        }
        jsonObject.add(SOAP_VERSION, (Object)pModeLegProtocol.getSoapVersion().getVersion());
        return jsonObject;
    }

    @Nonnull
    public static PModeLegProtocol convertToNative(@Nonnull IJsonObject iJsonObject) {
        String string = iJsonObject.getAsString((Object)ADDRESS);
        String string2 = iJsonObject.getAsString((Object)SOAP_VERSION);
        ESoapVersion eSoapVersion = ESoapVersion.getFromVersionOrNull(string2);
        if (eSoapVersion == null) {
            throw new IllegalStateException("Failed to resolve SOAP version '" + string2 + "'");
        }
        return new PModeLegProtocol(string, eSoapVersion);
    }
}

