/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ETriState;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.PModeLegReliability;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeLegReliabilityJsonConverter {
    private static final String AT_LEAST_ONCE_CONTRACT = "AtLeastOnceContract";
    private static final String AT_LEAST_ONCE_ACK_ON_DELIVERY = "AtLeastOnceAckOnDelivery";
    private static final String AT_LEAST_ONCE_CONTRACT_ACK_TO = "AtLeastOnceContractAcksTo";
    private static final String AT_LEAST_ONCE_CONTRACT_ACK_RESPONSE = "AtLeastOnceContractAckResponse";
    private static final String AT_LEAST_ONCE_REPLY_PATTERN = "AtLeastOnceReplyPattern";
    private static final String AT_MOST_ONCE_CONTRACT = "AtMostOnceContract";
    private static final String IN_ORDER_CONTRACT = "InOrderContract";
    private static final String START_GROUP = "StartGroup";
    private static final String CORRELATION = "Correlation";
    private static final String TERMINATE_GROUP = "TerminateGroup";

    private PModeLegReliabilityJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLegReliability pModeLegReliability) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLegReliability.isAtLeastOnceContractDefined()) {
            jsonObject.add(AT_LEAST_ONCE_CONTRACT, pModeLegReliability.isAtLeastOnceContract());
        }
        if (pModeLegReliability.isAtLeastOnceAckOnDeliveryDefined()) {
            jsonObject.add(AT_LEAST_ONCE_ACK_ON_DELIVERY, pModeLegReliability.isAtLeastOnceAckOnDelivery());
        }
        if (pModeLegReliability.hasAtLeastOnceContractAcksTo()) {
            jsonObject.add(AT_LEAST_ONCE_CONTRACT_ACK_TO, (Object)pModeLegReliability.getAtLeastOnceContractAcksTo());
        }
        if (pModeLegReliability.isAtLeastOnceContractAckResponseDefined()) {
            jsonObject.add(AT_LEAST_ONCE_CONTRACT_ACK_RESPONSE, pModeLegReliability.isAtLeastOnceContractAckResponse());
        }
        if (pModeLegReliability.hasAtLeastOnceReplyPattern()) {
            jsonObject.add(AT_LEAST_ONCE_REPLY_PATTERN, (Object)pModeLegReliability.getAtLeastOnceReplyPattern());
        }
        if (pModeLegReliability.isAtMostOnceContractDefined()) {
            jsonObject.add(AT_MOST_ONCE_CONTRACT, pModeLegReliability.isAtMostOnceContract());
        }
        if (pModeLegReliability.isInOrderContractDefined()) {
            jsonObject.add(IN_ORDER_CONTRACT, pModeLegReliability.isInOrderContract());
        }
        if (pModeLegReliability.isStartGroupDefined()) {
            jsonObject.add(START_GROUP, pModeLegReliability.isStartGroup());
        }
        if (pModeLegReliability.correlations().isNotEmpty()) {
            jsonObject.addJson(CORRELATION, (IJson)new JsonArray().addAll(pModeLegReliability.correlations()));
        }
        if (pModeLegReliability.isTerminateGroupDefined()) {
            jsonObject.add(TERMINATE_GROUP, pModeLegReliability.isTerminateGroup());
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeLegReliability convertToNative(@Nonnull IJsonObject iJsonObject) {
        ETriState eTriState = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)AT_LEAST_ONCE_CONTRACT), false);
        ETriState eTriState2 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)AT_LEAST_ONCE_ACK_ON_DELIVERY), false);
        String string = iJsonObject.getAsString((Object)AT_LEAST_ONCE_CONTRACT_ACK_TO);
        ETriState eTriState3 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)AT_LEAST_ONCE_CONTRACT_ACK_RESPONSE), false);
        String string2 = iJsonObject.getAsString((Object)AT_LEAST_ONCE_REPLY_PATTERN);
        ETriState eTriState4 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)AT_MOST_ONCE_CONTRACT), false);
        ETriState eTriState5 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)IN_ORDER_CONTRACT), false);
        ETriState eTriState6 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)START_GROUP), false);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IJsonArray iJsonArray = iJsonObject.getAsArray(CORRELATION);
        if (iJsonArray != null) {
            for (IJsonValue iJsonValue : iJsonArray.iteratorValues()) {
                commonsArrayList.add((Object)iJsonValue.getAsString());
            }
        }
        Iterator iterator = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)TERMINATE_GROUP), false);
        return new PModeLegReliability(eTriState, eTriState2, string, eTriState3, string2, eTriState4, eTriState5, eTriState6, (ICommonsList<String>)commonsArrayList, (ETriState)iterator);
    }
}

