/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.wss.EWSSVersion;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeLegSecurity
implements Serializable {
    public static final boolean DEFAULT_USERNAME_TOKEN_DIGEST = false;
    public static final boolean DEFAULT_USERNAME_TOKEN_NONCE = false;
    public static final boolean DEFAULT_USERNAME_TOKEN_CREATED = false;
    public static final boolean DEFAULT_PMODE_AUTHORIZE = false;
    public static final boolean DEFAULT_X509_SIGN = false;
    public static final boolean DEFAULT_X509_ENCRYPTION_ENCRYPT = false;
    public static final boolean DEFAULT_SEND_RECEIPT = false;
    public static final boolean DEFAULT_SEND_RECEIPT_NON_REPUDIATION = false;
    private EWSSVersion m_eWSSVersion;
    private final ICommonsList<String> m_aX509SignElements = new CommonsArrayList();
    private final ICommonsList<String> m_aX509SignAttachments = new CommonsArrayList();
    private String m_sX509SignatureCertificate;
    private ECryptoAlgorithmSignDigest m_eX509SignatureHashFunction;
    private ECryptoAlgorithmSign m_eX509SignatureAlgorithm;
    private final ICommonsList<String> m_aX509EncryptionEncryptElements = new CommonsArrayList();
    private final ICommonsList<String> m_aX509EncryptionEncryptAttachments = new CommonsArrayList();
    private String m_sX509EncryptionCertificate;
    private ECryptoAlgorithmCrypt m_eX509EncryptionAlgorithm;
    private Integer m_aX509EncryptionMinimumStrength;
    private String m_sUsernameTokenUsername;
    private String m_sUsernameTokenPassword;
    private ETriState m_eUsernameTokenDigest = ETriState.UNDEFINED;
    private ETriState m_eUsernameTokenNonce = ETriState.UNDEFINED;
    private ETriState m_eUsernameTokenCreated = ETriState.UNDEFINED;
    private ETriState m_ePModeAuthorize = ETriState.UNDEFINED;
    private ETriState m_eSendReceipt = ETriState.UNDEFINED;
    private EPModeSendReceiptReplyPattern m_eSendReceiptReplyPattern;
    private ETriState m_eSendReceiptNonRepudiation = ETriState.UNDEFINED;

    public PModeLegSecurity() {
    }

    public PModeLegSecurity(@Nullable EWSSVersion eWSSVersion, @Nullable ICommonsList<String> iCommonsList, @Nullable ICommonsList<String> iCommonsList2, @Nullable String string, @Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign, @Nullable ICommonsList<String> iCommonsList3, @Nullable ICommonsList<String> iCommonsList4, @Nullable String string2, @Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt, @Nullable Integer n, @Nullable String string3, @Nullable String string4, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2, @Nonnull ETriState eTriState3, @Nonnull ETriState eTriState4, @Nonnull ETriState eTriState5, @Nullable EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern, @Nonnull ETriState eTriState6) {
        this.setWSSVersion(eWSSVersion);
        this.setX509SignElements(iCommonsList);
        this.setX509SignAttachments(iCommonsList2);
        this.setX509SignatureCertificate(string);
        this.setX509SignatureHashFunction(eCryptoAlgorithmSignDigest);
        this.setX509SignatureAlgorithm(eCryptoAlgorithmSign);
        this.setX509EncryptionEncryptElements(iCommonsList3);
        this.setX509EncryptionEncryptAttachments(iCommonsList4);
        this.setX509EncryptionCertificate(string2);
        this.setX509EncryptionAlgorithm(eCryptoAlgorithmCrypt);
        this.setX509EncryptionMinimumStrength(n);
        this.setUsernameTokenUsername(string3);
        this.setUsernameTokenPassword(string4);
        this.setUsernameTokenDigest(eTriState);
        this.setUsernameTokenNonce(eTriState2);
        this.setUsernameTokenCreated(eTriState3);
        this.setPModeAuthorize(eTriState4);
        this.setSendReceipt(eTriState5);
        this.setSendReceiptReplyPattern(ePModeSendReceiptReplyPattern);
        this.setSendReceiptNonRepudiation(eTriState6);
    }

    @Nullable
    public final EWSSVersion getWSSVersion() {
        return this.m_eWSSVersion;
    }

    public final boolean hasWSSVersion() {
        return this.m_eWSSVersion != null;
    }

    @Nullable
    public final String getWSSVersionAsString() {
        return this.m_eWSSVersion == null ? null : this.m_eWSSVersion.getVersion();
    }

    @Nonnull
    public final EChange setWSSVersion(@Nullable EWSSVersion eWSSVersion) {
        if (EqualsHelper.equals((Object)((Object)eWSSVersion), (Object)((Object)this.m_eWSSVersion))) {
            return EChange.UNCHANGED;
        }
        this.m_eWSSVersion = eWSSVersion;
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> x509SignElements() {
        return this.m_aX509SignElements;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllX509SignElements() {
        return (ICommonsList)this.m_aX509SignElements.getClone();
    }

    @Nonnull
    public final EChange setX509SignElements(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509SignElements)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509SignElements.setAll(iCommonsList);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> x509SignAttachments() {
        return this.m_aX509SignAttachments;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllX509SignAttachments() {
        return (ICommonsList)this.m_aX509SignAttachments.getClone();
    }

    @Nonnull
    public final EChange setX509SignAttachments(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509SignAttachments)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509SignAttachments.setAll(iCommonsList);
        return EChange.CHANGED;
    }

    @Nullable
    public final String getX509SignatureCertificate() {
        return this.m_sX509SignatureCertificate;
    }

    public final boolean hasX509SignatureCertificate() {
        return StringHelper.hasText((String)this.m_sX509SignatureCertificate);
    }

    @Nonnull
    public final EChange setX509SignatureCertificate(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sX509SignatureCertificate)) {
            return EChange.UNCHANGED;
        }
        this.m_sX509SignatureCertificate = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final ECryptoAlgorithmSignDigest getX509SignatureHashFunction() {
        return this.m_eX509SignatureHashFunction;
    }

    public boolean hasX509SignatureHashFunction() {
        return this.m_eX509SignatureHashFunction != null;
    }

    @Nullable
    public final String getX509SignatureHashFunctionID() {
        return this.m_eX509SignatureHashFunction == null ? null : this.m_eX509SignatureHashFunction.getID();
    }

    @Nonnull
    public final EChange setX509SignatureHashFunction(@Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest) {
        if (EqualsHelper.equals((Object)((Object)eCryptoAlgorithmSignDigest), (Object)((Object)this.m_eX509SignatureHashFunction))) {
            return EChange.UNCHANGED;
        }
        this.m_eX509SignatureHashFunction = eCryptoAlgorithmSignDigest;
        return EChange.CHANGED;
    }

    @Nullable
    public final ECryptoAlgorithmSign getX509SignatureAlgorithm() {
        return this.m_eX509SignatureAlgorithm;
    }

    public final boolean hasX509SignatureAlgorithm() {
        return this.m_eX509SignatureAlgorithm != null;
    }

    @Nullable
    public final String getX509SignatureAlgorithmID() {
        return this.m_eX509SignatureAlgorithm == null ? null : this.m_eX509SignatureAlgorithm.getID();
    }

    @Nonnull
    public final EChange setX509SignatureAlgorithm(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        if (EqualsHelper.equals((Object)((Object)eCryptoAlgorithmSign), (Object)((Object)this.m_eX509SignatureAlgorithm))) {
            return EChange.UNCHANGED;
        }
        this.m_eX509SignatureAlgorithm = eCryptoAlgorithmSign;
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> x509EncryptionEncryptElements() {
        return this.m_aX509EncryptionEncryptElements;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllX509EncryptionEncryptElements() {
        return (ICommonsList)this.m_aX509EncryptionEncryptElements.getClone();
    }

    @Nonnull
    public final EChange setX509EncryptionEncryptElements(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509EncryptionEncryptElements)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509EncryptionEncryptElements.setAll(iCommonsList);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> x509EncryptionEncryptAttachments() {
        return this.m_aX509EncryptionEncryptAttachments;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllX509EncryptionEncryptAttachments() {
        return (ICommonsList)this.m_aX509EncryptionEncryptAttachments.getClone();
    }

    @Nonnull
    public final EChange setX509EncryptionEncryptAttachments(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509EncryptionEncryptAttachments)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509EncryptionEncryptAttachments.setAll(iCommonsList);
        return EChange.CHANGED;
    }

    @Nullable
    public final String getX509EncryptionCertificate() {
        return this.m_sX509EncryptionCertificate;
    }

    public final boolean hasX509EncryptionCertificate() {
        return StringHelper.hasText((String)this.m_sX509EncryptionCertificate);
    }

    @Nonnull
    public final EChange setX509EncryptionCertificate(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sX509EncryptionCertificate)) {
            return EChange.UNCHANGED;
        }
        this.m_sX509EncryptionCertificate = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final ECryptoAlgorithmCrypt getX509EncryptionAlgorithm() {
        return this.m_eX509EncryptionAlgorithm;
    }

    public final boolean hasX509EncryptionAlgorithm() {
        return this.m_eX509EncryptionAlgorithm != null;
    }

    @Nullable
    public final String getX509EncryptionAlgorithmID() {
        return this.m_eX509EncryptionAlgorithm == null ? null : this.m_eX509EncryptionAlgorithm.getID();
    }

    @Nonnull
    public final EChange setX509EncryptionAlgorithm(@Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        if (EqualsHelper.equals((Object)((Object)eCryptoAlgorithmCrypt), (Object)((Object)this.m_eX509EncryptionAlgorithm))) {
            return EChange.UNCHANGED;
        }
        this.m_eX509EncryptionAlgorithm = eCryptoAlgorithmCrypt;
        return EChange.CHANGED;
    }

    @Nullable
    public final Integer getX509EncryptionMinimumStrength() {
        return this.m_aX509EncryptionMinimumStrength;
    }

    public final boolean hasX509EncryptionMinimumStrength() {
        return this.m_aX509EncryptionMinimumStrength != null;
    }

    @Nonnull
    public final EChange setX509EncryptionMinimumStrength(@Nullable Integer n) {
        if (EqualsHelper.equals((Object)n, (Object)this.m_aX509EncryptionMinimumStrength)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509EncryptionMinimumStrength = n;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getUsernameTokenUsername() {
        return this.m_sUsernameTokenUsername;
    }

    public final boolean hasUsernameTokenUsername() {
        return StringHelper.hasText((String)this.m_sUsernameTokenUsername);
    }

    @Nonnull
    public final EChange setUsernameTokenUsername(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sUsernameTokenUsername)) {
            return EChange.UNCHANGED;
        }
        this.m_sUsernameTokenUsername = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getUsernameTokenPassword() {
        return this.m_sUsernameTokenPassword;
    }

    public final boolean hasUsernameTokenPassword() {
        return StringHelper.hasText((String)this.m_sUsernameTokenPassword);
    }

    @Nonnull
    public final EChange setUsernameTokenPassword(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sUsernameTokenPassword)) {
            return EChange.UNCHANGED;
        }
        this.m_sUsernameTokenPassword = string;
        return EChange.CHANGED;
    }

    public final boolean isUsernameTokenDigestDefined() {
        return this.m_eUsernameTokenDigest.isDefined();
    }

    public final boolean isUsernameTokenDigest() {
        return this.m_eUsernameTokenDigest.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setUsernameTokenDigest(boolean bl) {
        return this.setUsernameTokenDigest(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setUsernameTokenDigest(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"UsernameTokenDigest");
        if (eTriState.equals((Object)this.m_eUsernameTokenDigest)) {
            return EChange.UNCHANGED;
        }
        this.m_eUsernameTokenDigest = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isUsernameTokenNonceDefined() {
        return this.m_eUsernameTokenNonce.isDefined();
    }

    public final boolean isUsernameTokenNonce() {
        return this.m_eUsernameTokenNonce.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setUsernameTokenNonce(boolean bl) {
        return this.setUsernameTokenNonce(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setUsernameTokenNonce(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"UsernameTokenNonce");
        if (eTriState.equals((Object)this.m_eUsernameTokenNonce)) {
            return EChange.UNCHANGED;
        }
        this.m_eUsernameTokenNonce = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isUsernameTokenCreatedDefined() {
        return this.m_eUsernameTokenCreated.isDefined();
    }

    public final boolean isUsernameTokenCreated() {
        return this.m_eUsernameTokenCreated.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setUsernameTokenCreated(boolean bl) {
        return this.setUsernameTokenCreated(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setUsernameTokenCreated(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"UsernameTokenCreated");
        if (eTriState.equals((Object)this.m_eUsernameTokenCreated)) {
            return EChange.UNCHANGED;
        }
        this.m_eUsernameTokenCreated = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isPModeAuthorizeDefined() {
        return this.m_ePModeAuthorize.isDefined();
    }

    public final boolean isPModeAuthorize() {
        return this.m_ePModeAuthorize.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setPModeAuthorize(boolean bl) {
        return this.setPModeAuthorize(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setPModeAuthorize(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"PModeAuthorize");
        if (eTriState.equals((Object)this.m_ePModeAuthorize)) {
            return EChange.UNCHANGED;
        }
        this.m_ePModeAuthorize = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isSendReceiptDefined() {
        return this.m_eSendReceipt.isDefined();
    }

    public final boolean isSendReceipt() {
        return this.m_eSendReceipt.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setSendReceipt(boolean bl) {
        return this.setSendReceipt(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setSendReceipt(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"SendReceipt");
        if (eTriState.equals((Object)this.m_eSendReceipt)) {
            return EChange.UNCHANGED;
        }
        this.m_eSendReceipt = eTriState;
        return EChange.CHANGED;
    }

    @Nullable
    public final EPModeSendReceiptReplyPattern getSendReceiptReplyPattern() {
        return this.m_eSendReceiptReplyPattern;
    }

    @Nullable
    public final String getSendReceiptReplyPatternID() {
        return this.m_eSendReceiptReplyPattern == null ? null : this.m_eSendReceiptReplyPattern.getID();
    }

    public final boolean hasSendReceiptReplyPattern() {
        return this.m_eSendReceiptReplyPattern != null;
    }

    @Nonnull
    public final EChange setSendReceiptReplyPattern(@Nullable EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern) {
        if (EqualsHelper.equals((Object)((Object)ePModeSendReceiptReplyPattern), (Object)((Object)this.m_eSendReceiptReplyPattern))) {
            return EChange.UNCHANGED;
        }
        this.m_eSendReceiptReplyPattern = ePModeSendReceiptReplyPattern;
        return EChange.CHANGED;
    }

    public final boolean isSendReceiptNonRepudiationDefined() {
        return this.m_eSendReceiptNonRepudiation.isDefined();
    }

    public final boolean isSendReceiptNonRepudiation() {
        return this.m_eSendReceiptNonRepudiation.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setSendReceiptNonRepudiation(boolean bl) {
        return this.setSendReceiptNonRepudiation(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setSendReceiptNonRepudiation(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"SendReceiptNonRepudiation");
        if (eTriState.equals((Object)this.m_eSendReceiptNonRepudiation)) {
            return EChange.UNCHANGED;
        }
        this.m_eSendReceiptNonRepudiation = eTriState;
        return EChange.CHANGED;
    }

    public final void disableSigning() {
        this.setX509SignElements(null);
        this.setX509SignAttachments(null);
        this.setX509SignatureCertificate(null);
        this.setX509SignatureHashFunction(null);
        this.setX509SignatureAlgorithm(null);
    }

    public final void disableEncryption() {
        this.setX509EncryptionEncryptElements(null);
        this.setX509EncryptionEncryptAttachments(null);
        this.setX509EncryptionCertificate(null);
        this.setX509EncryptionAlgorithm(null);
        this.setX509EncryptionMinimumStrength(null);
    }

    public final void disableUsernameToken() {
        this.setUsernameTokenUsername(null);
        this.setUsernameTokenPassword(null);
        this.setUsernameTokenDigest(ETriState.UNDEFINED);
        this.setUsernameTokenNonce(ETriState.UNDEFINED);
        this.setUsernameTokenCreated(ETriState.UNDEFINED);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeLegSecurity pModeLegSecurity = (PModeLegSecurity)object;
        return EqualsHelper.equals((Object)((Object)this.m_eWSSVersion), (Object)((Object)pModeLegSecurity.m_eWSSVersion)) && EqualsHelper.equals(this.m_aX509SignElements, pModeLegSecurity.m_aX509SignElements) && EqualsHelper.equals(this.m_aX509SignAttachments, pModeLegSecurity.m_aX509SignAttachments) && EqualsHelper.equals((Object)this.m_sX509SignatureCertificate, (Object)pModeLegSecurity.m_sX509SignatureCertificate) && EqualsHelper.equals((Object)((Object)this.m_eX509SignatureHashFunction), (Object)((Object)pModeLegSecurity.m_eX509SignatureHashFunction)) && EqualsHelper.equals((Object)((Object)this.m_eX509SignatureAlgorithm), (Object)((Object)pModeLegSecurity.m_eX509SignatureAlgorithm)) && EqualsHelper.equals(this.m_aX509EncryptionEncryptElements, pModeLegSecurity.m_aX509EncryptionEncryptElements) && EqualsHelper.equals(this.m_aX509EncryptionEncryptAttachments, pModeLegSecurity.m_aX509EncryptionEncryptAttachments) && EqualsHelper.equals((Object)this.m_sX509EncryptionCertificate, (Object)pModeLegSecurity.m_sX509EncryptionCertificate) && EqualsHelper.equals((Object)((Object)this.m_eX509EncryptionAlgorithm), (Object)((Object)pModeLegSecurity.m_eX509EncryptionAlgorithm)) && EqualsHelper.equals((Object)this.m_aX509EncryptionMinimumStrength, (Object)pModeLegSecurity.m_aX509EncryptionMinimumStrength) && EqualsHelper.equals((Object)this.m_sUsernameTokenUsername, (Object)pModeLegSecurity.m_sUsernameTokenUsername) && EqualsHelper.equals((Object)this.m_sUsernameTokenPassword, (Object)pModeLegSecurity.m_sUsernameTokenPassword) && EqualsHelper.equals((Object)this.m_eUsernameTokenDigest, (Object)pModeLegSecurity.m_eUsernameTokenDigest) && EqualsHelper.equals((Object)this.m_eUsernameTokenNonce, (Object)pModeLegSecurity.m_eUsernameTokenNonce) && EqualsHelper.equals((Object)this.m_eUsernameTokenCreated, (Object)pModeLegSecurity.m_eUsernameTokenCreated) && EqualsHelper.equals((Object)this.m_ePModeAuthorize, (Object)pModeLegSecurity.m_ePModeAuthorize) && EqualsHelper.equals((Object)this.m_eSendReceipt, (Object)pModeLegSecurity.m_eSendReceipt) && EqualsHelper.equals((Object)((Object)this.m_eSendReceiptReplyPattern), (Object)((Object)pModeLegSecurity.m_eSendReceiptReplyPattern)) && EqualsHelper.equals((Object)this.m_eSendReceiptNonRepudiation, (Object)pModeLegSecurity.m_eSendReceiptNonRepudiation);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eWSSVersion).append(this.m_aX509SignElements).append(this.m_aX509SignAttachments).append((Object)this.m_sX509SignatureCertificate).append((Enum)this.m_eX509SignatureHashFunction).append((Enum)this.m_eX509SignatureAlgorithm).append(this.m_aX509EncryptionEncryptElements).append(this.m_aX509EncryptionEncryptAttachments).append((Object)this.m_sX509EncryptionCertificate).append((Enum)this.m_eX509EncryptionAlgorithm).append((Object)this.m_aX509EncryptionMinimumStrength).append((Object)this.m_sUsernameTokenUsername).append((Object)this.m_sUsernameTokenPassword).append((Enum)this.m_eUsernameTokenDigest).append((Enum)this.m_eUsernameTokenNonce).append((Enum)this.m_eUsernameTokenCreated).append((Enum)this.m_ePModeAuthorize).append((Enum)this.m_eSendReceipt).append((Enum)this.m_eSendReceiptReplyPattern).append((Enum)this.m_eSendReceiptNonRepudiation).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("WSSVersion", (Enum)this.m_eWSSVersion).append("X509SignElement", this.m_aX509SignElements).append("X509SignAttachment", this.m_aX509SignAttachments).append("X509SignatureCertificate", (Object)this.m_sX509SignatureCertificate).append("X509SignatureHashFunction", (Enum)this.m_eX509SignatureHashFunction).append("X509SignatureAlgorithm", (Enum)this.m_eX509SignatureAlgorithm).append("X509EncryptionEncryptElement", this.m_aX509EncryptionEncryptElements).append("X509EncryptionEncryptAttachment", this.m_aX509EncryptionEncryptAttachments).append("X509EncryptionCertificate", (Object)this.m_sX509EncryptionCertificate).append("X509EncryptionAlgorithm", (Enum)this.m_eX509EncryptionAlgorithm).append("X509EncryptionMinimumStrength", (Object)this.m_aX509EncryptionMinimumStrength).append("UsernameTokenUsername", (Object)this.m_sUsernameTokenUsername).append("UsernameTokenPassword", (Object)this.m_sUsernameTokenPassword).append("UsernameTokenDigest", (Enum)this.m_eUsernameTokenDigest).append("UsernameTokenNonce", (Enum)this.m_eUsernameTokenNonce).append("UsernameTokenCreated", (Enum)this.m_eUsernameTokenCreated).append("PModeAuthorize", (Enum)this.m_ePModeAuthorize).append("SendReceipt", (Enum)this.m_eSendReceipt).append("SendReceiptReplyPattern", (Enum)this.m_eSendReceiptReplyPattern).append("SendReceiptNonRepudiation", (Enum)this.m_eSendReceiptNonRepudiation).getToString();
    }
}

