/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ETriState;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.wss.EWSSVersion;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModeLegSecurityJsonConverter {
    private static final String ATTR_WSS_VERSION = "WSSVersion";
    private static final String ELEMENT_X509_SIGN_ELEMENT = "X509SignElement";
    private static final String ELEMENT_X509_SIGN_ATTACHMENT = "X509SignAttachment";
    private static final String ELEMENT_X509_SIGNATURE_CERTIFICATE = "X509SignatureCertificate";
    private static final String ATTR_X509_SIGNATURE_HASH_FUNCTION = "X509SignatureHashFunction";
    private static final String ATTR_X509_SIGNATURE_ALGORITHM = "X509SignatureAlgorithm";
    private static final String ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT = "X509EncryptionEncryptElement";
    private static final String ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT = "X509EncryptionEncryptAttachment";
    private static final String ELEMENT_X509_ENCRYPTION_CERTIFICATE = "X509EncryptionCertificate";
    private static final String ATTR_X509_ENCRYPTION_ALGORITHM = "X509EncryptionAlgorithm";
    private static final String ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH = "X509EncryptionMinimumStrength";
    private static final String ATTR_USERNAME_TOKEN_USERNAME = "UsernameTokenUsername";
    private static final String ATTR_USERNAME_TOKEN_PASSWORD = "UsernameTokenPassword";
    private static final String ATTR_USERNAME_TOKEN_DIGEST = "UsernameTokenDigest";
    private static final String ATTR_USERNAME_TOKEN_NONCE = "UsernameTokenNonce";
    private static final String ATTR_USERNAME_TOKEN_CREATED = "UsernameTokenCreated";
    private static final String ATTR_PMODE_AUTHORIZE = "PModeAuthorize";
    private static final String ATTR_SEND_RECEIPT = "SendReceipt";
    private static final String ATTR_SEND_RECEIPT_REPLY_PATTERN = "SendReceiptReplyPattern";
    private static final String ATTR_SEND_RECEIPT_NON_REPUDIATION = "SendReceiptNonRepudiation";

    private PModeLegSecurityJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLegSecurity pModeLegSecurity) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLegSecurity.hasWSSVersion()) {
            jsonObject.add(ATTR_WSS_VERSION, (Object)pModeLegSecurity.getWSSVersionAsString());
        }
        if (pModeLegSecurity.x509SignElements().isNotEmpty()) {
            jsonObject.addJson(ELEMENT_X509_SIGN_ELEMENT, (IJson)new JsonArray().addAll(pModeLegSecurity.x509SignElements()));
        }
        if (pModeLegSecurity.x509SignAttachments().isNotEmpty()) {
            jsonObject.addJson(ELEMENT_X509_SIGN_ATTACHMENT, (IJson)new JsonArray().addAll(pModeLegSecurity.x509SignAttachments()));
        }
        if (pModeLegSecurity.hasX509SignatureCertificate()) {
            jsonObject.add(ELEMENT_X509_SIGNATURE_CERTIFICATE, (Object)pModeLegSecurity.getX509SignatureCertificate());
        }
        if (pModeLegSecurity.hasX509SignatureHashFunction()) {
            jsonObject.add(ATTR_X509_SIGNATURE_HASH_FUNCTION, (Object)pModeLegSecurity.getX509SignatureHashFunctionID());
        }
        if (pModeLegSecurity.hasX509SignatureAlgorithm()) {
            jsonObject.add(ATTR_X509_SIGNATURE_ALGORITHM, (Object)pModeLegSecurity.getX509SignatureAlgorithmID());
        }
        if (pModeLegSecurity.x509EncryptionEncryptElements().isNotEmpty()) {
            jsonObject.addJson(ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT, (IJson)new JsonArray().addAll(pModeLegSecurity.x509EncryptionEncryptElements()));
        }
        if (pModeLegSecurity.x509EncryptionEncryptAttachments().isNotEmpty()) {
            jsonObject.addJson(ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT, (IJson)new JsonArray().addAll(pModeLegSecurity.x509EncryptionEncryptAttachments()));
        }
        if (pModeLegSecurity.hasX509EncryptionCertificate()) {
            jsonObject.add(ELEMENT_X509_ENCRYPTION_CERTIFICATE, (Object)pModeLegSecurity.getX509EncryptionCertificate());
        }
        jsonObject.add(ATTR_X509_ENCRYPTION_ALGORITHM, (Object)pModeLegSecurity.getX509EncryptionAlgorithmID());
        if (pModeLegSecurity.hasX509EncryptionMinimumStrength()) {
            jsonObject.add(ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH, pModeLegSecurity.getX509EncryptionMinimumStrength().intValue());
        }
        if (pModeLegSecurity.hasUsernameTokenUsername()) {
            jsonObject.add(ATTR_USERNAME_TOKEN_USERNAME, (Object)pModeLegSecurity.getUsernameTokenUsername());
        }
        if (pModeLegSecurity.hasUsernameTokenPassword()) {
            jsonObject.add(ATTR_USERNAME_TOKEN_PASSWORD, (Object)pModeLegSecurity.getUsernameTokenPassword());
        }
        if (pModeLegSecurity.isUsernameTokenDigestDefined()) {
            jsonObject.add(ATTR_USERNAME_TOKEN_DIGEST, pModeLegSecurity.isUsernameTokenDigest());
        }
        if (pModeLegSecurity.isUsernameTokenNonceDefined()) {
            jsonObject.add(ATTR_USERNAME_TOKEN_NONCE, pModeLegSecurity.isUsernameTokenNonce());
        }
        if (pModeLegSecurity.isUsernameTokenCreatedDefined()) {
            jsonObject.add(ATTR_USERNAME_TOKEN_CREATED, pModeLegSecurity.isUsernameTokenCreated());
        }
        if (pModeLegSecurity.isPModeAuthorizeDefined()) {
            jsonObject.add(ATTR_PMODE_AUTHORIZE, pModeLegSecurity.isPModeAuthorize());
        }
        if (pModeLegSecurity.isSendReceiptDefined()) {
            jsonObject.add(ATTR_SEND_RECEIPT, pModeLegSecurity.isSendReceipt());
        }
        if (pModeLegSecurity.hasSendReceiptReplyPattern()) {
            jsonObject.add(ATTR_SEND_RECEIPT_REPLY_PATTERN, (Object)pModeLegSecurity.getSendReceiptReplyPatternID());
        }
        if (pModeLegSecurity.isSendReceiptNonRepudiationDefined()) {
            jsonObject.add(ATTR_SEND_RECEIPT_NON_REPUDIATION, pModeLegSecurity.isSendReceiptNonRepudiation());
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeLegSecurity convertToNative(@Nonnull IJsonObject iJsonObject) {
        String string6;
        IJsonArray iJsonArray5;
        String string22;
        IJsonArray iJsonArray22;
        String string3 = iJsonObject.getAsString((Object)ATTR_WSS_VERSION);
        EWSSVersion eWSSVersion = EWSSVersion.getFromVersionOrNull(string3);
        if (eWSSVersion == null && string3 != null) {
            throw new IllegalStateException("Invalid WSS version '" + string3 + "'");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IJsonArray iJsonArray3 = iJsonObject.getAsArray(ELEMENT_X509_SIGN_ELEMENT);
        if (iJsonArray3 != null) {
            for (IJsonArray iJsonArray22 : iJsonArray3.iteratorValues()) {
                commonsArrayList.add((Object)iJsonArray22.getAsString());
            }
        }
        Iterator iterator = new CommonsArrayList();
        iJsonArray22 = iJsonObject.getAsArray(ELEMENT_X509_SIGN_ATTACHMENT);
        if (iJsonArray22 != null) {
            for (String string22 : iJsonArray22.iteratorValues()) {
                iterator.add(string22.getAsString());
            }
        }
        String string4 = iJsonObject.getAsString((Object)ELEMENT_X509_SIGNATURE_CERTIFICATE);
        string22 = iJsonObject.getAsString((Object)ATTR_X509_SIGNATURE_HASH_FUNCTION);
        ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest = ECryptoAlgorithmSignDigest.getFromIDOrNull(string22);
        if (eCryptoAlgorithmSignDigest == null && string22 != null) {
            throw new IllegalStateException("Invalid signature hash function '" + string22 + "'");
        }
        String string5 = iJsonObject.getAsString((Object)ATTR_X509_SIGNATURE_ALGORITHM);
        ECryptoAlgorithmSign eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull(string5);
        if (eCryptoAlgorithmSign == null && string5 != null) {
            throw new IllegalStateException("Invalid signature algorithm '" + string5 + "'");
        }
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        IJsonArray iJsonArray4 = iJsonObject.getAsArray(ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT);
        if (iJsonArray4 != null) {
            for (IJsonArray iJsonArray5 : iJsonArray4.iteratorValues()) {
                commonsArrayList2.add((Object)iJsonArray5.getAsString());
            }
        }
        Iterator iterator2 = new CommonsArrayList();
        iJsonArray5 = iJsonObject.getAsArray(ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT);
        if (iJsonArray5 != null) {
            for (String string6 : iJsonArray5.iteratorValues()) {
                iterator2.add(string6.getAsString());
            }
        }
        String string7 = iJsonObject.getAsString((Object)ELEMENT_X509_ENCRYPTION_CERTIFICATE);
        string6 = iJsonObject.getAsString((Object)ATTR_X509_ENCRYPTION_ALGORITHM);
        ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt = ECryptoAlgorithmCrypt.getFromIDOrNull(string6);
        if (eCryptoAlgorithmCrypt == null && string6 != null) {
            throw new IllegalStateException("Invalid encrypt algorithm '" + string6 + "'");
        }
        Integer n = iJsonObject.getAsIntObj((Object)ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH);
        String string8 = iJsonObject.getAsString((Object)ATTR_USERNAME_TOKEN_USERNAME);
        String string9 = iJsonObject.getAsString((Object)ATTR_USERNAME_TOKEN_PASSWORD);
        ETriState eTriState = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)ATTR_USERNAME_TOKEN_DIGEST), false);
        ETriState eTriState2 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)ATTR_USERNAME_TOKEN_NONCE), false);
        ETriState eTriState3 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)ATTR_USERNAME_TOKEN_CREATED), false);
        ETriState eTriState4 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)ATTR_PMODE_AUTHORIZE), false);
        ETriState eTriState5 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)ATTR_SEND_RECEIPT), false);
        String string10 = iJsonObject.getAsString((Object)ATTR_SEND_RECEIPT_REPLY_PATTERN);
        EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern = EPModeSendReceiptReplyPattern.getFromIDOrNull(string10);
        if (ePModeSendReceiptReplyPattern == null && string10 != null) {
            throw new IllegalStateException("Invalid SendReceipt ReplyPattern version '" + string10 + "'");
        }
        ETriState eTriState6 = AbstractPModeMicroTypeConverter.getTriState(iJsonObject.getAsString((Object)ATTR_SEND_RECEIPT_NON_REPUDIATION), false);
        return new PModeLegSecurity(eWSSVersion, (ICommonsList<String>)commonsArrayList, (ICommonsList<String>)iterator, string4, eCryptoAlgorithmSignDigest, eCryptoAlgorithmSign, (ICommonsList<String>)commonsArrayList2, (ICommonsList<String>)iterator2, string7, eCryptoAlgorithmCrypt, n, string8, string9, eTriState, eTriState2, eTriState3, eTriState4, eTriState5, ePModeSendReceiptReplyPattern, eTriState6);
    }
}

